/* $Id: interp.h,v 1.1.1.1 1993/06/03 06:23:46 david Exp $
 * interp.h -- Definitions for interp module.
 *
 * PUBLIC FUNCTIONS:
 *
 * Int_CreateInterp(interp, name) -- Create a new one of these interpretors.
 *	Returns `struct interpInfo' or NULL if it could not be created.
 *
 * Int_findInterp(name) -- Finds the interpInfo matching the name.  If
 *	none, then return NULL;
 *
 * Int_whoIs(interp) -- Finds the interpInfo matching a TCL interpretor.
 *
 * Int_delInterp(info) -- Deletes all the information associated with
 *	one of these interpretors.  First runs the destroyHook if
 *	there is one.
 *
 *
 * $Log: interp.h,v $
 * Revision 1.1.1.1  1993/06/03  06:23:46  david
 * Initial revision of `minterp' as its own package.
 *
 * Revision 1.3  1993/06/01  05:09:17  david
 * Massive cleanup and rearrangement.  Removed the policy decisions which had been
 * made in C code before, and moved them to interpBaseC.tcl.  Left behind the
 * necessary underlying functionality.  Created ability to prevent -exec from
 * outside the interpretor.  Etc.
 *
 * Revision 1.2  1993/04/14  07:17:46  david
 * Massive changes in latest round of changing.  Am moving many
 * things into TCL code to allow greatest flexibility, while leaving
 * behind lower level operations as C functions.  The changes are not
 * finished nor finalized, but they are in a Working State.
 *
 * Revision 1.1  1993/01/25  06:32:11  david
 * Initial revisions of the interp module, documentation, and file browser.
 *
 *
 */

#ifndef __INTERP_H__DSH__
#define __INTERP_H__DSH__


#ifndef isstr
#define isstr(s) ((s) && (s)[0])
#endif

struct interpInfo {
	Tcl_Interp *interp;		/* Which interpretor it is */
	char	   *name;		/* What its name is */
	char	   *destroyHook;	/* What to do before killing it */
	short	    allowExec;		/* Allow for -exec to happen here */
	Tcl_HashTable methods;		/* Table of `method' names */
};

extern void   init_interp _ANSI_ARGS_((Tcl_Interp *));
extern struct interpInfo *Int_CreateInterp _ANSI_ARGS_((
				Tcl_Interp *, Tcl_Interp *, char *));
extern struct interpInfo *Int_findInterp _ANSI_ARGS_((char *));
extern struct interpInfo *Int_whoIs      _ANSI_ARGS_((Tcl_Interp *));
extern int    Int_delInterp     _ANSI_ARGS_((Tcl_Interp *,struct interpInfo *));
extern int    Int_MainInterp    _ANSI_ARGS_((Tcl_Interp *));
extern int    Int_ExecCommand   _ANSI_ARGS_((Tcl_Interp *, Tcl_Interp *, int,char **));
extern void   Int_copyErrorInfo _ANSI_ARGS_((struct interpInfo *, Tcl_Interp *));
extern int    Int_AddMethod     _ANSI_ARGS_((struct interpInfo *, char *));
extern int    Int_DelMethod     _ANSI_ARGS_((struct interpInfo *, char *));
extern int    Int_IsMethod      _ANSI_ARGS_((struct interpInfo *, char *));

#endif /* __INTERP_H__DSH__ */
