# Generated automatically from Makefile.in by configure.
# ------------------------------------------------------------------------
# 	Makefile for demonstation shell of BLT library
# ------------------------------------------------------------------------

# ------------------------------------------------------------------------
# 	C Compiler options 
#
      DEFINES = 
  CDEBUGFLAGS = -O
           CC = cc

      TOP_DIR = /usr/local/blt
  INSTALL_DIR = /usr/local/blt/bin
 INSTPRGFLAGS = -m 0755

# ------------------------------------------------------------------------
# 	Directories containing Tcl and Tk include files and libraries
#
   TCL_INCDIR = -I/home/eliens/dv/tk/tcl-tk/include
    TK_INCDIR = -I/home/eliens/dv/tk/tcl-tk/include
     X_INCDIR = -I
     X_LIBDIR = -I


# ------------------------------------------------------------------------
# 	Libraries
#
      X_LIB = -L -lX11
     TK_LIB = -L/home/eliens/dv/tk/tcl-tk/lib -ltk
    TCL_LIB = -L/home/eliens/dv/tk/tcl-tk/lib -ltcl
    BLT_LIB = ./src/libBLT.a
 EXTRA_LIBS =  -lm -lnsl -lm

# ------------------------------------------------------------------------
# 	Don't edit anything beyond this point
# ------------------------------------------------------------------------
   OBJS =  \
	bltGraph.o bltGrAxis.o bltGrElem.o bltGrLegd.o \
        bltGrMisc.o bltGrPS.o bltGrTag.o bltGrHairs.o \
        bltCutbuffer.o bltBell.o \
        bltInit.o bltBgexec.o bltBitmap.o bltBusy.o \
        bltHtext.o bltList.o bltTable.o bltUtil.o bltWin.o 

  	 demo = blt_wish
     INCLUDES = -I. $(TK_INCDIR) $(TCL_INCDIR) $(X_INCDIR)
       CFLAGS = $(CDEBUGFLAGS) $(DEFINES) $(INCLUDES)
    LIBRARIES = $(BLT_LIB) $(TK_LIB) $(TCL_LIB) $(X_LIB) $(EXTRA_LIBS)
      INSTALL = /bin/install -c
       RANLIB = ranlib
           RM = rm -f

all: $(demo)

$(demo): normallib
	@echo "linking BLT demo as \"$(demo)\"..."
	$(CC) $(CFLAGS) tkAppInit.c -o $(demo) $(LIBRARIES)
	@echo "make finished on `date`"

normallib:
	@echo "making all in ./src"
	@(cd src; make all)

sharedlib: 
	@echo "make shared library in ./src/shared"
	@(cd src/shared; make all)

install-bin: $(demo)
	@if test ! -d $(TOP_DIR) ; then mkdir $(TOP_DIR); fi
	@if test ! -d $(INSTALL_DIR) ; then mkdir $(INSTALL_DIR); fi
	$(INSTALL) -c $(INSTPRGFLAGS) $(demo) $(INSTALL_DIR)

install-man: 
	@(cd man; make install)

install-lib:
	@(cd src; make install)
	@(cd src/shared; make install)

install-library:
	@(cd library; make install)

install: install-lib install-library install-bin install-man 

clean:
	@echo "cleaning in ./src"
	@(cd src; make clean)
	@echo "cleaning in ./src/shared"
	@(cd src/shared; make clean)
	@(cd man; make clean)
	$(RM) $(demo) *\~ \#*\#

GENERATED_FILES = \
        config.status \
	src/bltConfig.h \
        Makefile \
	src/Makefile \
	src/shared/Makefile \
	man/Makefile \
	library/Makefile
	
realclean: clean
	$(RM) $(GENERATED_FILES)
