#include "hush.h"

class canvas_handler : public handler {
public:

canvas_handler( canvas* cv ) { c = cv; moving = 0; }

void press( event& e) {
	x = e.x(); y = e.y();
	id = c->overlapping(x, y, "first");
	if (id) moving = 1;

	tclstring all = c->items(x,y);
	cout << "overlapping items " << all << endl;
	cout << "first item: " << all.lindex(0) << endl;
	cout << "last item: " << all.lindex(all.llength() - 1) << endl;
	}

void motion( event& e ) {
	if (moving) {
		id.move( e.x() - x, e.y() - y );
		x = e.x(); y = e.y();
		}
	}

void release( event& ) { moving = 0; }

protected:
canvas* c;
int x,y;
int moving;
item id;
char buf[BUFSIZ];
};


void program( kit* tk, int, char** ) {
 
    // tk->trace();

    canvas* c = new canvas(".canvas","-height 400 -width 600");
    c->handler(new canvas_handler(c));

    c->bitmap(30,50,"@king.bm");
    c->bitmap(50,80,"@test2.gif");
    c->oval(20,40,40,80,"-fill red");
    c->oval(120,60,180,180,"-fill blue");

    c->text(80, 80,  "City:", "-fill black -anchor e");
    c->text(80, 100,  "City:", "-fill black -anchor w");

    int i = c->photo(400,150,500,250);
    c->readppm(i,"teapot.ppm");

    //int j = c->photo(100,100,400,300); c->readppm(j,"both.ppm");

    /*
    photo* p = new photo(c,".photo");
    p->read("teapot.ppm");
    c->window(250,150,p);
    */

    c->bitmap(550,350,"@king.bm");

    tk->pack(c);
    tk->pack(".quit");
}

int main (int  argc, char  **argv) {
    session* s = new session(argc,argv,"root");
    return s->run(program);
}
