#!/usr/prac/se/hush/bin/hush -f

# Create horizonatal and vertical scrollbars
proc hypertext::mk {w} {
frame $w
scrollbar $w.vs -command " $w.f.h yview " -orient vertical
scrollbar $w.hs -command " $w.f.h xview " -orient horizontal

frame $w.f -relief sunken -borderwidth 2 -geom 500x500

# Create the hypertext widget 
hypertext $w.f.h  \
	-yscrollcommand " $w.vs set " \
	-xscrollcommand " $w.hs set " \
	-yscrollunits 10m \
	-xscrollunits 1i 

pack append $w $w.f fill
pack append $w.f $w.f.h { expand padx 2 pady 2 }
pack before $w.f $w.vs { right filly }
pack after $w.f $w.hs { bottom fillx }

bind $w.f.h <B3-Motion> {%W scan dragto %x %y}
bind $w.f.h <3> {%W scan mark %x %y}
bind $w.f.h <Control-p> { %W gotoline [expr [%W gotoline]-1] }
bind $w.f.h <Control-n> { %W gotoline [expr [%W gotoline]+1] }
#focus .f.h

#.f.h gotoline 10
#wm min . 0 0
return $w.f.h
}

set h [hypertext .h]
$h configure -file help.ht
pack append . .h {top}
