#ifndef PIE_H
#define PIE_H

class pie : public widget {
public:
char* type() { return "pie"; }

pie(char* p, char * options = "", int fl=1) : widget(p) { if(fl) init(options); }
pie(widget* w, char* p, char * options = "", int fl=1) : widget(w,p) { if(fl) init(options); }

void text(char* s) {
	sprintf(buf,"%s configure -title {%s}", path(), s);
	tk->eval( buf );
	}

void origin(int n) {
	sprintf(buf,"%s configure -origin %d", path(), n);
	tk->eval( buf );
	}

void radius(int n) {
	sprintf(buf,"%s configure -radius %d", path(), n);
	tk->eval( buf );
	}

char* get(char* options = "") {
	sprintf(buf,"%s get %s",path(),options);
	return tk->evaluate(buf);
	}

void set(char* label,int value, char* options="") {
	sprintf(buf,"%s set %s %d %s",path(),label,value,options);
	tk->eval( buf );
	}

void interval(int n) {
	sprintf(buf,"%s configure -interval %d", path(), n);
	tk->eval( buf );
	}

void start() {
	sprintf(buf,"%s start", path());
	tk->eval( buf );
	}

void stop() {
	sprintf(buf,"%s stop", path());
	tk->eval( buf );
	}

protected:
void install(action& ac, char* args = "") {
	sprintf(buf,"%s configure -command {%s %s}",path(),ac.name(),args);
	tk->eval( buf );
	}
};

#endif
