#ifndef CANVAS_H
#define CANVAS_H

class handler;
class canvas; 

#include <widgets/item.h>


class canvas : public widget {

public:
char* type() { return "canvas"; }

canvas(char *p, char* options = "", int fl=1) : widget(p) { if (fl) init(options); } 
canvas(widget* w, char *p, char* options = "", int fl=1) : widget(w,p) { if(fl) init(options); } 


void install(action& ac, char* args = "") {
	bind("<Any-ButtonPress>",ac, args);
	bind("<Any-ButtonRelease>",ac, args);
	bind("<Any-Motion>",ac, args );
	}

void tag(int id, char* tag) {
	sprintf(buf,"%s addtag %s withtag %d",path(),tag,id);
	tk->eval(buf);
	}

char* tags(int id) {
	sprintf(buf,"%s gettags %d",path(),id);
	return tk->evaluate(buf);
	}

void del(int id) {
	sprintf(buf,"%s delete %d",path(),id);
	tk->eval(buf);
	}

void del(char* id) {
	sprintf(buf,"%s delete %s",path(),id);
	tk->eval(buf);
	}

void move(int id, int x, int y) {
	sprintf(buf,"%s move %d %d %d",path(),id,x,y);
	tk->eval(buf);
	}

void move(char* id, int x, int y) {
	sprintf(buf,"%s move %s %d %d",path(),id,x,y);
	tk->eval(buf);
	}


item bitmap(int x1, int y1, char* bitmap, char* options="") {
	sprintf(buf,"%s create bitmap %d %d -bitmap \"%s\" %s",path(),x1,y1,bitmap,options);
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}

item photo(int x1, int y1, int x2, int y2, char* options ="") {
	sprintf(buf,"%s create photo %d %d %d %d %s",path(),x1,y1,x2,y2,options);
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}

void readppm(int id, char* file ="") {
	sprintf(buf,"readppm %s-%d %s",path(),id,file);
	tk->eval( buf );
	}

item line(int x1, int y1, int x2, int y2, char* options ="") {
	sprintf(buf,"%s create line %d %d %d %d %s",path(),x1,y1,x2,y2,options);
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}

item line(char* linespec, char* options ="") {
	sprintf(buf,"%s create line %s %s",path(),linespec,options);
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}

item arc(int x1, int y1, int x2, int y2, char* options ="") {
	sprintf(buf,"%s create arc %d %d %d %d %s",path(),x1,y1,x2,y2,options);
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}

item oval(int x1, int y1, int x2, int y2, char* options ="") {
	sprintf(buf,"%s create oval %d %d %d %d %s",path(),x1,y1,x2,y2,options);
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}

item circle(int x1, int y1, int r, char* options ="") {
	sprintf(buf,"%s create oval %d %d %d %d %s",path(),x1-r,y1-r,x1+r,y1+r,options);
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}

item polygon(char* linespec, char* options ="") {
	sprintf(buf,"%s create polygon %s %s",path(),linespec,options);
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}

item rectangle(int x1, int y1, int x2, int y2, char* options ="") {
	sprintf(buf,"%s create rectangle %d %d %d %d %s",path(),x1,y1,x2,y2,options);
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}

item text(int x1, int y1, char* txt, char* options="") {
	sprintf(buf,"%s create text %d %d -text \"%s\" %s",path(),x1,y1,txt,options);
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}

item window(int x1, int y1, char* win, char* options="") {
	sprintf(buf,"%s create window %d %d -window \"%s\" %s",path(),x1,y1,win,options);
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}

item window(int x1, int y1, widget* win, char* options="") {
	sprintf(buf,"%s create window %d %d -window \"%s\" %s",path(),x1,y1,win->path(),options);
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}

item sphere(int x1, int y1, int x2, int y2, char* color="white", char* tag = "sphere", char* options ="") {
	sprintf(buf,"vsphere %s %s %d %d %d %d %s %s",path(),tag,x1,y1,x2,y2,color,options);
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}

item sphere(int x1, int y1, int r, char* color="white", char* tag = "sphere", char* options ="") {
	sprintf(buf,"vsphere %s %s %d %d %d %d %s %s",path(),tag,x1-r,y1-r,x1+r,y1+r,color,options);
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}

item current() {
	sprintf(buf,"%s find current",path());
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}
	
item overlapping(int x, int y, char* options = "first") {
	tclstring ids = items(x,y);
	char* p; int n;
	if (!strcmp(options,"first")) {
		sscanf(ids,"%d",&n);
		}
	else {
		p = ids.lindex( ids.llength() );
		sscanf(p,"%d",&n);
		}
	return *(new item(n,this));
	}
/*
item overlapping(int x, int y) {
	sprintf(buf,"%s find overlapping %d %d %d %d",path(),x,y,x,y);
	int n = 0; sscanf(tk->evaluate(buf),"%d",&n);
	return *(new item(n,this));
	}
*/

char* items(int x, int y) {
	sprintf(buf,"%s find overlapping %d %d %d %d",path(),x,y,x,y);
	return tk->evaluate( buf );
	}

void itemconfigure(int it, char* options) {
	sprintf(buf,"%s itemconfigure %d %s",path(),it,options);
	tk->eval(buf);
	}

void itemconfigure(char* tag, char* options) {
	sprintf(buf,"%s itemconfigure %s %s",path(),tag,options);
	tk->eval(buf);
	}

};

inline void item::info() { cout << "item " << n << " in " << c->path() << endl; }
inline void item::move(int x, int y) { c->move(n,x,y); }
inline void item::tag(char* s) { c->tag(n,s); }
inline char* item::tags() { return c->tags(n); }
inline void item::configure(char* s) { c->itemconfigure(n,s); }
// sneaky:
inline item::item(int i, char* x) { n = i; c = new canvas(x,"",0); }
#endif
