/*ident	"@(#)cls4:incl-master/proto-headers/assert.h	1.1" */
/* This header file intentionally has no wrapper, since the user
*  may want to re-include it to turn off/on assertions for only
*  a portion of the source file.
*/

#ifndef ASSERT_H
#define ASSERT_H


#define require(X) precondition("",X)
#define promise(X) postcondition("",X)
#define ensure(X) postcondition("",X)


#ifdef assert
#undef assert
#endif
#ifdef _assert
#undef _assert
#endif

#ifndef handle_precondition
#define handle_precondition(F) abort()
#endif
#ifndef handle_postcondition
#define handle_postcondition(F) abort()
#endif
#ifndef handle_checkassertion
#define handle_checkassertion(C) abort()
#endif

#ifdef NDEBUG

#define assert(e) ((void)0)
#define precondition(f,e) ((void)0)
#define postcondition(f,e) ((void)0)
#define checkassertion(c,e) ((int)0,1)

#else

#ifdef NDEBUG_PRECONDITIONS
#define precondition(f,e) ((void)0)
#endif
#ifdef NDEBUG_POSTCONDITIONS
#define postcondition(f,e) ((void)0)
#endif
#ifdef NDEBUG_INVARIANT
#define checkassertion(f,e) ((void)0,1)
#endif


#ifndef GCC
#ifndef __SYSENT_H
#include <sysent.h>
#endif
#endif

#ifndef __STDLIB_H
#include <stdlib.h>
#endif

#ifndef IOSTREAMH
#include <iostream.h>
#endif

#if defined(__STDC__)
#define assert(EX) (void)((EX) || ((cerr << "Assertion failed: " # EX ", file " << __FILE__ << ", line " << __LINE__ << endl), abort(), 0))
#else
#define precondition(F,EX) (void)((EX) || ((cerr << "Precondition F failed: EX, file " << __FILE__ << ", line " << __LINE__ << endl), handle_precondition(F), 0))
#define postcondition(F,EX) (void)((EX) || ((cerr << "Postcondition F failed: EX, file " << __FILE__ << ", line " << __LINE__ << endl), handle_postcondition(F), 0))
#define checkassertion(C,EX) (int)((EX) || ((cerr << "Assertion C failed: EX, file " << __FILE__ << ", line " << __LINE__ << endl), handle_checkassertion(C), 1))
#endif
#endif

#define _assert(e) assert(e)

#endif
