#
#------------------------------------------------------------------------------
#  Copyright (c) 1993-1995 European Synchrotron Radiation Facility
#
#  Permission to use, copy, modify, and distribute this software and its
#  documentation for any purpose and without fee is hereby granted, provided
#  that the "Terms and Conditions of Distribution", given in the documentation
#  to this software, are applicable and the above copyright message appears in
#  each copy.
#
#------------------------------------------------------------------------------
#
#
#  This file contains the Tcl startup script for the toplevel window of 
#  the application for demonstrating the use of the CTAXT interface
#
#  13.12.1993   hp      1st version
#




#
#  the following variables are used in event bindings, therefore they have
#  to be global
#

global mouseX mouseY


#
#  create and pack the canvas widget
#

canvas .canvas -relief sunken -bd 2
pack .canvas -side top -fill both -expand 1


#
#  create the rectangle within the canvas
#

.canvas create rectangle 10 10 100 100 -fill black \
				       -stipple gray25 -tag rectangle


#
#  set up bindings so that the rectangle can be dragged
#

.canvas bind rectangle <1> {
  set nonExistentVariable;    #  for demonstrating background error handling  #
  set mouseX %x;
  set mouseY %y
}
.canvas bind rectangle <B1-Motion> {
  set relX [expr {%x-$mouseX}];
  set relY [expr {%y-$mouseY}];
  .canvas move rectangle $relX $relY;
  set mouseX %x;
  set mouseY %y;
}
