#
#------------------------------------------------------------------------------
#  Copyright (c) 1993-1995 European Synchrotron Radiation Facility
#
#  Permission to use, copy, modify, and distribute this software and its
#  documentation for any purpose and without fee is hereby granted, provided
#  that the "Terms and Conditions of Distribution", given in the documentation
#  to this software, are applicable and the above copyright message appears in
#  each copy.
#
#------------------------------------------------------------------------------
#
#
#  21.12.1993   hp      1st version
#
#  Simple Tcl script for checking the versions of Tcl/Tk
#


#  check the arguments  #

if {$argc < 4} {
  puts stderr "Syntax is: $argv0 majorVersion major minorVersion minor"
  exit 0
}

#  scan the arguments  #

set majorVersion [lindex $argv 0]
set major [lindex $argv 1]
set minorVersion [lindex $argv 2]
set minor [lindex $argv 3]

#  get the current version  #

scan $majorVersion "%s %s %d" define version majorVersion
scan $minorVersion "%s %s %d" define version minorVersion

#  check the version  #

if {($majorVersion < $major) ||
    (($majorVersion == $major) && ($minorVersion < $minor))} {
  exit 0
}

#  version is ok  #

exit 1
