proc loadpkg {name args} {
    global env auto_path

    set ename [format "%s_LIBRARY" $name]
    if {[info exists env($ename)] == 0} {
	tkerror "Error loading package $name: "
	        "Cannot read environment variable $ename"
    }

    set dir $env($ename)
    if {[file exists $dir] == 0} {
	tkerror "Error loading package $name: "
                "Directory $dir does not exist"
    }

    lappend auto_path $dir
    eval $name::Load $dir $args
}

proc setenv {name args} {
    global env

    if {[llength $args] == 1} {
        return [set env($name) [lindex $args 0]]
    } else {
        if {[info exists env($ename)] == 0} {
            tkerror "Error in setenv: "
                    "environment variable \"$name\" does not exist"
        } else {
            return $env($name)
        }
    }
}
