proc tixSelect {w args} {
    eval tixInt_CreateWidget $w tixSel TixSelect $args
    return $w
}

proc tixSel::CreateClassRec {} {
    global tixSel

    # OPTIONS
    set tixSel(rootOptions) {}
    set tixSel(options)     {-active -anchor -background -bg -command -font \
	                     -state -variable -buttonbg -selectedbg}

    # DEFAULT VALUES
    set tixSel(-active)     {-active active Active {}}
    set tixSel(-anchor)     {-anchor anchor Anchor center}
    set tixSel(-background) {-background background Background #ffe4c4}
    set tixSel(-buttonbg)   {-buttonbg buttonBg Background #ffe4c4}
    set tixSel(-selectedbg) {-selectedbg selectedBg SelectedBg #e4c4ff}
    set tixSel(-command)    {-command command Command {}}
    set tixSel(-font)       {-font font Font \
	                     "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"}
    set tixSel(-state)      {-state state State normal}
    set tixSel(-variable)   {-variable variable Variable {}}

    # ALIASES
    set tixSel(-bg)           {= -background}
    # METHODS
    set tixSel(methods)       {add invoke}
}


proc tixSel::ConstructWidget {w} {
    # At the beginning we have no contents
}

proc tixSel::InitWidgetRec {w class className args} {
    upvar #0 $w data

    set data(items)   {}
}

#----------------------------------------------------------------------
#                           CONFIG OPTIONS
#----------------------------------------------------------------------

# Does not call the command
proc tixSel::config-active {w arg} {
    upvar #0 $w data

    if {$data(-state) == "normal"} {
	foreach item $data(items) {
	    if {$item == $arg} {
		$w.$item config -relief sunken  -bg $data(-selectedbg)
	    } else {
		$w.$item config -relief raised  -bg $data(-buttonbg)\
		    -command "$w invoke $item"
	    }
	}
	set data(-active) $arg
    }
}

#$tmp redundant
proc tixSel::config-anchor {w arg} {
    upvar #0 $w data

    foreach item $data(items) {
	$w.$item config -anchor $arg
    }
}

proc tixSel::config-command {w arg} {
    # nothing needed here
}

proc tixSel::config-background {w arg} {
    upvar #0 $w data

    $data(rootCmd) config -bg $arg
}

proc tixSel::config-buttonbg {w arg} {
    upvar #0 $w data

    foreach item $data(items) {
	$w.$item config -bg $arg
    }
}

proc tixSel::config-selectedbg {w arg} {
    upvar #0 $w data

    if {$data(-state) == "normal"} {
	$w.$data(-active) config -bg $arg
    }
}

proc tixSel::config-font {w arg} {
    upvar #0 $w data

    foreach item $data(items) {
	$w.$item config -font $arg
    }
}

proc tixSel::config-state {w arg} {
    upvar #0 $w data

    if {$arg == $data(-state)} {
	return
    }
    if {$arg == "disabled"} {
	foreach item $data(items) {
	    $w.$item config -state disabled -relief raised \
		-bg $data(-buttonbg) 
	}
    } else {
	foreach item $data(items) {
	    if {$item == $data(-active)} {
		$w.$item config -relief sunken -bg $data(-selectedbg) \
		    -state normal
	    } else {
		$w.$item config -relief raised -bg $data(-buttonbg) \
		    -command "$w invoke $item" -state normal
	    }
	}
    }
}

proc tixSel::config-variable {w arg} {

}

#----------------------------------------------------------------------
#                     WIDGET COMMANDS
#----------------------------------------------------------------------
proc tixSel::add {w name args} {
    upvar #0 $w data

    eval [list button $w.$name -command "$w invoke $name"\
	 -bg $data(-buttonbg) -font $data(-font)] $args
    pack $w.$name -side left -expand yes -fill both
    lappend data(items) $name
    if {$data(-state) == "disabled"} {
	$name config -relief raised -state disabled
    }
}

#call the command
proc tixSel::invoke {w name} {
    upvar #0 $w data

    if {$data(-state) == "normal"} {
	foreach item $data(items) {
	    if {$item == $name} {
		$w.$item config -relief sunken -bg $data(-selectedbg)
	    } else {
		$w.$item config -relief raised -bg $data(-buttonbg)\
		    -command "$w invoke $item"
	    }
	}
	set data(-active) $name
	if {$data(-command) != {}} {
	    $data(-command) $name
	}
    }
}
