proc MkDialogDialog1 {} {
    set w .dialog1

    if [winfo exists $w] {
	return
    }
    toplevel $w
    wm title $w "Dialog Buttons"
    frame $w.top -relief raised -border 1
    message $w.top.msg -font -*-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-* \
	-relief sunken -bd 1 -anchor n -padx 40 -width 370\
	-text {

Dialog Buttons

You can use the command "tixDlgBtns" to create a group \
of buttons. Normally, these dialog buttons are put at the \
bottom of a dialog box, as shown in this dialog box.

To look at the "Standard Dialog Buttons", press \
the "Next >>" button. To end this dialog, press the "Close" \
button.
}
    tixDlgBtns $w.btns
    $w.btns add close -text "Close"   -width 8
    $w.btns add next  -text "Next >>" -width 8

    pack $w.top.msg -expand yes -fill both -padx 10 -pady 10
    pack $w.top -expand yes -fill both 
    pack $w.btns -fill x

    $w.btns button close config -command "destroy $w"
    $w.btns button next  config -command "MkDialogDialog2"
}

proc MkDialogDialog2 {} {
    set w .dialog2

    if [winfo exists $w] {
	destroy $w
    }
    set x [winfo x .dialog1]
    set y [winfo y .dialog1]
    toplevel $w
    wm title $w "Standard Dialog Buttons"
    wm geometry $w +$x+$y
    frame $w.top -relief raised -border 1
    message $w.top.msg -font -*-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-* \
	-relief sunken -bd 1 -anchor n -padx 40 -width 270\
	-text {

Standard Dialog Buttons

You can use the command "tixStdDlgBtns" to create a standard group \
of buttons as defined in the Motif(TM) Interface Style Guide. Normally,\
these dialog buttons are put at the \
bottom of a dialog box, as shown in this dialog box.

Press any button in this dialog box to close it.
}
    tixStdDlgBtns $w.btns
    $w.btns ok     config -command "destroy $w"
    $w.btns apply  config -command "destroy $w"
    $w.btns cancel config -command "destroy $w"
    $w.btns help   config -command "destroy $w"

    pack $w.top.msg -expand yes -fill both -padx 10 -pady 10
    pack $w.top -expand yes -fill both 
    pack $w.btns -fill x

    update
    destroy .dialog1
}

