
/*
 * -------------------------------------------------------------------
 *
 * Axis --
 *
 * 	Structure contains options controlling how the axis will be
 * 	displayed.
 *
 * -------------------------------------------------------------------
 */
typedef struct {
    enum AxisTypes type;	/* Type of axis: X_AXIS_TYPE or Y_AXIS_TYPE */

    AxisPrintProc *printProc;
    AxisDisplayProc *displayProc;
    AxisConfigProc *configProc;
    AxisLayoutProc *layoutProc;
    AxisDestroyProc *destroyProc;

    AxisWinCoords *Win;
    AxisWorldCoords *World;

    /* Private data members */

    int logScale;		/* If non-zero, scale values logarithmically */
    int showTicks;		/* If non-zero, display (both major and minor)
				 * ticks on the axis */
    int loose;			/* In non-zero, autoscale limits loosely */

    double reqPlotMin;		/* Minimum limit for manual scaling of axis:
				 * If value is -Inf, indicates lower limit of
				 * axis should be autoscaled */

    double reqPlotMax;		/* Maximum limit for manual scaling of axis:
				 * If value is Inf, indicates upper limit of
				 * axis should be autoscaled */
    double reqMajorStep;	/* Manually selected step size for major
				 * ticks: If zero or less, automatically
				 * calculate a "best" step size based on range
				 * of values. */
    int reqNumMinor;		/* Manually selected number of subticks: If
				 * zero or less, the default value is 2. */
    XFontStruct *fontPtr;	/* Font used to draw tick labels. */
    XColor *fgColorPtr;		/* Foreground color for ticks, labels, and
				 * axis */
    int lineWidth;		/* Line thickness of axis and ticks */
    double theta;		/* Rotation of tick labels in degrees. */
    char *formatCmd;		/* If non-NULL, indicates a Tcl proc to call
				 * when formatting tick labels. See the manual
				 * for its usage. */
    double elemMin, elemMax;	/* Autoscale axis limits (min/max element data
				 * values from the element display list) */
    double tickMin, tickMax;	/* Smallest, largest possible tick on plot */
    double plotMin, plotMax;	/* Limits of plotted values */

    double min, max;		/* Actual (including padding) axis limits */
    double range;		/* Range of values (max-min) */
    double scale;		/* Scale factor to convert values to pixels */
    int offset;			/* Offset of plotting region from window
				 * origin */

    double minorStep;		/* Step interval between minor ticks */
    int numMinor;		/* Number of minor ticks between major ticks */
    double majorStep;		/* Step interval between major ticks */
    int numMajor;		/* Number of major ticks possible on axis:
				 * Calculated by tick layout routines. */

    XSegment *segArr;		/* Array of computed tick line segments. Also
				 * includes the axis line */
    int numSegments;		/* Size of the above segment array */

    TickLabel *labelArr;	/* Array of computed tick labels: See the
				 * description of the TickLabel structure. */
    int numLabels;		/* Size of the above label array */
    GC textGC;			/* Graphic context for tick labels: Must be
				 * private (can't use Tk_GetGC) because the
				 * FillStyle, TSOrigin, and Stipple fields may
				 * change when the graph is layout is
				 * calculated, due to rotation of text. Also,
				 * note that the background is reset when the
				 * background color of the graph changes. */
    GC lineGC;			/* Graph context for axis lines and ticks */

} Axis;
