/* rle_config.h
 * 
 * Hand-build RLE configure file that works with the TSIPP configure script.
 *
 * $id:$
 */

#include <stdio.h>

/* CONST_DECL must be defined as 'const' or nothing. */
#ifdef __STDC__
#   define CONST_DECL const
#else
#   define CONST_DECL
#endif

/* Typedef for void * so we can use it consistently. */
typedef	void *void_star;

#ifdef HAVE_STDLIB_H
#   include <stdlib.h>
#else
#   if HAVE_MALLOC_H
#       include <malloc.h>
#   else
        extern void_star malloc();
        extern void_star realloc();
        extern void_star calloc();
#   endif
#endif

#ifdef HAVE_STRING_H
    /* SYS V string routines. */
#   include <string.h>
#   define index strchr
#   define rindex strrchr
#   define bzero( _str, _n )		memset( _str, '\0', _n )
#   define bcopy( _from, _to, _count )	memcpy( _to, _from, _count )
#else
    /* BSD string routines. */
#   include <strings.h>
#endif /* USE_STRING_H */

/*
 * Macro to enable line buffering mode on a file.  The macros assure that the
 * resulting expression returns zero if the function call does not return
 * a value.  Try for setvbuf first, as setlinebuf seems to be a no-op on 
 * DEC Ultrix.
 */
#if defined(HAVE_SETVBUF) && defined(_IOLBF)
#   define SETLINEBUF(fp)  setvbuf (fp, NULL, _IOLBF, BUFSIZ)
#else
#   define SETLINEBUF(fp)  (setlinebuf (fp),0)
#endif
