/*
 * FILE : units_wrap.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Build 850)
 * 
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : TCL 8.0 */

#define INCLUDE_TCL    <tcl.h>
#define INCLUDE_TK     <tk.h>
#include INCLUDE_TCL
#include <string.h>
#include <stdlib.h>
#define SWIGTCL
#define SWIGTCL8
/**************************************************************************
 * $Header: /cvsroot/units/units/units_wrap.c,v 1.4 2005/08/17 22:24:34 techentin Exp $
 *
 * swigtcl8.swg
 *
 * This file provides type-checked pointer support to Tcl 8.0.
 **********************************************************************/

#if defined(_WIN32) || defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a) __declspec(dllexport) a
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a) a _export 
#	else
#	    define SWIGEXPORT(a) a 
#	endif
#   endif
#else
#   define SWIGEXPORT(a) a 
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef SWIG_GLOBAL
#include <tcl.h>
#define SWIGSTATICRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGSTATICRUNTIME(a) static a
#endif

#ifdef SWIG_NOINCLUDE
extern void SWIG_SetPointerObj(Tcl_Obj *, void *, char *);
extern void SWIG_RegisterMapping(char *, char *, void *(*)(void *));
extern char *SWIG_GetPointerObj(Tcl_Interp *, Tcl_Obj *, void **, char *);
extern int  SWIG_MakePtr(char *, const void *, char *);
extern void SWIG_RegisterType();
#else

/* These are internal variables.   Should be static */

typedef struct SwigPtrType {
  char               *name;
  int                 len;
  void               *(*cast)(void *);
  struct SwigPtrType *next;
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Array containing start locations (for searching) */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}


/*---------------------------------------------------------------------
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *))
 *
 * Register a new type-mapping with the type-checking system.
 *---------------------------------------------------------------------*/

SWIGSTATICRUNTIME(void) 
SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0, *t1;

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc(SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(origtype);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }
  while (t->next) {
    if (strcmp(t->name,newtype) == 0) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(newtype);
  t1->cast = cast;
  t1->next = 0;
  t->next = t1;
  SwigPtrSort = 0;
}


/*---------------------------------------------------------------------
 * void SWIG_SetPointerObj(Tcl_Obj *objPtr, void *ptr, char *type)
 *
 * Sets a Tcl object to a pointer value.
 *           ptr = void pointer value
 *           type = string representing type
 *
 *---------------------------------------------------------------------*/

SWIGSTATICRUNTIME(void)
SWIG_SetPointerObj(Tcl_Obj *objPtr, void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  char _temp[20], *_c;
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    _c = &_temp[0];
    while (_r >= _result)
      *(_c++) = *(_r--);
    *_c = 0;
    Tcl_SetStringObj(objPtr,_temp,-1);
  } else {
    Tcl_SetStringObj(objPtr,"NULL",-1);
  }
  if (_ptr)
    Tcl_AppendToObj(objPtr,type,-1);
}

/* This is for backwards compatibility */

SWIGSTATICRUNTIME(int) 
SWIG_MakePtr(char *_c, const void *_ptr, char *type)
{
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;
  int      l = 0;
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
      l++;
    }
    *_r = '_';
    l++;
    while (_r >= _result)
      *(_c++) = *(_r--);
    _r = type;
    while (*_r)
      *(_c++) = *(_r++);
    *(_c) = 0;
  } else {
      strcpy (_c, "NULL");
  }
  return l;
}

/*---------------------------------------------------------------------
 * char *SWIG_GetPointerObj(Tcl_Interp *interp, Tcl_Obj *objPtr, void **ptr, char *type)
 *
 * Attempts to extract a pointer value from our pointer type.
 * Upon failure, returns a string corresponding to the actual datatype.
 * Upon success, returns NULL and sets the pointer value in ptr.
 *---------------------------------------------------------------------*/

SWIGSTATICRUNTIME(char *)
SWIG_GetPointerObj(Tcl_Interp *interp, Tcl_Obj *objPtr, void **ptr, char *_t) {
  unsigned long _p;
  char temp_type[256];
  char *name;
  int  i, len;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;
  int  start, end;
  char *_c;
  _p = 0;

  /* Extract the pointer value as a string */
  _c = Tcl_GetStringFromObj(objPtr, &i);

  /* Pointer values must start with leading underscore */
  if (*_c == '_') {
      _c++;
      /* Extract hex value from pointer */
      while (*_c) {
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
      }

      if (_t) {
	if (strcmp(_t,_c)) { 
	  if (!SwigPtrSort) {
	    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
	    for (i = 0; i < 256; i++) {
	      SwigStart[i] = SwigPtrN;
	    }
	    for (i = SwigPtrN-1; i >= 0; i--) {
	      SwigStart[(int) (SwigPtrTable[i].name[1])] = i;
	    }
	    for (i = 255; i >= 1; i--) {
	      if (SwigStart[i-1] > SwigStart[i])
		SwigStart[i-1] = SwigStart[i];
	    }
	    SwigPtrSort = 1;
	    for (i = 0; i < SWIG_CACHESIZE; i++)  
	      SwigCache[i].stat = 0;
	  }
	  
	  /* First check cache for matches.  Uses last cache value as starting point */
	  cache = &SwigCache[SwigLastCache];
	  for (i = 0; i < SWIG_CACHESIZE; i++) {
	    if (cache->stat) {
	      if (strcmp(_t,cache->name) == 0) {
		if (strcmp(_c,cache->mapped) == 0) {
		  cache->stat++;
		  *ptr = (void *) _p;
		  if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
		  return (char *) 0;
		}
	      }
	    }
	    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	    if (!SwigLastCache) cache = SwigCache;
	    else cache++;
	  }
	  /* We have a type mismatch.  Will have to look through our type
	     mapping table to figure out whether or not we can accept this datatype */

	  start = SwigStart[(int) _t[1]];
	  end = SwigStart[(int) _t[1]+1];
	  sp = &SwigPtrTable[start];
	  while (start < end) {
	    if (swigcmp(_t,sp) == 0) break;
	    sp++;
	    start++;
	  }
	  if (start > end) sp = 0;
	  /* Try to find a match for this */
	  while (start <= end) {
	    if (swigcmp(_t,sp) == 0) {
	      name = sp->name;
	      len = sp->len;
	      tp = sp->next;
	      /* Try to find entry for our given datatype */
	      while(tp) {
		if (tp->len >= 255) {
		  return _c;
		}
		strcpy(temp_type,tp->name);
		strncat(temp_type,_t+len,255-tp->len);
		if (strcmp(_c,temp_type) == 0) {
		  
		  strcpy(SwigCache[SwigCacheIndex].mapped,_c);
		  strcpy(SwigCache[SwigCacheIndex].name,_t);
		  SwigCache[SwigCacheIndex].stat = 1;
		  SwigCache[SwigCacheIndex].tp = tp;
		  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
		  
		  /* Get pointer value */
		  *ptr = (void *) _p;
		  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
		  return (char *) 0;
		}
		tp = tp->next;
	      }
	    }
	    sp++;
	    start++;
	  }
	  /* Didn't find any sort of match for this data.  
	     Get the pointer value and return the received type */
	  *ptr = (void *) _p;
	  return _c;
	} else {
	  /* Found a match on the first try.  Return pointer value */
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
      } else {
	/* No type specified.  Good luck */
	*ptr = (void *) _p;
	return (char *) 0;
      }
  } else {
    if (strcmp (_c, "NULL") == 0) {
	*ptr = (void *) 0;
	return (char *) 0;
    }
    *ptr = (void *) 0;	
    return _c;
  }
}

/*---------------------------------------------------------------------
 * void SWIG_RegisterType()
 *
 * Registers our new datatype with an interpreter.
 *---------------------------------------------------------------------*/

SWIGSTATICRUNTIME(void)
SWIG_RegisterType() {
  /* Does nothing at the moment */
}

#endif

#ifdef __cplusplus
}
#endif
#define SWIG_init    Units_Init
#define SWIG_name    "units"
#define SWIG_prefix  "units::"
#define SWIG_namespace "units"

#ifdef __cplusplus
extern "C" {
#endif
#ifdef MAC_TCL
#pragma export on
#endif
SWIGEXPORT(int) Units_Init(Tcl_Interp *);
#ifdef MAC_TCL
#pragma export off
#endif
#ifdef __cplusplus
}
#endif

#include "units.h"

#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99

#define SWIG_exception(a,b)   Tcl_SetStringObj(tcl_result,b,-1); return TCL_ERROR

  void new ( char *name, char *baseUnits ) {
    units_new( name, baseUnits);
  }

  double convert ( char *value, char *targetUnits ) {
    return units_convert( value, targetUnits );
  }

  char *reduce ( char *unitString ) {
    return units_reduce( unitString);
  }
typedef float  Length;
typedef float  Mass;
typedef float  Time;
typedef float  ElectricCurrent;
typedef float  Temperature;
typedef float  Amount;
typedef float  LuminousIntensity;
typedef float  PlaneAngle;
typedef float  SolidAngle;
typedef float  Frequency;
typedef float  Force;
typedef float  Pressure;
typedef float  Energy;
typedef float  Power;
typedef float  ElectricCharge;
typedef float  ElectricPotential;
typedef float  Capacitance;
typedef float  ElectricResistance;
typedef float  ElectricConductance;
typedef float  MagneticFlux;
typedef float  MagneticFluxDensity;
typedef float  Inductance;
typedef float  LuminousFlux;
typedef float  Illuminance;
typedef ElectricCurrent  Current;
typedef ElectricCharge  Charge;
typedef ElectricPotential  Voltage;
typedef ElectricResistance  Resistance;
typedef ElectricConductance  Conductance;

/*
 *---------------------------------------------------------------
 *
 *  convertTypedWrapperValue
 *
 *  Converts a typed wrapper value into an appropriately
 *  scaled floating point number.
 *
 *  This routine is the guts of the unitsConversion typemap,
 *  extracted here to (1) reduce duplication in the generated
 *  wrapper code, and (2) be callable from other typemaps.
 *
 *---------------------------------------------------------------
 */
#include<string.h>

  /*  these functions defined below  */
  char *unitsDefaultString( char *typeName ) ;
  char *unitsTargetString( char *typeName ) ;


  static char *convertTypedWrapperValue( char *sourceString, 
				       char *basetype,
				       float *target) {

    static char typeName[100]; /*  basetype without trailing space    */
    char *endPtr ;             /*  for default unit checking          */
    char sourceCopy[100] ;     /*  copy of source argument (if needed)*/
    char *defaultUnits ;       /*  appended if none given in $source  */
    char *targetUnits ;        /*  target of conversion               */
    char *msg ;                /*  error message                      */
    char *cp ;                 /*  pointer for finding trailing spaces*/

    /*  Initial conversion finds the end of the number part.  */
    /*  Value is saved in case there are no target units.     */
    *target = (float) strtod(sourceString, &endPtr) ;

    /*  Compute type name without trailing space  */
    /*  which comes from SWIG's $basetype macro.  */
    strcpy(typeName, basetype) ;
    cp = strchr(typeName,' ') ;
    if (cp != 0) 
      *cp = '\0';

    /*  Apply default units if necessary  */
    if ( *endPtr == '\0' ) {
      strcpy(sourceCopy, sourceString) ;
      defaultUnits = unitsDefaultString( typeName ) ; 
      if ( defaultUnits != NULL ) {
	strcat( sourceCopy, " " ) ;
	strcat( sourceCopy, defaultUnits ) ;
	sourceString = sourceCopy ;
      }
    }

    /*  Perform conversion  */
    targetUnits = unitsTargetString( typeName ) ; 
    if ( targetUnits != NULL ) {
      units_clear_exception();
      *target = convert( sourceString, targetUnits ) ;
      msg = units_check_exception();
      return msg;
    }
    /* no valid target units  */
    strcat(typeName, " has no valid Target units");
    return typeName;
  }



/*---------------------------------------------------------------
 *
 *  unitsDefaultTable
 *
 *  This table associates unit types (e.g., "Length") with 
 *  defaults (e.g., "meters") which are employed when no
 *  units are supplied to a conversion.
 *  
 *  The table is coded as a static C array.  The values
 *  are passed to unitsSetDefault() and unitsSetTarget()
 *  in the %init code section.
 *  
 *  The scripting language initializaiton and unitsConversion 
 *  typemape are responsible for ensuring that the proper 
 *  conversions are executed.
 *
 *---------------------------------------------------------------*/
  typedef struct {
    char *name ;
    char *unit ;
  } UnitsDefaultTableEntry ;

  static UnitsDefaultTableEntry unitsDefaultTable[] = {

    /*  SI Base Units */
    { "Length",              "meters" },
    { "Mass",                "kilograms" },
    { "Time",                "seconds" },
    { "ElectricCurrent",     "amperes" },
    { "Temperature",         "kelvins" },
    { "Amount",              "moles" },
    { "LuminousIntensity",   "candela" },

    /*  SI Derived Units with Special Names */
    { "PlaneAngle",          "radian" },
    { "SolidAngle",          "steradian" },
    { "Frequency",           "hertz" },
    { "Force",               "newtons" },
    { "Pressure",            "pascals" },
    { "Energy",              "joules" },
    { "Power",               "watts" },
    { "ElectricCharge",      "coulombs" },
    { "ElectricPotential",   "volts" },
    { "Capacitance",         "farads" },
    { "ElectricResistance",  "ohms" },
    { "ElectricConductance", "siemens" },
    { "MagneticFlux",        "webers" },
    { "MagneticFluxDensity", "tesla" },
    { "Inductance",          "henrys" },
    { "LuminousFlux",        "lumens" },
    { "Illuminance",         "lux" },

    /*  for Electrical Engineering  */
    { "Current",             "amperes" },
    { "Charge",              "coulombs" },
    { "Voltage",             "volts" },
    { "Resistance",          "ohms" },
    { "Conductance",         "siemens" },
  };

  const int UNITSDEFAULTTABLESIZE = sizeof(unitsDefaultTable)/sizeof(UnitsDefaultTableEntry) ;


/*
 *---------------------------------------------------------------
 *
 *  Default and Target Units
 *  
 *  These script-language dependent routines set and retrieve the
 *  default and target units strings from the script environment
 *  for the convertTypeWrapperValue() routine.
 *
 *  unitsSetDefault( char *typeName, char *unit ) ;
 *  unitsSetTarget( char *typeName, char *unit ) ;
 *  unitsDefaultString( char *typeName ) ;
 *  unitsTargetString( char *typeName ) ;
 *
 *---------------------------------------------------------------
 */

#ifdef SWIGTCL8
  /*---------------------------------------------------------------
  *  We have to save a pointer to the interpreter that was active
  *  during SWIG initialization so that we can access hash tables.
  *  The SWIG mechanism for linking variables does not seem to
  *  apply to hash tables (Tcl arrays).
  *---------------------------------------------------------------*/
  static Tcl_Interp *unitsInterpreter = NULL ;


  void unitsSetDefault( char *typeName, char *value ) {
    Tcl_SetVar2(unitsInterpreter, SWIG_prefix "default", typeName, value, 0);
  }

  void unitsSetTarget( char *typeName, char *value ) {
    Tcl_SetVar2(unitsInterpreter, SWIG_prefix "target", typeName, value, 0);
  }

  char *unitsDefaultString( char *typeName ) {
    return Tcl_GetVar2(unitsInterpreter, SWIG_prefix "default", typeName, 0);
  }

  char *unitsTargetString( char *typeName ) {
    return Tcl_GetVar2(unitsInterpreter, SWIG_prefix "target", typeName, 0);
  }

#endif  /*  ifdef SWIGTCL8  */

static int _wrap_units_new(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. units::new name baseUnits ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
{
  char *msg;
  units_clear_exception();
      new(_arg0,_arg1);

    msg = units_check_exception();
  if (msg != NULL) {
    SWIG_exception(SWIG_RuntimeError, msg) ;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    return TCL_OK;
}
static int _wrap_units_convert(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    double  _result;
    char * _arg0;
    char * _arg1;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 3) || (objc > 3)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. units::convert value targetUnits ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
    if ((_arg1 = Tcl_GetStringFromObj(objv[2], &templength)) == NULL) return TCL_ERROR;
{
  char *msg;
  units_clear_exception();
      _result = (double )convert(_arg0,_arg1);

    msg = units_check_exception();
  if (msg != NULL) {
    SWIG_exception(SWIG_RuntimeError, msg) ;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetDoubleObj(tcl_result,(double) _result);
    return TCL_OK;
}
static int _wrap_units_reduce(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *CONST objv[]) {

    char * _result;
    char * _arg0;
    Tcl_Obj * tcl_result;
    int templength;

    clientData = clientData; objv = objv;
    tcl_result = Tcl_GetObjResult(interp);
    if ((objc < 2) || (objc > 2)) {
        Tcl_SetStringObj(tcl_result,"Wrong # args. units::reduce unitString ",-1);
        return TCL_ERROR;
    }
    if ((_arg0 = Tcl_GetStringFromObj(objv[1], &templength)) == NULL) return TCL_ERROR;
{
  char *msg;
  units_clear_exception();
      _result = (char *)reduce(_arg0);

    msg = units_check_exception();
  if (msg != NULL) {
    SWIG_exception(SWIG_RuntimeError, msg) ;
  }
}    tcl_result = Tcl_GetObjResult(interp);
    Tcl_SetStringObj(tcl_result,_result,-1);
    return TCL_OK;
}
/*
 * This table is used by the pointer type-checker
 */
static struct { char *n1; char *n2; void *(*pcnv)(void *); } _swig_mapping[] = {
    { "_signed_long","_long",0},
    { "_LuminousIntensity","_Conductance",0},
    { "_LuminousIntensity","_Resistance",0},
    { "_LuminousIntensity","_Voltage",0},
    { "_LuminousIntensity","_Charge",0},
    { "_LuminousIntensity","_Current",0},
    { "_LuminousIntensity","_Illuminance",0},
    { "_LuminousIntensity","_LuminousFlux",0},
    { "_LuminousIntensity","_Inductance",0},
    { "_LuminousIntensity","_MagneticFluxDensity",0},
    { "_LuminousIntensity","_MagneticFlux",0},
    { "_LuminousIntensity","_ElectricConductance",0},
    { "_LuminousIntensity","_ElectricResistance",0},
    { "_LuminousIntensity","_Capacitance",0},
    { "_LuminousIntensity","_ElectricPotential",0},
    { "_LuminousIntensity","_ElectricCharge",0},
    { "_LuminousIntensity","_Power",0},
    { "_LuminousIntensity","_Energy",0},
    { "_LuminousIntensity","_Pressure",0},
    { "_LuminousIntensity","_Force",0},
    { "_LuminousIntensity","_Frequency",0},
    { "_LuminousIntensity","_SolidAngle",0},
    { "_LuminousIntensity","_PlaneAngle",0},
    { "_LuminousIntensity","_float",0},
    { "_LuminousIntensity","_Length",0},
    { "_LuminousIntensity","_Mass",0},
    { "_LuminousIntensity","_Time",0},
    { "_LuminousIntensity","_ElectricCurrent",0},
    { "_LuminousIntensity","_Temperature",0},
    { "_LuminousIntensity","_Amount",0},
    { "_Energy","_Conductance",0},
    { "_Energy","_Resistance",0},
    { "_Energy","_Voltage",0},
    { "_Energy","_Charge",0},
    { "_Energy","_Current",0},
    { "_Energy","_Illuminance",0},
    { "_Energy","_LuminousFlux",0},
    { "_Energy","_Inductance",0},
    { "_Energy","_MagneticFluxDensity",0},
    { "_Energy","_MagneticFlux",0},
    { "_Energy","_ElectricConductance",0},
    { "_Energy","_ElectricResistance",0},
    { "_Energy","_Capacitance",0},
    { "_Energy","_ElectricPotential",0},
    { "_Energy","_ElectricCharge",0},
    { "_Energy","_Power",0},
    { "_Energy","_float",0},
    { "_Energy","_Length",0},
    { "_Energy","_Mass",0},
    { "_Energy","_Time",0},
    { "_Energy","_ElectricCurrent",0},
    { "_Energy","_Temperature",0},
    { "_Energy","_Amount",0},
    { "_Energy","_LuminousIntensity",0},
    { "_Energy","_PlaneAngle",0},
    { "_Energy","_SolidAngle",0},
    { "_Energy","_Frequency",0},
    { "_Energy","_Force",0},
    { "_Energy","_Pressure",0},
    { "_LuminousFlux","_Conductance",0},
    { "_LuminousFlux","_Resistance",0},
    { "_LuminousFlux","_Voltage",0},
    { "_LuminousFlux","_Charge",0},
    { "_LuminousFlux","_Current",0},
    { "_LuminousFlux","_Illuminance",0},
    { "_LuminousFlux","_float",0},
    { "_LuminousFlux","_Length",0},
    { "_LuminousFlux","_Mass",0},
    { "_LuminousFlux","_Time",0},
    { "_LuminousFlux","_ElectricCurrent",0},
    { "_LuminousFlux","_Temperature",0},
    { "_LuminousFlux","_Amount",0},
    { "_LuminousFlux","_LuminousIntensity",0},
    { "_LuminousFlux","_PlaneAngle",0},
    { "_LuminousFlux","_SolidAngle",0},
    { "_LuminousFlux","_Frequency",0},
    { "_LuminousFlux","_Force",0},
    { "_LuminousFlux","_Pressure",0},
    { "_LuminousFlux","_Energy",0},
    { "_LuminousFlux","_Power",0},
    { "_LuminousFlux","_ElectricCharge",0},
    { "_LuminousFlux","_ElectricPotential",0},
    { "_LuminousFlux","_Capacitance",0},
    { "_LuminousFlux","_ElectricResistance",0},
    { "_LuminousFlux","_ElectricConductance",0},
    { "_LuminousFlux","_MagneticFlux",0},
    { "_LuminousFlux","_MagneticFluxDensity",0},
    { "_LuminousFlux","_Inductance",0},
    { "_long","_unsigned_long",0},
    { "_long","_signed_long",0},
    { "_ElectricResistance","_Conductance",0},
    { "_ElectricResistance","_Resistance",0},
    { "_ElectricResistance","_Voltage",0},
    { "_ElectricResistance","_Charge",0},
    { "_ElectricResistance","_Current",0},
    { "_ElectricResistance","_Illuminance",0},
    { "_ElectricResistance","_LuminousFlux",0},
    { "_ElectricResistance","_Inductance",0},
    { "_ElectricResistance","_MagneticFluxDensity",0},
    { "_ElectricResistance","_MagneticFlux",0},
    { "_ElectricResistance","_ElectricConductance",0},
    { "_ElectricResistance","_float",0},
    { "_ElectricResistance","_Length",0},
    { "_ElectricResistance","_Mass",0},
    { "_ElectricResistance","_Time",0},
    { "_ElectricResistance","_ElectricCurrent",0},
    { "_ElectricResistance","_Temperature",0},
    { "_ElectricResistance","_Amount",0},
    { "_ElectricResistance","_LuminousIntensity",0},
    { "_ElectricResistance","_PlaneAngle",0},
    { "_ElectricResistance","_SolidAngle",0},
    { "_ElectricResistance","_Frequency",0},
    { "_ElectricResistance","_Force",0},
    { "_ElectricResistance","_Pressure",0},
    { "_ElectricResistance","_Energy",0},
    { "_ElectricResistance","_Power",0},
    { "_ElectricResistance","_ElectricCharge",0},
    { "_ElectricResistance","_ElectricPotential",0},
    { "_ElectricResistance","_Capacitance",0},
    { "_Charge","_Conductance",0},
    { "_Charge","_Resistance",0},
    { "_Charge","_Voltage",0},
    { "_Charge","_ElectricCharge",0},
    { "_Charge","_Power",0},
    { "_Charge","_Energy",0},
    { "_Charge","_Pressure",0},
    { "_Charge","_Force",0},
    { "_Charge","_Frequency",0},
    { "_Charge","_SolidAngle",0},
    { "_Charge","_PlaneAngle",0},
    { "_Charge","_LuminousIntensity",0},
    { "_Charge","_Amount",0},
    { "_Charge","_Temperature",0},
    { "_Charge","_ElectricCurrent",0},
    { "_Charge","_Time",0},
    { "_Charge","_Mass",0},
    { "_Charge","_Length",0},
    { "_Charge","_float",0},
    { "_Charge","_ElectricPotential",0},
    { "_Charge","_Capacitance",0},
    { "_Charge","_ElectricResistance",0},
    { "_Charge","_ElectricConductance",0},
    { "_Charge","_MagneticFlux",0},
    { "_Charge","_MagneticFluxDensity",0},
    { "_Charge","_Inductance",0},
    { "_Charge","_LuminousFlux",0},
    { "_Charge","_Illuminance",0},
    { "_Charge","_Current",0},
    { "_float","_Conductance",0},
    { "_float","_Resistance",0},
    { "_float","_Voltage",0},
    { "_float","_Charge",0},
    { "_float","_Current",0},
    { "_float","_Illuminance",0},
    { "_float","_LuminousFlux",0},
    { "_float","_Inductance",0},
    { "_float","_MagneticFluxDensity",0},
    { "_float","_MagneticFlux",0},
    { "_float","_ElectricConductance",0},
    { "_float","_ElectricResistance",0},
    { "_float","_Capacitance",0},
    { "_float","_ElectricPotential",0},
    { "_float","_ElectricCharge",0},
    { "_float","_Power",0},
    { "_float","_Energy",0},
    { "_float","_Pressure",0},
    { "_float","_Force",0},
    { "_float","_Frequency",0},
    { "_float","_SolidAngle",0},
    { "_float","_PlaneAngle",0},
    { "_float","_LuminousIntensity",0},
    { "_float","_Amount",0},
    { "_float","_Temperature",0},
    { "_float","_ElectricCurrent",0},
    { "_float","_Time",0},
    { "_float","_Mass",0},
    { "_float","_Length",0},
    { "_Mass","_Conductance",0},
    { "_Mass","_Resistance",0},
    { "_Mass","_Voltage",0},
    { "_Mass","_Charge",0},
    { "_Mass","_Current",0},
    { "_Mass","_Illuminance",0},
    { "_Mass","_LuminousFlux",0},
    { "_Mass","_Inductance",0},
    { "_Mass","_MagneticFluxDensity",0},
    { "_Mass","_MagneticFlux",0},
    { "_Mass","_ElectricConductance",0},
    { "_Mass","_ElectricResistance",0},
    { "_Mass","_Capacitance",0},
    { "_Mass","_ElectricPotential",0},
    { "_Mass","_ElectricCharge",0},
    { "_Mass","_Power",0},
    { "_Mass","_Energy",0},
    { "_Mass","_Pressure",0},
    { "_Mass","_Force",0},
    { "_Mass","_Frequency",0},
    { "_Mass","_SolidAngle",0},
    { "_Mass","_PlaneAngle",0},
    { "_Mass","_LuminousIntensity",0},
    { "_Mass","_Amount",0},
    { "_Mass","_Temperature",0},
    { "_Mass","_ElectricCurrent",0},
    { "_Mass","_Time",0},
    { "_Mass","_float",0},
    { "_Mass","_Length",0},
    { "_ElectricCharge","_Conductance",0},
    { "_ElectricCharge","_Resistance",0},
    { "_ElectricCharge","_Voltage",0},
    { "_ElectricCharge","_Charge",0},
    { "_ElectricCharge","_Current",0},
    { "_ElectricCharge","_Illuminance",0},
    { "_ElectricCharge","_LuminousFlux",0},
    { "_ElectricCharge","_Inductance",0},
    { "_ElectricCharge","_MagneticFluxDensity",0},
    { "_ElectricCharge","_MagneticFlux",0},
    { "_ElectricCharge","_ElectricConductance",0},
    { "_ElectricCharge","_ElectricResistance",0},
    { "_ElectricCharge","_Capacitance",0},
    { "_ElectricCharge","_ElectricPotential",0},
    { "_ElectricCharge","_float",0},
    { "_ElectricCharge","_Length",0},
    { "_ElectricCharge","_Mass",0},
    { "_ElectricCharge","_Time",0},
    { "_ElectricCharge","_ElectricCurrent",0},
    { "_ElectricCharge","_Temperature",0},
    { "_ElectricCharge","_Amount",0},
    { "_ElectricCharge","_LuminousIntensity",0},
    { "_ElectricCharge","_PlaneAngle",0},
    { "_ElectricCharge","_SolidAngle",0},
    { "_ElectricCharge","_Frequency",0},
    { "_ElectricCharge","_Force",0},
    { "_ElectricCharge","_Pressure",0},
    { "_ElectricCharge","_Energy",0},
    { "_ElectricCharge","_Power",0},
    { "_Temperature","_Conductance",0},
    { "_Temperature","_Resistance",0},
    { "_Temperature","_Voltage",0},
    { "_Temperature","_Charge",0},
    { "_Temperature","_Current",0},
    { "_Temperature","_Illuminance",0},
    { "_Temperature","_LuminousFlux",0},
    { "_Temperature","_Inductance",0},
    { "_Temperature","_MagneticFluxDensity",0},
    { "_Temperature","_MagneticFlux",0},
    { "_Temperature","_ElectricConductance",0},
    { "_Temperature","_ElectricResistance",0},
    { "_Temperature","_Capacitance",0},
    { "_Temperature","_ElectricPotential",0},
    { "_Temperature","_ElectricCharge",0},
    { "_Temperature","_Power",0},
    { "_Temperature","_Energy",0},
    { "_Temperature","_Pressure",0},
    { "_Temperature","_Force",0},
    { "_Temperature","_Frequency",0},
    { "_Temperature","_SolidAngle",0},
    { "_Temperature","_PlaneAngle",0},
    { "_Temperature","_LuminousIntensity",0},
    { "_Temperature","_Amount",0},
    { "_Temperature","_float",0},
    { "_Temperature","_Length",0},
    { "_Temperature","_Mass",0},
    { "_Temperature","_Time",0},
    { "_Temperature","_ElectricCurrent",0},
    { "_Force","_Conductance",0},
    { "_Force","_Resistance",0},
    { "_Force","_Voltage",0},
    { "_Force","_Charge",0},
    { "_Force","_Current",0},
    { "_Force","_Illuminance",0},
    { "_Force","_LuminousFlux",0},
    { "_Force","_Inductance",0},
    { "_Force","_MagneticFluxDensity",0},
    { "_Force","_MagneticFlux",0},
    { "_Force","_ElectricConductance",0},
    { "_Force","_ElectricResistance",0},
    { "_Force","_Capacitance",0},
    { "_Force","_ElectricPotential",0},
    { "_Force","_ElectricCharge",0},
    { "_Force","_Power",0},
    { "_Force","_Energy",0},
    { "_Force","_Pressure",0},
    { "_Force","_float",0},
    { "_Force","_Length",0},
    { "_Force","_Mass",0},
    { "_Force","_Time",0},
    { "_Force","_ElectricCurrent",0},
    { "_Force","_Temperature",0},
    { "_Force","_Amount",0},
    { "_Force","_LuminousIntensity",0},
    { "_Force","_PlaneAngle",0},
    { "_Force","_SolidAngle",0},
    { "_Force","_Frequency",0},
    { "_Power","_Conductance",0},
    { "_Power","_Resistance",0},
    { "_Power","_Voltage",0},
    { "_Power","_Charge",0},
    { "_Power","_Current",0},
    { "_Power","_Illuminance",0},
    { "_Power","_LuminousFlux",0},
    { "_Power","_Inductance",0},
    { "_Power","_MagneticFluxDensity",0},
    { "_Power","_MagneticFlux",0},
    { "_Power","_ElectricConductance",0},
    { "_Power","_ElectricResistance",0},
    { "_Power","_Capacitance",0},
    { "_Power","_ElectricPotential",0},
    { "_Power","_ElectricCharge",0},
    { "_Power","_float",0},
    { "_Power","_Length",0},
    { "_Power","_Mass",0},
    { "_Power","_Time",0},
    { "_Power","_ElectricCurrent",0},
    { "_Power","_Temperature",0},
    { "_Power","_Amount",0},
    { "_Power","_LuminousIntensity",0},
    { "_Power","_PlaneAngle",0},
    { "_Power","_SolidAngle",0},
    { "_Power","_Frequency",0},
    { "_Power","_Force",0},
    { "_Power","_Pressure",0},
    { "_Power","_Energy",0},
    { "_Voltage","_Conductance",0},
    { "_Voltage","_Resistance",0},
    { "_Voltage","_ElectricPotential",0},
    { "_Voltage","_ElectricCharge",0},
    { "_Voltage","_Power",0},
    { "_Voltage","_Energy",0},
    { "_Voltage","_Pressure",0},
    { "_Voltage","_Force",0},
    { "_Voltage","_Frequency",0},
    { "_Voltage","_SolidAngle",0},
    { "_Voltage","_PlaneAngle",0},
    { "_Voltage","_LuminousIntensity",0},
    { "_Voltage","_Amount",0},
    { "_Voltage","_Temperature",0},
    { "_Voltage","_ElectricCurrent",0},
    { "_Voltage","_Time",0},
    { "_Voltage","_Mass",0},
    { "_Voltage","_Length",0},
    { "_Voltage","_float",0},
    { "_Voltage","_Capacitance",0},
    { "_Voltage","_ElectricResistance",0},
    { "_Voltage","_ElectricConductance",0},
    { "_Voltage","_MagneticFlux",0},
    { "_Voltage","_MagneticFluxDensity",0},
    { "_Voltage","_Inductance",0},
    { "_Voltage","_LuminousFlux",0},
    { "_Voltage","_Illuminance",0},
    { "_Voltage","_Current",0},
    { "_Voltage","_Charge",0},
    { "_Capacitance","_Conductance",0},
    { "_Capacitance","_Resistance",0},
    { "_Capacitance","_Voltage",0},
    { "_Capacitance","_Charge",0},
    { "_Capacitance","_Current",0},
    { "_Capacitance","_Illuminance",0},
    { "_Capacitance","_LuminousFlux",0},
    { "_Capacitance","_Inductance",0},
    { "_Capacitance","_MagneticFluxDensity",0},
    { "_Capacitance","_MagneticFlux",0},
    { "_Capacitance","_ElectricConductance",0},
    { "_Capacitance","_ElectricResistance",0},
    { "_Capacitance","_float",0},
    { "_Capacitance","_Length",0},
    { "_Capacitance","_Mass",0},
    { "_Capacitance","_Time",0},
    { "_Capacitance","_ElectricCurrent",0},
    { "_Capacitance","_Temperature",0},
    { "_Capacitance","_Amount",0},
    { "_Capacitance","_LuminousIntensity",0},
    { "_Capacitance","_PlaneAngle",0},
    { "_Capacitance","_SolidAngle",0},
    { "_Capacitance","_Frequency",0},
    { "_Capacitance","_Force",0},
    { "_Capacitance","_Pressure",0},
    { "_Capacitance","_Energy",0},
    { "_Capacitance","_Power",0},
    { "_Capacitance","_ElectricCharge",0},
    { "_Capacitance","_ElectricPotential",0},
    { "_Frequency","_Conductance",0},
    { "_Frequency","_Resistance",0},
    { "_Frequency","_Voltage",0},
    { "_Frequency","_Charge",0},
    { "_Frequency","_Current",0},
    { "_Frequency","_Illuminance",0},
    { "_Frequency","_LuminousFlux",0},
    { "_Frequency","_Inductance",0},
    { "_Frequency","_MagneticFluxDensity",0},
    { "_Frequency","_MagneticFlux",0},
    { "_Frequency","_ElectricConductance",0},
    { "_Frequency","_ElectricResistance",0},
    { "_Frequency","_Capacitance",0},
    { "_Frequency","_ElectricPotential",0},
    { "_Frequency","_ElectricCharge",0},
    { "_Frequency","_Power",0},
    { "_Frequency","_Energy",0},
    { "_Frequency","_Pressure",0},
    { "_Frequency","_Force",0},
    { "_Frequency","_float",0},
    { "_Frequency","_Length",0},
    { "_Frequency","_Mass",0},
    { "_Frequency","_Time",0},
    { "_Frequency","_ElectricCurrent",0},
    { "_Frequency","_Temperature",0},
    { "_Frequency","_Amount",0},
    { "_Frequency","_LuminousIntensity",0},
    { "_Frequency","_PlaneAngle",0},
    { "_Frequency","_SolidAngle",0},
    { "_MagneticFluxDensity","_Conductance",0},
    { "_MagneticFluxDensity","_Resistance",0},
    { "_MagneticFluxDensity","_Voltage",0},
    { "_MagneticFluxDensity","_Charge",0},
    { "_MagneticFluxDensity","_Current",0},
    { "_MagneticFluxDensity","_Illuminance",0},
    { "_MagneticFluxDensity","_LuminousFlux",0},
    { "_MagneticFluxDensity","_Inductance",0},
    { "_MagneticFluxDensity","_float",0},
    { "_MagneticFluxDensity","_Length",0},
    { "_MagneticFluxDensity","_Mass",0},
    { "_MagneticFluxDensity","_Time",0},
    { "_MagneticFluxDensity","_ElectricCurrent",0},
    { "_MagneticFluxDensity","_Temperature",0},
    { "_MagneticFluxDensity","_Amount",0},
    { "_MagneticFluxDensity","_LuminousIntensity",0},
    { "_MagneticFluxDensity","_PlaneAngle",0},
    { "_MagneticFluxDensity","_SolidAngle",0},
    { "_MagneticFluxDensity","_Frequency",0},
    { "_MagneticFluxDensity","_Force",0},
    { "_MagneticFluxDensity","_Pressure",0},
    { "_MagneticFluxDensity","_Energy",0},
    { "_MagneticFluxDensity","_Power",0},
    { "_MagneticFluxDensity","_ElectricCharge",0},
    { "_MagneticFluxDensity","_ElectricPotential",0},
    { "_MagneticFluxDensity","_Capacitance",0},
    { "_MagneticFluxDensity","_ElectricResistance",0},
    { "_MagneticFluxDensity","_ElectricConductance",0},
    { "_MagneticFluxDensity","_MagneticFlux",0},
    { "_ElectricConductance","_Conductance",0},
    { "_ElectricConductance","_Resistance",0},
    { "_ElectricConductance","_Voltage",0},
    { "_ElectricConductance","_Charge",0},
    { "_ElectricConductance","_Current",0},
    { "_ElectricConductance","_Illuminance",0},
    { "_ElectricConductance","_LuminousFlux",0},
    { "_ElectricConductance","_Inductance",0},
    { "_ElectricConductance","_MagneticFluxDensity",0},
    { "_ElectricConductance","_MagneticFlux",0},
    { "_ElectricConductance","_float",0},
    { "_ElectricConductance","_Length",0},
    { "_ElectricConductance","_Mass",0},
    { "_ElectricConductance","_Time",0},
    { "_ElectricConductance","_ElectricCurrent",0},
    { "_ElectricConductance","_Temperature",0},
    { "_ElectricConductance","_Amount",0},
    { "_ElectricConductance","_LuminousIntensity",0},
    { "_ElectricConductance","_PlaneAngle",0},
    { "_ElectricConductance","_SolidAngle",0},
    { "_ElectricConductance","_Frequency",0},
    { "_ElectricConductance","_Force",0},
    { "_ElectricConductance","_Pressure",0},
    { "_ElectricConductance","_Energy",0},
    { "_ElectricConductance","_Power",0},
    { "_ElectricConductance","_ElectricCharge",0},
    { "_ElectricConductance","_ElectricPotential",0},
    { "_ElectricConductance","_Capacitance",0},
    { "_ElectricConductance","_ElectricResistance",0},
    { "_unsigned_long","_long",0},
    { "_ElectricPotential","_Conductance",0},
    { "_ElectricPotential","_Resistance",0},
    { "_ElectricPotential","_Voltage",0},
    { "_ElectricPotential","_Charge",0},
    { "_ElectricPotential","_Current",0},
    { "_ElectricPotential","_Illuminance",0},
    { "_ElectricPotential","_LuminousFlux",0},
    { "_ElectricPotential","_Inductance",0},
    { "_ElectricPotential","_MagneticFluxDensity",0},
    { "_ElectricPotential","_MagneticFlux",0},
    { "_ElectricPotential","_ElectricConductance",0},
    { "_ElectricPotential","_ElectricResistance",0},
    { "_ElectricPotential","_Capacitance",0},
    { "_ElectricPotential","_float",0},
    { "_ElectricPotential","_Length",0},
    { "_ElectricPotential","_Mass",0},
    { "_ElectricPotential","_Time",0},
    { "_ElectricPotential","_ElectricCurrent",0},
    { "_ElectricPotential","_Temperature",0},
    { "_ElectricPotential","_Amount",0},
    { "_ElectricPotential","_LuminousIntensity",0},
    { "_ElectricPotential","_PlaneAngle",0},
    { "_ElectricPotential","_SolidAngle",0},
    { "_ElectricPotential","_Frequency",0},
    { "_ElectricPotential","_Force",0},
    { "_ElectricPotential","_Pressure",0},
    { "_ElectricPotential","_Energy",0},
    { "_ElectricPotential","_Power",0},
    { "_ElectricPotential","_ElectricCharge",0},
    { "_signed_int","_int",0},
    { "_ElectricCurrent","_Conductance",0},
    { "_ElectricCurrent","_Resistance",0},
    { "_ElectricCurrent","_Voltage",0},
    { "_ElectricCurrent","_Charge",0},
    { "_ElectricCurrent","_Current",0},
    { "_ElectricCurrent","_Illuminance",0},
    { "_ElectricCurrent","_LuminousFlux",0},
    { "_ElectricCurrent","_Inductance",0},
    { "_ElectricCurrent","_MagneticFluxDensity",0},
    { "_ElectricCurrent","_MagneticFlux",0},
    { "_ElectricCurrent","_ElectricConductance",0},
    { "_ElectricCurrent","_ElectricResistance",0},
    { "_ElectricCurrent","_Capacitance",0},
    { "_ElectricCurrent","_ElectricPotential",0},
    { "_ElectricCurrent","_ElectricCharge",0},
    { "_ElectricCurrent","_Power",0},
    { "_ElectricCurrent","_Energy",0},
    { "_ElectricCurrent","_Pressure",0},
    { "_ElectricCurrent","_Force",0},
    { "_ElectricCurrent","_Frequency",0},
    { "_ElectricCurrent","_SolidAngle",0},
    { "_ElectricCurrent","_PlaneAngle",0},
    { "_ElectricCurrent","_LuminousIntensity",0},
    { "_ElectricCurrent","_Amount",0},
    { "_ElectricCurrent","_Temperature",0},
    { "_ElectricCurrent","_float",0},
    { "_ElectricCurrent","_Length",0},
    { "_ElectricCurrent","_Mass",0},
    { "_ElectricCurrent","_Time",0},
    { "_Resistance","_Conductance",0},
    { "_Resistance","_ElectricResistance",0},
    { "_Resistance","_Capacitance",0},
    { "_Resistance","_ElectricPotential",0},
    { "_Resistance","_ElectricCharge",0},
    { "_Resistance","_Power",0},
    { "_Resistance","_Energy",0},
    { "_Resistance","_Pressure",0},
    { "_Resistance","_Force",0},
    { "_Resistance","_Frequency",0},
    { "_Resistance","_SolidAngle",0},
    { "_Resistance","_PlaneAngle",0},
    { "_Resistance","_LuminousIntensity",0},
    { "_Resistance","_Amount",0},
    { "_Resistance","_Temperature",0},
    { "_Resistance","_ElectricCurrent",0},
    { "_Resistance","_Time",0},
    { "_Resistance","_Mass",0},
    { "_Resistance","_Length",0},
    { "_Resistance","_float",0},
    { "_Resistance","_ElectricConductance",0},
    { "_Resistance","_MagneticFlux",0},
    { "_Resistance","_MagneticFluxDensity",0},
    { "_Resistance","_Inductance",0},
    { "_Resistance","_LuminousFlux",0},
    { "_Resistance","_Illuminance",0},
    { "_Resistance","_Current",0},
    { "_Resistance","_Charge",0},
    { "_Resistance","_Voltage",0},
    { "_MagneticFlux","_Conductance",0},
    { "_MagneticFlux","_Resistance",0},
    { "_MagneticFlux","_Voltage",0},
    { "_MagneticFlux","_Charge",0},
    { "_MagneticFlux","_Current",0},
    { "_MagneticFlux","_Illuminance",0},
    { "_MagneticFlux","_LuminousFlux",0},
    { "_MagneticFlux","_Inductance",0},
    { "_MagneticFlux","_MagneticFluxDensity",0},
    { "_MagneticFlux","_float",0},
    { "_MagneticFlux","_Length",0},
    { "_MagneticFlux","_Mass",0},
    { "_MagneticFlux","_Time",0},
    { "_MagneticFlux","_ElectricCurrent",0},
    { "_MagneticFlux","_Temperature",0},
    { "_MagneticFlux","_Amount",0},
    { "_MagneticFlux","_LuminousIntensity",0},
    { "_MagneticFlux","_PlaneAngle",0},
    { "_MagneticFlux","_SolidAngle",0},
    { "_MagneticFlux","_Frequency",0},
    { "_MagneticFlux","_Force",0},
    { "_MagneticFlux","_Pressure",0},
    { "_MagneticFlux","_Energy",0},
    { "_MagneticFlux","_Power",0},
    { "_MagneticFlux","_ElectricCharge",0},
    { "_MagneticFlux","_ElectricPotential",0},
    { "_MagneticFlux","_Capacitance",0},
    { "_MagneticFlux","_ElectricResistance",0},
    { "_MagneticFlux","_ElectricConductance",0},
    { "_Pressure","_Conductance",0},
    { "_Pressure","_Resistance",0},
    { "_Pressure","_Voltage",0},
    { "_Pressure","_Charge",0},
    { "_Pressure","_Current",0},
    { "_Pressure","_Illuminance",0},
    { "_Pressure","_LuminousFlux",0},
    { "_Pressure","_Inductance",0},
    { "_Pressure","_MagneticFluxDensity",0},
    { "_Pressure","_MagneticFlux",0},
    { "_Pressure","_ElectricConductance",0},
    { "_Pressure","_ElectricResistance",0},
    { "_Pressure","_Capacitance",0},
    { "_Pressure","_ElectricPotential",0},
    { "_Pressure","_ElectricCharge",0},
    { "_Pressure","_Power",0},
    { "_Pressure","_Energy",0},
    { "_Pressure","_float",0},
    { "_Pressure","_Length",0},
    { "_Pressure","_Mass",0},
    { "_Pressure","_Time",0},
    { "_Pressure","_ElectricCurrent",0},
    { "_Pressure","_Temperature",0},
    { "_Pressure","_Amount",0},
    { "_Pressure","_LuminousIntensity",0},
    { "_Pressure","_PlaneAngle",0},
    { "_Pressure","_SolidAngle",0},
    { "_Pressure","_Frequency",0},
    { "_Pressure","_Force",0},
    { "_unsigned_short","_short",0},
    { "_Current","_Conductance",0},
    { "_Current","_Resistance",0},
    { "_Current","_Voltage",0},
    { "_Current","_Charge",0},
    { "_Current","_ElectricCurrent",0},
    { "_Current","_Time",0},
    { "_Current","_Mass",0},
    { "_Current","_Length",0},
    { "_Current","_float",0},
    { "_Current","_Temperature",0},
    { "_Current","_Amount",0},
    { "_Current","_LuminousIntensity",0},
    { "_Current","_PlaneAngle",0},
    { "_Current","_SolidAngle",0},
    { "_Current","_Frequency",0},
    { "_Current","_Force",0},
    { "_Current","_Pressure",0},
    { "_Current","_Energy",0},
    { "_Current","_Power",0},
    { "_Current","_ElectricCharge",0},
    { "_Current","_ElectricPotential",0},
    { "_Current","_Capacitance",0},
    { "_Current","_ElectricResistance",0},
    { "_Current","_ElectricConductance",0},
    { "_Current","_MagneticFlux",0},
    { "_Current","_MagneticFluxDensity",0},
    { "_Current","_Inductance",0},
    { "_Current","_LuminousFlux",0},
    { "_Current","_Illuminance",0},
    { "_signed_short","_short",0},
    { "_Illuminance","_Conductance",0},
    { "_Illuminance","_Resistance",0},
    { "_Illuminance","_Voltage",0},
    { "_Illuminance","_Charge",0},
    { "_Illuminance","_Current",0},
    { "_Illuminance","_float",0},
    { "_Illuminance","_Length",0},
    { "_Illuminance","_Mass",0},
    { "_Illuminance","_Time",0},
    { "_Illuminance","_ElectricCurrent",0},
    { "_Illuminance","_Temperature",0},
    { "_Illuminance","_Amount",0},
    { "_Illuminance","_LuminousIntensity",0},
    { "_Illuminance","_PlaneAngle",0},
    { "_Illuminance","_SolidAngle",0},
    { "_Illuminance","_Frequency",0},
    { "_Illuminance","_Force",0},
    { "_Illuminance","_Pressure",0},
    { "_Illuminance","_Energy",0},
    { "_Illuminance","_Power",0},
    { "_Illuminance","_ElectricCharge",0},
    { "_Illuminance","_ElectricPotential",0},
    { "_Illuminance","_Capacitance",0},
    { "_Illuminance","_ElectricResistance",0},
    { "_Illuminance","_ElectricConductance",0},
    { "_Illuminance","_MagneticFlux",0},
    { "_Illuminance","_MagneticFluxDensity",0},
    { "_Illuminance","_Inductance",0},
    { "_Illuminance","_LuminousFlux",0},
    { "_unsigned_int","_int",0},
    { "_short","_unsigned_short",0},
    { "_short","_signed_short",0},
    { "_Inductance","_Conductance",0},
    { "_Inductance","_Resistance",0},
    { "_Inductance","_Voltage",0},
    { "_Inductance","_Charge",0},
    { "_Inductance","_Current",0},
    { "_Inductance","_Illuminance",0},
    { "_Inductance","_LuminousFlux",0},
    { "_Inductance","_float",0},
    { "_Inductance","_Length",0},
    { "_Inductance","_Mass",0},
    { "_Inductance","_Time",0},
    { "_Inductance","_ElectricCurrent",0},
    { "_Inductance","_Temperature",0},
    { "_Inductance","_Amount",0},
    { "_Inductance","_LuminousIntensity",0},
    { "_Inductance","_PlaneAngle",0},
    { "_Inductance","_SolidAngle",0},
    { "_Inductance","_Frequency",0},
    { "_Inductance","_Force",0},
    { "_Inductance","_Pressure",0},
    { "_Inductance","_Energy",0},
    { "_Inductance","_Power",0},
    { "_Inductance","_ElectricCharge",0},
    { "_Inductance","_ElectricPotential",0},
    { "_Inductance","_Capacitance",0},
    { "_Inductance","_ElectricResistance",0},
    { "_Inductance","_ElectricConductance",0},
    { "_Inductance","_MagneticFlux",0},
    { "_Inductance","_MagneticFluxDensity",0},
    { "_int","_unsigned_int",0},
    { "_int","_signed_int",0},
    { "_PlaneAngle","_Conductance",0},
    { "_PlaneAngle","_Resistance",0},
    { "_PlaneAngle","_Voltage",0},
    { "_PlaneAngle","_Charge",0},
    { "_PlaneAngle","_Current",0},
    { "_PlaneAngle","_Illuminance",0},
    { "_PlaneAngle","_LuminousFlux",0},
    { "_PlaneAngle","_Inductance",0},
    { "_PlaneAngle","_MagneticFluxDensity",0},
    { "_PlaneAngle","_MagneticFlux",0},
    { "_PlaneAngle","_ElectricConductance",0},
    { "_PlaneAngle","_ElectricResistance",0},
    { "_PlaneAngle","_Capacitance",0},
    { "_PlaneAngle","_ElectricPotential",0},
    { "_PlaneAngle","_ElectricCharge",0},
    { "_PlaneAngle","_Power",0},
    { "_PlaneAngle","_Energy",0},
    { "_PlaneAngle","_Pressure",0},
    { "_PlaneAngle","_Force",0},
    { "_PlaneAngle","_Frequency",0},
    { "_PlaneAngle","_SolidAngle",0},
    { "_PlaneAngle","_float",0},
    { "_PlaneAngle","_Length",0},
    { "_PlaneAngle","_Mass",0},
    { "_PlaneAngle","_Time",0},
    { "_PlaneAngle","_ElectricCurrent",0},
    { "_PlaneAngle","_Temperature",0},
    { "_PlaneAngle","_Amount",0},
    { "_PlaneAngle","_LuminousIntensity",0},
    { "_Length","_Conductance",0},
    { "_Length","_Resistance",0},
    { "_Length","_Voltage",0},
    { "_Length","_Charge",0},
    { "_Length","_Current",0},
    { "_Length","_Illuminance",0},
    { "_Length","_LuminousFlux",0},
    { "_Length","_Inductance",0},
    { "_Length","_MagneticFluxDensity",0},
    { "_Length","_MagneticFlux",0},
    { "_Length","_ElectricConductance",0},
    { "_Length","_ElectricResistance",0},
    { "_Length","_Capacitance",0},
    { "_Length","_ElectricPotential",0},
    { "_Length","_ElectricCharge",0},
    { "_Length","_Power",0},
    { "_Length","_Energy",0},
    { "_Length","_Pressure",0},
    { "_Length","_Force",0},
    { "_Length","_Frequency",0},
    { "_Length","_SolidAngle",0},
    { "_Length","_PlaneAngle",0},
    { "_Length","_LuminousIntensity",0},
    { "_Length","_Amount",0},
    { "_Length","_Temperature",0},
    { "_Length","_ElectricCurrent",0},
    { "_Length","_Time",0},
    { "_Length","_Mass",0},
    { "_Length","_float",0},
    { "_SolidAngle","_Conductance",0},
    { "_SolidAngle","_Resistance",0},
    { "_SolidAngle","_Voltage",0},
    { "_SolidAngle","_Charge",0},
    { "_SolidAngle","_Current",0},
    { "_SolidAngle","_Illuminance",0},
    { "_SolidAngle","_LuminousFlux",0},
    { "_SolidAngle","_Inductance",0},
    { "_SolidAngle","_MagneticFluxDensity",0},
    { "_SolidAngle","_MagneticFlux",0},
    { "_SolidAngle","_ElectricConductance",0},
    { "_SolidAngle","_ElectricResistance",0},
    { "_SolidAngle","_Capacitance",0},
    { "_SolidAngle","_ElectricPotential",0},
    { "_SolidAngle","_ElectricCharge",0},
    { "_SolidAngle","_Power",0},
    { "_SolidAngle","_Energy",0},
    { "_SolidAngle","_Pressure",0},
    { "_SolidAngle","_Force",0},
    { "_SolidAngle","_Frequency",0},
    { "_SolidAngle","_float",0},
    { "_SolidAngle","_Length",0},
    { "_SolidAngle","_Mass",0},
    { "_SolidAngle","_Time",0},
    { "_SolidAngle","_ElectricCurrent",0},
    { "_SolidAngle","_Temperature",0},
    { "_SolidAngle","_Amount",0},
    { "_SolidAngle","_LuminousIntensity",0},
    { "_SolidAngle","_PlaneAngle",0},
    { "_Amount","_Conductance",0},
    { "_Amount","_Resistance",0},
    { "_Amount","_Voltage",0},
    { "_Amount","_Charge",0},
    { "_Amount","_Current",0},
    { "_Amount","_Illuminance",0},
    { "_Amount","_LuminousFlux",0},
    { "_Amount","_Inductance",0},
    { "_Amount","_MagneticFluxDensity",0},
    { "_Amount","_MagneticFlux",0},
    { "_Amount","_ElectricConductance",0},
    { "_Amount","_ElectricResistance",0},
    { "_Amount","_Capacitance",0},
    { "_Amount","_ElectricPotential",0},
    { "_Amount","_ElectricCharge",0},
    { "_Amount","_Power",0},
    { "_Amount","_Energy",0},
    { "_Amount","_Pressure",0},
    { "_Amount","_Force",0},
    { "_Amount","_Frequency",0},
    { "_Amount","_SolidAngle",0},
    { "_Amount","_PlaneAngle",0},
    { "_Amount","_LuminousIntensity",0},
    { "_Amount","_float",0},
    { "_Amount","_Length",0},
    { "_Amount","_Mass",0},
    { "_Amount","_Time",0},
    { "_Amount","_ElectricCurrent",0},
    { "_Amount","_Temperature",0},
    { "_Conductance","_ElectricConductance",0},
    { "_Conductance","_ElectricResistance",0},
    { "_Conductance","_Capacitance",0},
    { "_Conductance","_ElectricPotential",0},
    { "_Conductance","_ElectricCharge",0},
    { "_Conductance","_Power",0},
    { "_Conductance","_Energy",0},
    { "_Conductance","_Pressure",0},
    { "_Conductance","_Force",0},
    { "_Conductance","_Frequency",0},
    { "_Conductance","_SolidAngle",0},
    { "_Conductance","_PlaneAngle",0},
    { "_Conductance","_LuminousIntensity",0},
    { "_Conductance","_Amount",0},
    { "_Conductance","_Temperature",0},
    { "_Conductance","_ElectricCurrent",0},
    { "_Conductance","_Time",0},
    { "_Conductance","_Mass",0},
    { "_Conductance","_Length",0},
    { "_Conductance","_float",0},
    { "_Conductance","_MagneticFlux",0},
    { "_Conductance","_MagneticFluxDensity",0},
    { "_Conductance","_Inductance",0},
    { "_Conductance","_LuminousFlux",0},
    { "_Conductance","_Illuminance",0},
    { "_Conductance","_Current",0},
    { "_Conductance","_Charge",0},
    { "_Conductance","_Voltage",0},
    { "_Conductance","_Resistance",0},
    { "_Time","_Conductance",0},
    { "_Time","_Resistance",0},
    { "_Time","_Voltage",0},
    { "_Time","_Charge",0},
    { "_Time","_Current",0},
    { "_Time","_Illuminance",0},
    { "_Time","_LuminousFlux",0},
    { "_Time","_Inductance",0},
    { "_Time","_MagneticFluxDensity",0},
    { "_Time","_MagneticFlux",0},
    { "_Time","_ElectricConductance",0},
    { "_Time","_ElectricResistance",0},
    { "_Time","_Capacitance",0},
    { "_Time","_ElectricPotential",0},
    { "_Time","_ElectricCharge",0},
    { "_Time","_Power",0},
    { "_Time","_Energy",0},
    { "_Time","_Pressure",0},
    { "_Time","_Force",0},
    { "_Time","_Frequency",0},
    { "_Time","_SolidAngle",0},
    { "_Time","_PlaneAngle",0},
    { "_Time","_LuminousIntensity",0},
    { "_Time","_Amount",0},
    { "_Time","_Temperature",0},
    { "_Time","_ElectricCurrent",0},
    { "_Time","_float",0},
    { "_Time","_Length",0},
    { "_Time","_Mass",0},
{0,0,0}};

SWIGEXPORT(int) Units_Init(Tcl_Interp *interp) {
#ifdef ITCL_NAMESPACES
	 Itcl_Namespace spaceId;
#endif
	 if (interp == 0) 
		 return TCL_ERROR;
	 SWIG_RegisterType();
#if (TCL_MAJOR_VERSION >= 8)
	 Tcl_Eval(interp,"namespace eval units { }");
#endif
	 Tcl_CreateObjCommand(interp, SWIG_prefix "new", _wrap_units_new, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "convert", _wrap_units_convert, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
	 Tcl_CreateObjCommand(interp, SWIG_prefix "reduce", _wrap_units_reduce, (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);

/*
 *------------------------------------------------------------------
 *
 *  units.i module initialization
 *
 *------------------------------------------------------------------
 */

#ifdef SWIGTCL8
/*
 *------------------------------------------------------------------
 *  package definition
 *
 *  The units functions are provided as a package.  If SWIG
 *  is run with the -namespace switch, then they will be
 *  in the units namespace.  If units_wrap.c is compiled with
 *  -DUSE_TCL_STUBS flag, and linked against libtclstub8.x 
 *  instead of libtcl8.x, then the dynamic library can be
 *  loaded into any stub-ified version of Tcl (8.1 or higher).
 *------------------------------------------------------------------
 */
  Tcl_PkgProvide(interp,"units","1.2");
#ifdef USE_TCL_STUBS
  if (Tcl_InitStubs(interp,"8.1",0) == NULL) {
    return TCL_ERROR;
  }
#endif
#endif


  /*
   *---------------------------------------------------------------
   *
   *  default/target unit initialization
   *
   *---------------------------------------------------------------
   */


#ifdef SWIGTCL8
  /*
   *---------------------------------------------------------------
   *
   *  Save this Tcl interpreter so that the initialization
   *  and Default/Target unit routines work.
   *
   *---------------------------------------------------------------
   */
  unitsInterpreter = interp ;

#endif /*  ifdef SWIGTCL8  */

  /*
   *---------------------------------------------------------------
   *
   *  Initialize default and target units arrays (hash tables)
   *
   *---------------------------------------------------------------
   */
  {
    int i;
    for (i=0; i<UNITSDEFAULTTABLESIZE; i++ ) {
      unitsSetDefault(unitsDefaultTable[i].name, unitsDefaultTable[i].unit);
      unitsSetTarget(unitsDefaultTable[i].name, unitsDefaultTable[i].unit);
    }
  }


{
   int i;
   for (i = 0; _swig_mapping[i].n1; i++)
        SWIG_RegisterMapping(_swig_mapping[i].n1,_swig_mapping[i].n2,_swig_mapping[i].pcnv);
}
	 return TCL_OK;
}
