#ifndef _TKGSXLIBINT
#define _TKGSXLIBINT

/*
 * if the BUILD_XlibTkGS macro is defined, the assumption is that we are
 * building the dynamic library.
 */

#ifdef BUILD_XlibTkGS
# undef TCL_STORAGE_CLASS
# define TCL_STORAGE_CLASS DLLEXPORT
#endif

#include "tkgsXlibDrawable.h"
#include "tkgsXlibColor.h"
#include "tkgsXlibFont.h"

#define DECLAREDRAWINGVARS(d, intRepPtr, display, xd, xgc) \
    register TkGS_InternalRep *intRepPtr  = TkGS_FindInternalRep((TkGS_Obj *) (d), XlibDrawableTypePtr); \
    Display *display = XlibDrawable_Display(intRepPtr); \
    Drawable xd      = XlibDrawable_Drawable(intRepPtr); \
    GC xgc	     = XlibDrawable_GC(intRepPtr);


/*
 * Text and font primitives.
 */

TkGS_GetFontMetricsProc			XlibTkGS_GetFontMetrics;
TkGS_GetActualFontAttributesProc	XlibTkGS_GetActualFontAttributes;
TkGS_EnumerateFontFamiliesProc		XlibTkGS_EnumerateFontFamilies;
TkGS_FontFamilyExistsProc		XlibTkGS_FontFamilyExists;

TkGS_MeasureCharsUniProc		XlibTkGS_MeasureCharsUni;
TkGS_DrawCharsUniProc			XlibTkGS_DrawCharsUni;

TkGS_MeasureCharsUtfProc		XlibTkGS_MeasureCharsUtf;
TkGS_DrawCharsUtfProc			XlibTkGS_DrawCharsUtf;

TkGS_TextWidthSysProc			XlibTkGS_TextWidthSys;
TkGS_DrawCharsSysProc			XlibTkGS_DrawCharsSys;


/*
 * Multi-font Unicode primitives
 */


TkGSGetSubFontProc			XlibTkGSGetSubFont;
TkGSSetDrawableSubFontProc		XlibTkGSSetDrawableSubFont;
TkGSFontMapLoadPageProc			XlibTkGSFontMapLoadPage;
TkGSCanUseFontProc			XlibTkGSCanUseFont;
TkGSCanUseFallbackProc			XlibTkGSCanUseFallback;
TkGSDefaultSubFontProc			XlibTkGSDefaultSubFont;

/*  - Unicode version */

TkGS_MeasureCharsUniProc		XlibTkGSSubFontMeasureCharsUni;
TkGS_TextWidthUniProc			XlibTkGSSubFontTextWidthUni;
TkGS_DrawCharsUniProc			XlibTkGSSubFontDrawCharsUni;

/*  - UTF-8 version */

TkGS_MeasureCharsUtfProc		XlibTkGSSubFontMeasureCharsUtf;
TkGS_TextWidthUtfProc			XlibTkGSSubFontTextWidthUtf;
TkGS_DrawCharsUtfProc			XlibTkGSSubFontDrawCharsUtf;


extern void XlibTkGSInitFontPackage _ANSI_ARGS_(());


/*
 * end of tkgsXlibInt.h
 * reset TCL_STORAGE_CLASS to DLLIMPORT.
 */

# undef TCL_STORAGE_CLASS
# define TCL_STORAGE_CLASS DLLIMPORT

#endif /* _TKGSXLIBINT */

