#include "SC.h"
#include "SCLib.h"

/* ------------------------------------------------------------ */
void
ApplyReduction(Op,Direction,ground,M,result)	/* ARGSUSED */
     Function	Op;
     ReduceDir	Direction;
     IF1OBJECT	*ground;
     IF1OBJECT	*M;
     IF1OBJECT	*result;
{
  TypeD		IT[2],OT[1];
  unsigned	i,j,Count;
  NodeStuff	OpInfo;

  IF1OBJECT	*LastResult,LastResultValue;

  IF1OBJECT	*Stack[(TreeDepth<3)?(3):(TreeDepth)];
  IF1OBJECT	StackValues[(TreeDepth<3)?(3):(TreeDepth)];
  int		StackTop;

  if ( IsEmptyObject(M) ) {
    Count = 0;
  } else {
    Count = MultTrueSize(M);
  }

  if (Count == 0) {
    *result = *ground;
  } else if ( Count == 1 )
  {
    GetFromMult(M,0,result);
  }
  else 
  {
    IT[0] = TypeOf(ground);
    IT[1] = TypeOf(ground);
    OT[0] = TypeOf(ground);
  
    BuildNodeInfo(&OpInfo,2,1,IT,OT);

    switch ( Direction ) {
     case TREE:
      /* Set up stack values... */
      for(i=0;i<((TreeDepth<3)?(3):(TreeDepth));i++) Stack[i] = StackValues+i;
      StackTop = 0;

      LastResult = &LastResultValue;

      /* Traverse the tree */
      for(i=0;i<Count;i++) {
	if (StackTop == TreeDepth) Oops("Stack overflow in tree reduction");

	GetFromMult(M,i,Stack[StackTop++]);

	/* Collapse the tree on odd bits in the address */
	for(j=i;j & 0x1;j = j >> 1) {
	  Op(Stack+StackTop-2,&LastResult,&OpInfo);
	  *Stack[--StackTop-1] = *LastResult;
	}
      }

      /* Collapse any left over pieces */
      while (StackTop > 1) {
	Op(Stack+StackTop-2,&LastResult,&OpInfo);
	*Stack[--StackTop-1] = *LastResult;
      }

      *result = *LastResult;
      break;

     case LEFT:

      Stack[0] = StackValues+0;
      Stack[1] = StackValues+1;
      Stack[2] = StackValues+2;

      /* Get the first result */
      GetFromMult(M,(unsigned)0,Stack[0]);

      /* Op in the remaining values */
      for(i = 1; i<Count; i++) {
	GetFromMult(M,i,Stack[1]);

	Op(Stack,Stack+2,&OpInfo);

	Stack[0] = Stack[2];
      }

      *result = *Stack[0];

      break;

     case RIGHT:
      Stack[0] = StackValues+0;
      Stack[1] = StackValues+1;
      Stack[2] = StackValues+2;

      /* Get the first result */
      GetFromMult(M,Count-1,Stack[0]);

      /* Op in the remaining values */
      for(i = 1; i<Count; i++) {
	GetFromMult(M,Count-1-i,Stack[1]);

	Op(Stack,Stack+2,&OpInfo);

	Stack[0] = Stack[2];
      }

      *result = *Stack[0];
    }
  }
}
/* ------------------------------------------------------------ */
void
SUM_(Direction,ground,M,result,good) /* ARGSUSED */
     ReduceDir	Direction;
     IF1OBJECT	*ground;
     IF1OBJECT	*M;
     IF1OBJECT	*result;
     int	good;		/* -1 if all values are OK, else # of */
				/* good results before an */
				/* error[boolean] on a conditional */
				/* reduction. */
{
  if ( good < MultTrueSize(M) ) {
    MakeError(result,TypeOf(ground));
  } else {
    ApplyReduction(Plus,Direction,ground,M,result);
  }
}
/* ------------------------------------------------------------ */
void
PRODUCT_(Direction,ground,M,result,good) /* ARGSUSED */
     ReduceDir	Direction;
     IF1OBJECT	*ground;
     IF1OBJECT	*M;
     IF1OBJECT	*result;
     int	good;		/* -1 if all values are OK, else # of */
				/* good results before an */
				/* error[boolean] on a conditional */
				/* reduction. */
{
  if ( good < MultTrueSize(M) ) {
    MakeError(result,TypeOf(ground));
  } else {
    ApplyReduction(Times,Direction,ground,M,result);
  }
}
/* ------------------------------------------------------------ */
void
LEAST_(Direction,ground,M,result,good) /* ARGSUSED */
     ReduceDir	Direction;
     IF1OBJECT	*ground;
     IF1OBJECT	*M;
     IF1OBJECT	*result;
     int	good;		/* -1 if all values are OK, else # of */
				/* good results before an */
				/* error[boolean] on a conditional */
				/* reduction. */
{
  IF1OBJECT	Err;

  if ( good < MultTrueSize(M) ) {
    MakeError(result,TypeOf(ground));
  } else {
    MakeError(&Err,TypeOf(ground));
    ApplyReduction(Min,Direction,&Err,M,result);
  }
}
/* ------------------------------------------------------------ */
void
GREATEST_(Direction,ground,M,result,good)	/* ARGSUSED */
     ReduceDir	Direction;
     IF1OBJECT	*ground;
     IF1OBJECT	*M;
     IF1OBJECT	*result;
     int	good;		/* -1 if all values are OK, else # of */
				/* good results before an */
				/* error[boolean] on a conditional */
				/* reduction. */
{
  IF1OBJECT	Err;

  if ( good < MultTrueSize(M) ) {
    MakeError(result,TypeOf(ground));
  } else {
    MakeError(&Err,TypeOf(ground));
    ApplyReduction(Max,Direction,&Err,M,result);
  }
}
/* ------------------------------------------------------------ */
void
CATENATE_(Direction,ground,M,result,good)	/* ARGSUSED */
     ReduceDir	Direction;
     IF1OBJECT	*ground;
     IF1OBJECT	*M;
     IF1OBJECT	*result;
     int	good;		/* -1 if all values are OK, else # of */
				/* good results before an */
				/* error[boolean] on a conditional */
				/* reduction. */
{
  TypeD		T,MType;
  int		Count;
  IF1OBJECT	EL;
  unsigned	i,TSize,PSize,View,SizeOfComponent;
  BagPtr	B;

  /* Type Info about the multiple */
  T		= TypeOf(M);
  MType		= ElementTypeOfMultiple(T);

  /* Make sure we only work on strict streams or arrays... */
  if ( ARRAYLIKE(MType) || IsEmptyObject(M) ) {
    if ( IsEmptyObject(M) ) {
      Count = 0;
    } else {
      Count = MultTrueSize(M);
    }

    if (Count == 0) {
      FCopy(result,ground,aARRAY);
    } else {
      /* Figure out the prefix size and total size of the final array */
      /* Make sure not to fully include any arrays past the good count */
      for(PSize=0,TSize=0,i=0; i < Count; i++ ) {
	GetFromMult(M,i,&EL);
	if ( PSize==TSize && i < good) PSize += ArrPS(&EL);
	TSize += ArrTS(&EL);
      }

      /* For each bag, append it to the new big bag.  Don't append any */
      /* arrays past the count of good items. */
      for(B = EmptyBag(PSize),View=0,i=0; i < Count && View < PSize; i++ ) {
	GetFromMult(M,i,&EL);
	SizeOfComponent = ArrPS(&EL);
	if ( SizeOfComponent ) {
	  AppendBags(B,View,ArrCol(&EL),ArrView(&EL),SizeOfComponent);
	  View += SizeOfComponent;
	}
      }

      CreateArray(result,
		  TypeOf(ground),
		  (SisalBoolean)(TSize == PSize),
		  FALSE,IntegerOne,
		  TSize,PSize,B,0);
    }
  } else {
    Oops("Non-strict streams not implemented for value of Catentate");
  }
}
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
void
Reduce(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{AnyReduce(DefaultReduction,in,out,info);}

void
ReduceLeft(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{AnyReduce(LEFT,in,out,info);}

void
ReduceRight(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{AnyReduce(RIGHT,in,out,info);}

void
ReduceTree(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{AnyReduce(TREE,in,out,info);}

/* ------------------------------------------------------------ */
void
AnyReduce(Direction,in,out,info)
     ReduceDir	Direction;
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
# define	FUNC	(0)
# define	GROUND	(1)
# define	VALUES	(2)
# define	FLAGS	(3)
# define	RESULT	(0)

  IF1OBJECT	*FuncPtr,*GroundPtr,*ValuesPtr,*FlagsPtr,*ResultPtr;
  NoWorkIfNoOutput();

  /* ------------------------------------------------------------ */
  /* Conditional Reduction */
  if (INARITY(info) > 3) {
    BagPtr	B;
    unsigned	Size;
    IF1OBJECT	TEMP,*TEMPPTR;
    int		Good;

    FuncPtr	= in[FUNC];
    GroundPtr	= in[GROUND];
    ValuesPtr	= in[VALUES];
    FlagsPtr	= in[FLAGS];
    ResultPtr	= out[RESULT];

    Size = NumberOfTrueInMultiple(FlagsPtr);
    B = ConditionalCollect(ValuesPtr,FlagsPtr,Size,&Good);
    TEMPPTR = MakeMultipleFromBag(IType(info)[VALUES],B,Size,&TEMP);

    FunCode(FuncPtr)(Direction,GroundPtr,TEMPPTR,
		     ResultPtr,Good);

    /* ------------------------------------------------------------ */
    /* Full reductions */
  } else {
    FuncPtr	= in[FUNC];
    GroundPtr	= in[GROUND];
    ValuesPtr	= in[VALUES];
    ResultPtr	= out[RESULT];

    FunCode(FuncPtr)(Direction,GroundPtr,ValuesPtr,
		     ResultPtr,MultTrueSize(ValuesPtr));

  }

# undef		FUNC
# undef		GROUND
# undef		VALUES
# undef		FLAGS
# undef		RESULT
}
