#include "SC.h"
#include "SCLib.h"

/* ------------------------------------------------------------ */
void
RBuild(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define Val	(0)
#define OutR	(0)

  TypeD		RecordType;
  unsigned	i,FieldCount;
  IF1OBJECT	*NewRecord,*Element;
  BagPtr	Collection;
  
  RecordType	= OType(info)[OutR];

  /* RBuild is overloaded for RECORD and UNION */
  if ( UNIONTYPE(RecordType) ) {
    UBuild(in,out,info);
    return;
  }

  NoWorkIfNoOutput();

  NewRecord		= out[OutR];

  FieldCount		= FieldCountOfRecord(RecordType);
  Collection		= EmptyBag(FieldCount);

  for(i=0;i<FieldCount;i++) {
    Element = PointerIntoBag(Collection,i);
    Copy(Element,in[Val+i]);
  }

  RecErr(NewRecord)	= FALSE;
  RecCol(NewRecord)	= Collection;
  SetDes(NewRecord,	RecordType);

#undef Val
#undef OutR
}
/* ------------------------------------------------------------ */
void
RElements(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define R	(0)
#define Field	(0)

  unsigned	i,LastOut;
  IF1OBJECT	*TheRecord,*Element;
  BagPtr	Collection;

  TheRecord	= in[R];
  Collection	= RecCol(TheRecord);
  LastOut	= OUTARITY(info);

  if ( RecErr(TheRecord) || IsEmptyObject(TheRecord) ) {
    for(i=0;i<LastOut;i++) {
      if (out[Field+i]) MakeError(out[Field+i],OType(info)[Field+i]);
    }
  } else {
    for(i=0;i<LastOut;i++) {
      Element = PointerIntoBag(Collection,i);
      Copy(out[Field+i],Element);
    }
  }

#undef R
#undef Field
}
/* ------------------------------------------------------------ */
void
RReplace(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define R	(0)
#define Field	(1)
#define OutR	(0)

  TypeD		RecordType;
  unsigned	i,FieldCount,ChangeCount;
  TypeD		*FieldTypeVec;
  IF1OBJECT	*TheRecord,*OldElement,*NewElement,*NewField,*NewRecord;
  BagPtr	NewCollection,OldCollection;

  /* ------------------------------------------------------------ */
  RecordType	= IType(info)[R];
  FieldCount	= FieldCountOfRecord(RecordType);
  FieldTypeVec	= FieldTypesOfRecord(RecordType);
  TheRecord	= in[R];
  NewRecord	= out[OutR];
  ChangeCount	= INARITY(info)-1;


  NewCollection = EmptyBag(FieldCount);
  OldCollection	= RecCol(TheRecord);

  for(i=0;i<ChangeCount;i++) {
    NewElement = PointerIntoBag(NewCollection,i);
    NewField = in[Field+i];

    if (NewField) {
      Copy(NewElement,NewField);
    } else {
      if ( RecErr(TheRecord) ) {
	MakeError(NewElement,FieldTypeVec[i]);
      } else {
	OldElement = PointerIntoBag(OldCollection,i);
	Copy(NewElement,OldElement);
      }
    }
  }
  for(;i<FieldCount;i++) {
    if ( RecErr(TheRecord) ) {
      NewElement = PointerIntoBag(NewCollection,i);
      MakeError(NewElement,FieldTypeVec[i]);
    } else {
      OldElement = PointerIntoBag(OldCollection,i);
      NewElement = PointerIntoBag(NewCollection,i);
      Copy(NewElement,OldElement);
    }
  }

  RecErr(NewRecord) = FALSE;
  RecCol(NewRecord) = NewCollection;
  SetDes(NewRecord,	RecordType);


#undef R
#undef Field
#undef OutR
}
