#include "SC.h"
#include "SCLib.h"

/* ------------------------------------------------------------ */
void
GetSelector(Selector,GraphInfo,in,ITypes,InArity)
     IF1OBJECT	*Selector;
     NodeInfo	GraphInfo;
     IF1OBJECT	*in[];
     TypeD	*ITypes;
     unsigned	InArity;
{
  IF1OBJECT	*SelectOut[1];
  NodeStuff	SelectInfo;

  /* Only have the one output value */
  SelectOut[0]  = Selector;

  /* Build the information node for the call to the graph */
  BuildNodeInfo(&SelectInfo,
		InArity,1,
		ITypes,IType(GraphInfo));

  /* Execute the graph, leaving the selector value in Selector */
  ExecGraph(GraphCodeOf(GraphInfo),
	      GraphNameOf(GraphInfo),
	      in,SelectOut,&SelectInfo);
}

/* ------------------------------------------------------------ */
void
Select(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  SisalInteger	Selection;
  IF1OBJECT	Select;
  NodeInfo	GraphZero;
  NodeInfo	BranchGraph;

  /* ------------------------------------------------------------ */
  /* No need to save the environment because the selection is a scalar */
  /* ------------------------------------------------------------ */

  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */
  /* Execute Graph 0 to find out which subgraph to execute */
  GraphZero = ChildrenOf(info)[0];
  GetSelector(&Select,GraphZero,in,IType(info),INARITY(info));

  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */
  /* Now choose the appropriate graph.  If the selected graph is not */
  /* in the SELECT compound, then just set the values to error. */

  if ( BasErr(&Select) ||
       (Selection = IVal(&Select),
	ILess(Selection,IntegerZero) ||
	IGreat(Selection,LocalToInteger(ChildCountOf(info))))
  ) {
    SetToError(out,OType(info),OUTARITY(info));
  } else {
    BranchGraph = ChildrenOf(info)[IntegerToLocal(IAdd(IntegerOne,Selection))];

    ExecGraph(GraphCodeOf(BranchGraph),GraphNameOf(BranchGraph),in,out,info);
  }
}

/* ------------------------------------------------------------ */
void
If(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
#define FLAG	(0)

  NodeInfo	TheGraph,SelectorGraph;
  TypeD		*ITypes;
  unsigned	InArity;
  unsigned	ElseClause,Selector;
  IF1OBJECT	FlagVal;

  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */
  /* If the flag = error[boolean], set the outputs to error */
  if ( BasErr(in[FLAG]) ) {
    SetToError(out,OType(info),OUTARITY(info));

    /* ------------------------------------------------------------ */
    /* ------------------------------------------------------------ */
    /* If the flag = true, then execute the first graph */
  } else if ( BVal(in[FLAG]) == TRUE ) {
    /* TRUE Branch */
    TheGraph = ChildrenOf(info)[0];
    ExecGraph(GraphCodeOf(TheGraph),GraphNameOf(TheGraph),in,out,info);

    /* ------------------------------------------------------------ */
    /* ------------------------------------------------------------ */
    /* If there are exactly 2 graphs, then this is an if-the-else.  If */
    /* there are more, then its an if-then-elseif-.,,,-else which is */
    /* handled in the next part. */
  } else if (ChildCountOf(info) == 2) {
    /* FALSE Branch */
    TheGraph = ChildrenOf(info)[1];
    ExecGraph(GraphCodeOf(TheGraph),GraphNameOf(TheGraph),in,out,info);

  } else {
    /* ------------------------------------------------------------ */
    /* ------------------------------------------------------------ */
    /* While there are still target bodies, execute a selector body. */
    /* If the selector is true , the proper body is the next one.  If */
    /* the selector generates an error, generate all errors.  If the */
    /* selector is false, skip the following body to get to the next */
    /* selector.  If there are no more selectors, then simply execute */
    /* the last body (the else clause). */

    ElseClause	= ChildCountOf(info)-1;
    ITypes	= IType(info);
    InArity	= INARITY(info);

    for(Selector=1; Selector < ElseClause; Selector += 2) {
      SelectorGraph = ChildrenOf(info)[Selector];
      GetSelector(&FlagVal,SelectorGraph,in,ITypes,InArity);

      /* If the flag is in error or true, then we can stop looking */
      if ( BasErr(&FlagVal) ) {
	SetToError(out,OType(info),OUTARITY(info));
	goto ElseIfDone;

	/* If the flag is true, then execute the next body */
      } else if ( BVal(&FlagVal) == TRUE ) {
	TheGraph = ChildrenOf(info)[Selector+1];
	ExecGraph(GraphCodeOf(TheGraph),GraphNameOf(TheGraph),in,out,info);
	goto ElseIfDone;
      }
    }

    /* If we got here, no selector generated a true */
    TheGraph = ChildrenOf(info)[ElseClause];
    ExecGraph(GraphCodeOf(TheGraph),GraphNameOf(TheGraph),in,out,info);
   ElseIfDone:;
  }

#undef FLAG
}
