#include "SC.h"
#include "SCLib.h"
/* ------------------------------------------------------------ */
int
NumberOfTrueInMultiple(M)
     IF1OBJECT		*M;
{
  int	Count = 0;
  unsigned	i;
  IF1OBJECT	Flag;

  if ( !IsEmptyObject(M) ) {
    for(i=0;i<MultTrueSize(M);i++) {
      GetFromMult(M,i,&Flag);
      if (!BasErr(&Flag) && BVal(&Flag)) Count++;
    }
  }

  return Count;
}
/* ------------------------------------------------------------ */
BagPtr
ConditionalCollect(from,flags,Size,GoodCountPtr)
     IF1OBJECT		*from;
     IF1OBJECT		*flags;
     unsigned		Size;
     int		*GoodCountPtr;
{
  BagPtr	B = EmptyBag(Size);
  unsigned	i;
  IF1OBJECT	*Item = B->Items;
  IF1OBJECT	Flag;
  int		GoodCount;
  int		HaveError;
  int		TrueSize;

  TrueSize = IsEmptyObject(from)?(0):MultTrueSize(from);

  for(GoodCount=0,HaveError=0,i=0; i< TrueSize; i++) {
    GetFromMult(flags,i,&Flag);
    if (BasErr(&Flag)) {
      HaveError = 1;
    } else if (BVal(&Flag)) {
      GetFromMult(from,i,Item++);
      if ( !HaveError ) GoodCount++;
    }
  }

  *GoodCountPtr = GoodCount;
  return B;
}
/* ------------------------------------------------------------ */
void
AGather(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
#define	LB	(0)
#define	M	(1)
#define COND	(2)
#define A	(0)

  BagPtr	B;
  unsigned	i;
  unsigned	Size;
  IF1OBJECT	*Item;
  int		GoodCount;	/* Number of items that are good */
				/* before the first Error[boolean] in */
				/* the flags multiple. */

  if ( ARRAYLIKE(OType(info)[A]) ) {

    if ( IsEmptyObject(in[M]) ) {
      /* ------------------------------------------------------------ */
      /* ------------------------------------------------------------ */
      /* ------------------------------------------------------------ */
      /* Create an empty arraylike thing if there are no values */
      B = EmptyBag(0);

      CreateArray(out[A],
		  OType(info)[A],
		  TRUE,
		  BasErr(in[LB]),IVal(in[LB]),
		  0,
		  0,
		  B,
		  0);
    } else if (INARITY(info) > 2) {
      /* ------------------------------------------------------------ */
      /* ------------------------------------------------------------ */
      /* ------------------------------------------------------------ */
      /* Conditionally collect the elements that are set to true */
      /* Collect a bag full of the pertinent items */
      Size = NumberOfTrueInMultiple(in[COND]);
      B = ConditionalCollect(in[M],in[COND],Size,&GoodCount);

      /* Get the proper error flag for the new arraylike thing */
      CreateArray(out[A],
		  OType(info)[A],
		  (SisalBoolean)(!MultError(in[M])),
		  BasErr(in[LB]),IVal(in[LB]),
		  Size,
		  GoodCount,
		  B,
		  0);

      /* ------------------------------------------------------------ */
      /* ------------------------------------------------------------ */
      /* ------------------------------------------------------------ */
      /* Create an array (or strict stream) from a bag */
    } else if (MultTag(in[M]) == BagMult) {
      CreateArray(out[A],
		  OType(info)[A],
		  (SisalBoolean)(!MultError(in[M])),
		  BasErr(in[LB]),IVal(in[LB]),
		  MultTrueSize(in[M]),
		  MultSize(in[M]),
		  MultBag(in[M]),
		  MultView(in[M]));

    } else {
      /* ------------------------------------------------------------ */
      /* ------------------------------------------------------------ */
      /* ------------------------------------------------------------ */
      /* Create an array (or strict stream) from a Range Multiple */
      B = EmptyBag(MultTrueSize(in[M]));
      Item = B->Items;
      for(i=0;i<MultTrueSize(in[M]);i++) {
	GetFromMult(in[M],i,Item++);
      }
      CreateArray(out[A],
		  OType(info)[A],
		  (SisalBoolean)(!MultError(in[M])),
		  BasErr(in[LB]),IVal(in[LB]),
		  MultTrueSize(in[M]),
		  MultSize(in[M]),
		  B,
		  0);
    }

    if ( STREAMLIKE(OType(info)[A]) ) SetLB(out[A],FALSE,IntegerOne);
  } else {
    Oops("No AGather for non-strict streams yet");
  }

#undef	LB
#undef	M
#undef COND
#undef A

}
