#include "SC.h"
#include "SCLib.h"

#ifdef BSD
#define NEED_IO
#endif

#ifdef SYSV
#define NEED_IO
#endif

#ifdef NEED_IO
static FILE	*IN = NULL;

static FILE	*OUT = NULL;

/* ------------------------------------------------------------ */
void
OpenInputFile(argopt,filename)	/* ARGSUSED */
     char	*argopt;
     char	*filename;
{
  IN = fopen(filename,"r");
  if ( !IN ) {
    fprintf(stderr,"Cannot open %s for input\n",filename);
    perror("twine");
    exit(1);
  }
}
/* ------------------------------------------------------------ */
void
OpenOutputFile(argopt,filename)	/* ARGSUSED */
     char	*argopt;
     char	*filename;
{
  OUT = fopen(filename,"w");
  if ( !OUT ) {
    fprintf(stderr,"Cannot open %s for input\n",filename);
    perror("twine");
    exit(1);
  }
}

/* ------------------------------------------------------------ */
void
OpenInput()
{
}

/* ------------------------------------------------------------ */
int
FileReadChar()
{
  return (IN)?getc(IN):getchar();
}

/* ------------------------------------------------------------ */
void
IO_ErrorString(s)
     char	*s;
{
  fputs(s,stderr);
}

void
IO_OutputString(s)
     char	*s;
{
  FILE	*fp = (OUT)?(OUT):(stdout);

  (void)fputs(s,fp);
  putc((PackFibre)?' ':'\n',fp);
  (void)fflush(fp);
}


void
IO_OutputChar(c)
     char	c;
{
  (void)fputc(c,(OUT)?(OUT):(stdout));
}

void
IO_OutputComment(s)
     char	*s;
{
  if (PrintComments) {
    FILE	*fp = (OUT)?(OUT):(stdout);

    (void)fprintf(fp,"# %s\n",s);
    (void)fflush(fp);
  }
}

void
IO_BlankLine()
{
  if (PrintComments) {
    (void)putc('\n',(OUT)?(OUT):(stdout));
  }
}

void
IO_StartComment(s)
     char	*s;
{
  if (PrintComments) {
    (void)fprintf((OUT)?(OUT):(stdout),"# %s",s);
  }
}

void
IO_AddComment(s)
     char	*s;
{
  if (PrintComments) {
    (void)fputs(s,(OUT)?(OUT):(stdout));
  }
}

void
IO_ReleaseComment()
{
  if (PrintComments) {
    (void)putc('\n',(OUT)?(OUT):(stdout));
  }
}
#endif
