#include "SC.h"
#include "SCLib.h"

 static Environment	*StackHead = NULL;
 static Environment	*StackFreeList = NULL;

/* ------------------------------------------------------------ */
Environment*
TopOfEnvironmentStack()
{
  return StackHead;
}

Environment*
PrevEnvironment(Env)
     Environment	*Env;
{
  if (Env) {
    return Env->Next;
  } else {
    return (Environment*)NULL;
  }
}

Environment*
GetFunctionNode(Env)
     Environment	*Env;
{
  Environment	*E;

  for(E=Env;E;E = E->Next) {
    if ( IsGraph(E->INFO) && IsFunctionName(E->NAME) ) break;
  }

  return E;
}
/* ------------------------------------------------------------ */
void
PushEnv(Name,info,in,out,vars,varcount,shadow)
     char	*Name;
     NodeInfo	info;
     IF1OBJECT	*in[],*out[],vars[];
     unsigned	varcount;
     int	shadow;
{
  Environment	*New;

  if (StackFreeList) {
    New = StackFreeList;
    StackFreeList = New->Next;
  } else {
    New = Allocate(Environment);
  }

  New->Next = StackHead;
  StackHead = New;

  New->NAME	= Name;
  New->INFO	= info;
  New->IN	= in;
  New->OUT	= out;
  New->VARS	= vars;
  New->VARCOUNT	= varcount;
  New->Shadow	= shadow;
}

void
PopEnv()
{
  Environment	*top;

  top = StackHead;
  StackHead = StackHead->Next;

  top->Next = StackFreeList;
  StackFreeList = top;
}

Environment*
ReverseStack(P)
     Environment*	P;
{
  Environment	*Current,*Next,*Previous;

  for(Previous=NULL,Current=P;Current;) {
    Next		= Current->Next;
    Current->Next	= Previous;
    Previous		= Current;
    Current		= Next;
  }

  return Previous;
}

void
Where()
{
  Environment	*R,*Top;

  if (StackHead) {
    StartComment("");

    R = ReverseStack(StackHead);

    for(Top=R; Top; Top = Top->Next) {
      AddComment(Top->NAME);
      if (Top->Next) AddComment("`");
    }
    ReleaseComment();

    StackHead = ReverseStack(R);
  } else {
    OutputComment("NoWhere");
  }
}

void
What()
{
  NodeInfo	info;
  unsigned	i;

  Where();

  if (StackHead) {
    OutputComment("vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv");
    info = StackHead->INFO;

    /* ------------------------------------------------------------ */
    /* LIST INPUT VALUES */
    OutputComment("INPUTS");
    StartComment("");
    for(i=0;i<OUTARITY(info);i++) {
      AddComment(TypeNameOf(OType(info)[i]));
      AddComment(" ");
    }
    ReleaseComment();

    for(i=0;i<OUTARITY(info);i++) {
      FibrePrint(StackHead->IN[i]);
    }
    BlankLine();
    BlankLine();

    /* ------------------------------------------------------------ */
    /* LIST OUTPUT VALUES */
    OutputComment("OUTPUTS");
    StartComment("");
    for(i=0;i<INARITY(info);i++) {
      AddComment(TypeNameOf(IType(info)[i]));
      AddComment(" ");
    }
    ReleaseComment();

    for(i=0;i<INARITY(info);i++) {
      FibrePrint(StackHead->OUT[i]);
    }
    BlankLine();
    BlankLine();

    /* ------------------------------------------------------------ */
    /* LIST VARIABLE VALUES */
    OutputComment("VARS");
    for(i=0;i<StackHead->VARCOUNT;i++) {
      FibrePrint(StackHead->VARS+i);
    }
    BlankLine();

    OutputComment("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
    
  }
}

void
PrintVars()
{
  int	i;

  if (StackHead) {
    for(i=0;i<StackHead->VARCOUNT;i++) {
      FibrePrint(StackHead->VARS+i);
    }
    BlankLine();
  }
}
