#include "SC.h"
#include "SCLib.h"

/* ------------------------------------------------------------ */
/* Keep track of function call depth to detect infinite recursion */
static int CallDepth = 0;

void
Call(in,out,info)
     IF1OBJECT	*in[],*out[];
     NodeInfo	info;
     
{
#define FunEdge	(0)
#define InArgs	(1)
#define OutArgs	(0)

  NodeStuff	CallInfo;

  /* ------------------------------------------------------------ */
  /* In order to check for infinite depth recursion, keep track of the */
  /* depth of function calls.  If it gets too deep, then report an */
  /* infinite loop error. */
  if ( InfiniteLoopCount && ++CallDepth > InfiniteLoopCount ) {
#if Debugger
    InfiniteLoopFlag = TRUE;
#else
    Oops("In an infinite loop");
#endif
  }

  /* ------------------------------------------------------------ */
  /* Build an info vector without the function info. */
  HOOK(FunctionHook(in,out,info));
  BuildNodeInfo(&CallInfo,
		INARITY(info)-1, OUTARITY(info),
		IType(info)+InArgs, OType(info));
  ExecGraph(FunCode(in[FunEdge]),FunName(in[FunEdge]),in+InArgs,out,&CallInfo);

  /* ------------------------------------------------------------ */
  /* Done with the call, the depth decreases */
  CallDepth--;

#undef FunEdge
#undef InArgs
#undef OutArgs
}
