/* ------------------------------------------------------------ */
/* FibreRead.c */
extern void FlushFibre();
extern void OpenStringInput();
extern void CloseStringInput();
extern int isodigit();
extern void ReadUnion();
extern void FibreRead();
extern void SkipFibre();

/* ------------------------------------------------------------ */
/* FibrePrint.c */
extern void OpenStringOutput();
extern void CloseStringOutput();
extern void FibrePrint();
extern char* TypeNameOf();
extern void PrintList();
extern void PrintListWithNames();
extern void PrintBlock();
extern void RC();
extern void RCL();
extern void FibrePrintString();

/* ------------------------------------------------------------ */
/* io.c */
extern void OpenInputFile();
extern void OpenOutputFile();
extern void IO_ErrorString();
extern void IO_OutputString();
extern void IO_OutputChar();
extern void IO_OutputComment();
extern void IO_BlankLine();
extern void IO_StartComment();
extern void IO_AddComment();
extern void IO_ReleaseComment();

/* ------------------------------------------------------------ */
/* globals.c */
extern BasicTypeStructure BooleanStructure;
extern BasicTypeStructure CharacterStructure;
extern BasicTypeStructure DoubleStructure;
extern BasicTypeStructure IntegerStructure;
extern BasicTypeStructure NullStructure;
extern BasicTypeStructure RealStructure;
extern ArrayTypeStructure StringStructure;
extern EmptyTypeStructure EmptyStructure;
extern SisalEmptyObject EmptyObjectShell;
extern SisalBoolean PrintStrings;
extern SisalBoolean PrintComments;
extern SisalBoolean UseStdio;
extern SisalBoolean AlwaysShadow;
extern SisalBoolean ShadowTrace;
extern SisalBoolean ShadowCheckGraphInput;
extern SisalBoolean ShadowCheckFunctionInput;
extern SisalBoolean ShadowCheckGraphOutput;
extern SisalBoolean ShadowCheckFunctionOutput;
extern SisalBoolean PrintSize;
extern SisalBoolean PackFibre;
extern BagPtr	    BagList;
extern int	    PeriodicGarbage;
extern int	    InfiniteLoopCount;
extern SisalBoolean InfiniteLoopFlag;
extern char	    *InputFileName;
extern char	    *OutputFileName;

/* ------------------------------------------------------------ */
/* bag.c */
extern BagPtr EmptyBag();
extern IF1OBJECT* GetPointerIntoBag();
extern IF1OBJECT* PointerIntoBag();
extern void DumpBag();
extern void DestroyBag();
extern BagPtr FillBag();
extern void FillFromBag();
extern BagPtr CopyOfBag();
extern void CleanBag();
extern void AppendBags();

/* ------------------------------------------------------------ */
/* alloc.c */
extern char* SafeAllocate();
extern char* SafeCAllocate();
extern void SafeFree();

/* ------------------------------------------------------------ */
/* garbage.c */
extern void GarbageCollect();
extern void AddToGarbage();

/* ------------------------------------------------------------ */
/* copy.c */
extern void MakeError();
extern void SetToError();
extern void CopyVector();
extern void FlagAsError();
extern void EmptyVector();
extern void MergeVector();
extern int AnyErrorValues();
extern int IsAnErrorValue();
extern int AnyErroneousValues();
extern int AnyErroneousValuesInBag();
extern int IsAnErroneousValue();
extern void ArrayCopy();

/* ------------------------------------------------------------ */
/* ref.c */

/* ------------------------------------------------------------ */
/* destroy.c */
extern void ReallyDestroy();
extern void Destroy();

/* ------------------------------------------------------------ */
/* hooks.c */
extern void SanityHook();
extern void PreStartHook();
extern void PreNodeHook();
extern void PostNodeHook();
extern void DestroyHook();
extern void EndGraphHook();
extern void GraphHook();
extern void StartHook();
extern void ErrorHook();
extern void CopyHook();
extern void ForallHook();
extern void FunctionHook();
extern void BagCreateHook();
extern void BagDestroyHook();
extern void CompleteHook();
extern void InfiniteLoopHook();

/* ------------------------------------------------------------ */
/* files.c */
extern void OpenInput();
extern int FileReadChar();

/* ------------------------------------------------------------ */
/* error.c */
extern void FibreError();

/* ------------------------------------------------------------ */
/* mult.c */
extern void GetFromMult();
extern IF1OBJECT* MakeMultipleFromBag();
extern void MakeEmptyMultiple();
extern void AppendToMultiple();
extern unsigned JustifyMultiples();
extern void GetMultiples();
extern void UnPackMultiples();
extern void CollectResultsIntoMultiple();

/* ------------------------------------------------------------ */
/* main.c */
extern char *EntryName;
extern char *EntryString;
extern int PrintMax;
extern Parameter ParmList[MaxParms];
extern void SetupStringInput();
extern void SetupStdio();
extern void main();

/* ------------------------------------------------------------ */
/* options.c */
extern SisalBoolean ParmFalse;
extern SisalBoolean ParmTrue;
extern int ParmZero;
extern char *ParmEmptyString;
extern void InsertParmList();
extern void ProcessOptions();

/* ------------------------------------------------------------ */
/* table.c */
extern int OpListSize;
extern OpName OpList[];

/* ------------------------------------------------------------ */
/* nop.c */
extern void NoOp();

/* ------------------------------------------------------------ */
/* init.c */
extern NodeInfo CurrentTable;
extern void InitializeTables();
extern void Init();
extern void NameExecuteNode();

/* ------------------------------------------------------------ */
/* exec.c */
extern void ExecGraph();
extern void ExecuteNode();
extern void FixupName();
extern void UnFixupName();
extern NodeInfo FindGraph();
extern NodeInfo FindNode();
extern void GraphEntry();

/* ------------------------------------------------------------ */
/* graph.c */
extern void InitializeLocals();
extern void ImportStuff();
extern void ExportStuff();

/* ------------------------------------------------------------ */
/* environment.c */
extern int CurrentShadow();
extern void SetShadow();
extern void ClearShadow();
extern Environment* TopOfEnvironmentStack();
extern Environment* PrevEnvironment();
extern Environment* GetFunctionNode();
extern void PushEnv();
extern void PopEnv();
extern Environment* ReverseStack();
extern void Where();
extern void What();
extern void PrintVars();

/* ------------------------------------------------------------ */
/* ops.c */
extern void Plus();
extern void Times();
extern void Min();
extern void Max();
extern void Minus();
extern void Div();
extern void Mod();
extern void Exp();
extern void Abs();
extern void Neg();
extern void Not();
extern void Less();
extern void LessEqual();
extern void Equal();
extern void NotEqual();
extern void IsError();
extern void Bool();
extern void Char();
extern void Double();
extern void Int();
extern void Floor();
extern void Trunc();
extern void Single();

/* ------------------------------------------------------------ */
/* if.c */
extern void GetSelector();
extern void Select();
extern void If();

/* ------------------------------------------------------------ */
/* call.c */
extern void Call();

/* ------------------------------------------------------------ */
/* array.c */
extern void ABuild();
extern void AFill();
extern void AElement();
extern void ALimL();
extern void ALimH();
extern void ASize();
extern void APrefixSize();
extern void AIsEmpty();
extern void AAddL();
extern void AAddH();
extern void ARemL();
extern void ARemH();
extern void ASetL();
extern void AExtract();
extern void ACatenate();
extern void AReplace();
extern void AReplaceN();

/* ------------------------------------------------------------ */
/* record.c */
extern void RBuild();
extern void RElements();
extern void RReplace();

/* ------------------------------------------------------------ */
/* work.c */

/* ------------------------------------------------------------ */
/* union.c */
extern void UBuild();
extern void TagCase();

/* ------------------------------------------------------------ */
/* iter.c */
extern void Iter();

/* ------------------------------------------------------------ */
/* forall.c */
extern void Forall();

/* ------------------------------------------------------------ */
/* loopaorb.c */
extern void LoopA();
extern void LoopB();

/* ------------------------------------------------------------ */
/* generate.c */
extern void RangeGenerate();
extern void AScatter();

/* ------------------------------------------------------------ */
/* gather.c */
extern int NumberOfTrueInMultiple();
extern BagPtr ConditionalCollect();
extern void AGather();

/* ------------------------------------------------------------ */
/* value.c */
extern void FirstValue();
extern void FinalValue();
extern void AllButLastValue();

/* ------------------------------------------------------------ */
/* reduce.c */
extern void ApplyReduction();
extern void SUM_();
extern void PRODUCT_();
extern void LEAST_();
extern void GREATEST_();
extern void CATENATE_();
extern void Reduce();
extern void ReduceLeft();
extern void ReduceRight();
extern void ReduceTree();
extern void AnyReduce();

/* ------------------------------------------------------------ */
/* literal.c */
extern int ParseCharToken();
extern void InitString();
extern void InitBasicLiteral();
extern void InitFunctionLiteral();
extern void InitializeLiteral();
extern void InitializeLiteralPools();

/* ------------------------------------------------------------ */
/* machineC.c */

/* ------------------------------------------------------------ */
/* util.c */
extern int StringEq();

/* ------------------------------------------------------------ */
/* signal.c */
extern int BlockSignals();
extern void AllowSignals();
extern int BlockSignals();
extern void				/* ARGSUSED */ AllowSignals();

/* ------------------------------------------------------------ */
/* system.c */

/* ------------------------------------------------------------ */
/* notdone.c */
extern void NotDone();

