#include "SC.h"
#include "SCLib.h"
#include "Debug.h"

IF1OBJECT*
LookupName(F,name)
     NodeInfo	F;
     char	*name;
{
  Environment	*Env;
  IF1OBJECT	*val = NULL;
  int		i;
  char		*checkname;

  /* Find the first environment that belongs in function F */
  for(Env = TopOfEnvironmentStack();Env;Env = Env->Next) {
    if ( F == FunctionOfNode(Env->INFO) ) break;
  }

  /*  Now check each environment looking for the value name*/
  for(;Env;Env = Env->Next) {

    if ( InfoKind(Env->INFO) == Constructed ) continue;	/* No names info */

    /* If the function is no longer F, then quit */
    if ( F != FunctionOfNode(Env->INFO) ) break;

    /* Check outputs */
    for(i=0;i<OUTARITY(Env->INFO);i++) {
      if ( OutputEdgeNames(Env->INFO)[i] ) {
	checkname = OutputEdgeNames(Env->INFO)[i];
	if ( strcmp(name,checkname) == 0 ) {
	  val = IsGraph(Env->INFO)?(Env->IN[i]):(Env->OUT[i]);
	  goto AllDone;
	}
      }
    }

    /* Check inputs */
    for(i=0;i<INARITY(Env->INFO);i++) {
      if ( InputEdgeNames(Env->INFO)[i] ) {
	checkname = InputEdgeNames(Env->INFO)[i];
	if ( strcmp(name,checkname) == 0 ) {
	  val = IsGraph(Env->INFO)?(Env->OUT[i]):(Env->IN[i]);
	  goto AllDone;
	}
      }
    }

    /* Check locals */
    if ( IsGraph(Env->INFO) && LocalNameOf(Env->INFO) ) {
      for(i=0;i<LocalCountOf(Env->INFO);i++) {
	checkname = LocalNameOf(Env->INFO)[i];
	if ( strcmp(name,checkname) == 0 ) {
	  val = Env->VARS+i;
	  goto AllDone;
	}
      }  
    }
  }
  
 AllDone:
  return val;
}

void
PrintName(name,File,AltName)
     char	*name;
     FileEntry	*File;
     char	*AltName;
{
  char		message[MaxCommentSize+100];
  char		valuestring[MaxCommentSize];
  char		FName[MaxCommentSize];
  IF1OBJECT	*val;
  char		*ColonPos;
  NodeInfo	F;
  char		*header;
  char		varname[MaxCommentSize];
  int		headerlen,valuelen;

  /* If the File isn't specified, just use the default */
  if ( !File ) File = &FileDefault;

  /* Make name upper case for comparison */
  MakeUpper(name);

  /* Break the name into function:name (or use default function) */
  ColonPos = rindex(name,':');
  if ( ColonPos ) {
    *ColonPos	= '\0';
    F		= FindGraph(name,NULL,FALSE);
    name	= ColonPos+1;
  } else {
    F		= TopLevelFunction();
  }


  /* Make sure we found the function, a non-null name, and that the */
  /* name is actually known by the function */
  if ( F && *name && IsGlobalName(name,F) ) {

    UnFixupName(GraphNameOf(F),FName); /* The name of the function */
    val = LookupName(F,name);

    /* Create a header and valuestring representing the value */
    if ( File->binary ) {
      header = "";
      valuestring[0] = '\0';
      valuelen = 0;
      headerlen = 0;
      DebugMessage("Cannot print binary yet\n");
    } else {
      header = (AltName)?(AltName):(sprintf(varname,"%s:%s\t= ",FName,name),
				    varname);
      headerlen = strlen(header)+1;
      
      /* If the value is ``empty'', then its not active */
      if ( !val || IsEmptyObject(val) ) {
	(void)strcpy(valuestring,"Not Active");
      } else {
	/* Just Fibre print the value into the string */
	OpenStringOutput(valuestring,sizeof(valuestring));
	FibrePrint(val);
	CloseStringOutput();
      }
      valuelen = strlen(valuestring)+1;	/* include the null */
    }

    /* ------------------------------------------------------------ */
    /* Build a buffer representing the message */
    message[0] = '\0';
    /* Add the init string if there is one */
    if ( File->Setupstring ) {
      (void)strcpy(message,File->Setupstring);
      File->Setupstring = NULL; /* Its just a one shot deal */
    }
    /* Add the header */
    if ( File->header ) {
      (void)strcpy(message,header);
    }
    /* Add the value */
    (void) strcat(message,valuestring);

    /* Write the value to the file or whatever */
    if ( File->FP ) {
      /* Append a newline if not in binary mode */
      if ( !File->binary ) message[headerlen+valuelen-1] = '\n';
      (void)write(fileno(File->FP),message,headerlen+valuelen);
      (void)fflush(File->FP);		/* Make sure it is written */
    } else {
      (void)strcat(message,"\n");
      DebugMessage(message);
    }
  } else {
    (void)sprintf(message,"No such variable %s\n",name);
    DebugMessage(message);
  }
}
