#include "SC.h"
#include "SCLib.h"
#include "Debug.h"

void
ListCode(args)
     char	*args;
{
  char		*parse[2];
  NodeInfo	N;
  int		Depth;		/* Depth of listing to do.  If none is */
				/* given by the user, then it will be */
				/* set to -1 which indiciates never stop */

  /* ------------------------------------------------------------ */
  /* Split off the code to list */
  ParseList(args,parse,1);
  Depth = (*parse[1])?(atoi(parse[1])+1):-1;

  switch( *parse[0] ) {
   case '0': case '1': case '2': case '3': case '4':
   case '5': case '6': case '7': case '8': case '9': case '\0':
    N = FindNode(Linkage[CurrentModule],(*parse[0]) ? atoi(parse[0]):
                 GetCurrentLine(),1);
    /* Make sure that N is a graph or compound */
    if ( IsSimple(N) ) N = ParentOf(N);
    break;

   default:			/* It must be a graph */
    N = FindGraph(parse[0],NULL,FALSE);
  }

  /* ------------------------------------------------------------ */
  /* DisAssemble the node ( if any was found) */
  if ( N ) {
    DisAssemble(N,0,Depth);
  } else {
    DebugMessage("Cannot find any code to list\n");
  }
}

DisAssemble(N,indent,Depth)
     NodeInfo	N;
     int	indent;
{
  NodeInfo	Module;
  int		i;
  static char	Blanks[] = "              ";
  int		MaxIndent = sizeof(Blanks)/2;
  char		*Indentation;

  /* Stop if we've reached the end depth.  Decrement if possible */
  if ( !Depth ) return;
  if ( Depth > 0 ) Depth--;

  /* Set the indentation level */
  if ( indent > MaxIndent ) indent = MaxIndent;
  Indentation = Blanks+2*(MaxIndent-indent);

  /* Display the graph appropriately */
  switch ( InfoKind(N) ) {
   case Simple:
    DisplayNode(Indentation,N);
    break;

   case Compound:
    DisplayNode(Indentation,N);
    for(i=0;i<ChildCountOf(N);i++) {
      DisAssemble(ChildrenOf(N)[i],indent+1,Depth);
    }
    break;

   case Graph:
    DisplayNode(Indentation,N);
    Module = ModuleOfNode(N);
    for(i=1;i<=ModuleSizeOf(Module);i++) {
      if ( ParentOf(Module+i) == N && Module+i != N ) {
	DisAssemble(Module+i,indent+1,Depth);
      }
    }
    break;

   default: ;
  }
}
  
