/* ------------------------------------------------------------ */
/* Parameters */

#define HASHTABLESIZE	(31)
#define MaxBreakPoints	(100)
#define MaxBreakAtPoint	(100)
#define MaxNamesToList	(50)
#define BreakDescSize	(32)
#define UsageDepth	(10)
#define MaxFiles	(10)

#define ModuleOfNode(N)	((N)-((N)->NodeID))

#define NewString(s)	strcpy(CAllocate(strlen(s)+1,char),s)

/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* A structure for file information */
typedef struct {
  char		*name;
  int		binary;
  int		header;
  char		*Setupstring;
  FILE		*FP;
} FileEntry;
/* A structure to hold view information */
typedef struct {
  int		ID;
  char		*Name;
  FileEntry	*File;
  int		Break;
  char		*Comment;
} ViewVar;

/* ------------------------------------------------------------ */
/* Variables */
extern FileEntry	FileDefault;
extern SisalBoolean	StartInDebug;
extern SisalBoolean	DisplayByName;
extern SisalBoolean	NodeStep;
extern SisalBoolean	LineStep;
extern int		BreakOnError; /* Global ID for Error breakpoint */
extern char		*UsagePath[];
extern ViewVar		ViewList[];
extern int		ViewCount;

extern int		CurrentLine;
extern int		LastLine;
extern int		CurrentModule;
extern int		LastModule;

extern int		DebugLevel;
extern PackageHookType	CurrentHook;
extern int		Reasons[];
extern int		ReasonCount;
/* ------------------------------------------------------------ */
typedef  enum { EmptyBreak,LineBreak,GraphBreak,
		  ErrorBreak,OperationBreak,EndBreak,NameBreak
		  } BreakPointType;

typedef struct {
  BreakPointType	Type;
  int			IsTrace;
  int			Number;
  char                  Desc[BreakDescSize];
} BreakPointEntry;

extern BreakPointEntry BreakPointTable[];

typedef struct {
  FILE	       *Buf_FP;
  char	       Buf_Buffer[MaxCommentSize];
  int	       Buf_idx;
} DebugInputBuffer;

extern	DebugInputBuffer	DebugBuffer;

#define GlobalListGuessSize	(10) /* Must be greater than 2 */
#define RunInputGuessSize	(1024) /* Input string size */

typedef enum { SysInteger,SysBool } SysVarType;

typedef struct {
  char		*Name;
  char		*Value;
  SysVarType	Type;
} SysVar;
extern SysVar	SystemVariables[];

/* ------------------------------------------------------------ */
extern FileEntry	*FindFile();
/* Imported Functions  */
extern char		*rindex();

/* ???.c */
extern NodeInfo		TopLevelFunction();
extern NodeInfo		FunctionOwner();
extern NodeInfo		FunctionOfNode();

extern void		FindLocalNames();
extern void		InitBreakPointTable();
extern void		DebugDisplay();
extern void		DebugCommand();
extern void		DebugMessage();
extern void		DebugExit();
extern void		RemoveBreakPoint();
extern void		DebugEmitPrompt();
extern void		PrintName();
extern void		IncludeFile();
extern void		SetVar();
extern char		KeywordTablePosition();

/* ------------------------------------------------------------ */
/* alias.c */
extern void AliasInit();
extern int AddAlias();
extern char *MatchAlias();
extern void DeleteAlias();
extern void ListAliases();

/* break.c */
extern int SomeReasonIsABreakPoint();
extern int BreakpointApplies();
extern int AddAndHashBreakpoint();
extern void SplitModuleLine();
extern int IsALineNumber();
extern NodeInfo FindFirstNodeAtLine();
extern void InitBreakPointTable();
extern int LowestBreakPoint();
extern int HighestBreakPoint();
extern void DisplayBreakPoint();
extern int FirstFreeBreakPoint();
extern int AddBreakPoint();
extern int LocateBreakpoint();
extern void RemoveBreakPoint();
extern int NodalBreakPointSetHere();
extern int NodelessBreakPointSetHere();
extern int PostNodelessBreakPointSetHere();
extern int PostNodalBreakPointSetHere();
extern int GetModuleOffset();
extern int BreakLine();
extern int BreakFunction();
extern int BreakError();
extern int BreakOperation();
extern int BreakGraphEnd();
extern void DeleteBreak();

/* breakname.c */
extern NodeInfo FindFunctionInModule();
extern void SplitModuleFunctionName();
extern NodeInfo FunctionOf();
extern int InNameList();
extern int BreakName();

/* code.c */
extern void ListCode();

/* dcommand.c */
extern int NameEq();
extern int CommandTablePosition();
extern char KeywordTablePosition();
extern void DebugExecute();
extern void DebugFillBuffer();
extern void DebugCommand();

/* debugger.c */
extern void DebugMessage();
extern void DebugExit();
extern int GetCurrentLine();
extern int GetCurrentModule();
extern int Handler();
extern void DebugEmitPrompt();
extern void EnableDebug();
extern void EnterDebugMode();
extern void DebugPreTestForBreak();
extern void DebugPostTestForBreak();
extern void DebugPostGraphTestForBreak();
extern void PACKAGE_HOOK();

/* file.c */
extern FileEntry* FindFile();
extern void EnterFile();
extern void ListFiles();

/* hash.c */
extern int HashOf();
extern void InitHash();
extern void AddHash();
extern void DeleteID();
extern int NodalBreakPointList();

/* include.c */
extern void IncludeFile();

/* list.c */
extern void ListFunctions();
extern void ListModules();
extern void ListBreakPoints();
extern int starstrcmp();
extern int GetListOfFunctionNames();
extern void ListNames();
extern void ListSystemVars();
extern void ListOpsAt();

/* local.c */
extern int SameName();
extern int IsGlobalName();
extern int IsLocalName();
extern void InitializeGraphLocals();
extern void InitializeGraphGlobals();
extern NodeInfo FunctionOfNode();
extern void AppendGlobalName();
extern void AppendNames();
extern void AddLocals();
extern void FindLocalsInModule();
extern void FindLocalNames();

/* print.c */
extern IF1OBJECT* LookupName();
extern void PrintName();

/* printer.c */
extern void main();

/* set.c */
extern SysVar* FindVar();
extern void SetVar();

/* shownode.c */
extern NodeInfo FunctionOwner();
extern void CollectFibre();
extern void CollectNames();
extern void DebugDisplay();
extern void DisplayNode();

/* usage.c */

/* util.c */
extern void MakeUpper();
extern int FindModule();
extern Environment* TopLevelGraphEnv();
extern NodeInfo TopLevelFunction();
extern char* ReadFileIntoAString();
extern void ParseList();
extern void GrabLine();

/* view.c */
extern void ViewVars();
extern void DisplayViewVars();
extern void ListViews();
extern void DeleteView();
