#include "SC.h"
#include "SCLib.h"
#include <math.h>

/* CONVERSION OPS --------------------------------------------- */
/* use index to find chars */ extern char	*index();


void
StringToCharacter(s,val)
     char		*s;
     SisalCharacter	*val;
{
  unsigned	osum,i;

  if ( StringEq(s,"Min") ) {
    *val = CharacterMinVal;
  } else if ( StringEq(s,"Max") ) {
    *val = CharacterMaxVal;
  } else if ( s[0] == '\\' ) {
    /* Escape */
    if ( isodigit(s[1]) ) {
      /* Octal escape */
      osum = 0;
      for(i=1;s[i];i++) {
	osum = 8*osum + DigitValueOf(s[i]);
      }
      *val = (SisalCharacter)(osum);
    } else {
      /* Character escape */
      switch( s[1] ) {
       case 'b':
	*val = '\010';
	break;
       case 'f':
	*val = '\014';
	break;
       case 'n':
	*val = '\012';
	break;
       case 'r':
	*val = '\015';
	break;
       case 't':
	*val = '\011';
	break;
       default:
	*val = s[1];
      }
    }
  } else {
    *val = s[0];
  }
}
