#include "world.h"


FILE *input  = stdin;                  /* IF2 INPUT  FILE POINTER         */
FILE *output = stdout;                 /* IF2 OUTPUT FILE POINTER         */

char *program    = "if2up";            /* PROGRAM NAME                    */

int   sgnok      = TRUE;     /* ARE SIGNED ARITHMETIC CONSTANTS ALLOWED?  */
int   info       = FALSE;    /* GENARATE INFORMATION ABOUT OPTIMIZATIONS? */
int   minopt     = FALSE;    /* ONLY PERFORM MINIMAL OPTIMIZATIONS?       */
int   cagg       = TRUE;     /* MARK CONSTANT AGGREGATES?                 */
int   ststr      = TRUE;     /* IDENTIFY SINGLE THREADED STREAMS?         */
int   mig        = TRUE;     /* MIGRATE NODES TOWARD USES?                */
int   prof       = FALSE;    /* PROFILE THE OPTIMIZER?                    */
int   seqimp     = FALSE;
int   sdbx       = FALSE;    /* COMPILE FOR SDBX                          */

static char  ustmp[100];     /* CSU-UPDATE INPLACE STAMP COMMENTARY       */
static char *ofile = NULL;   /* OUTPUT FILE NAME                          */

/**************************************************************************/
/* LOCAL  **************      ParseCommandLine     ************************/
/**************************************************************************/
/* PURPOSE: PARSE THE COMMAND LINE argv CONTAINING argc ENTRIES. THE 1ST  */
/*          ENTRY (argv[0]) IS IGNORED.   IF AN ARGUMENT DOES NOT BEGIN   */
/*          WITH A DASH, IT IS CONSIDERED THE NAME OF A FILE.  THE FIRST  */
/*          ENCOUNTERED FILE IS FOR IF2 INPUT.  THE SECOND ENCOUNTERED    */
/*          FILE IS FOR IF2 OUTPUT.  ANY OTHER FILES ON THE COMMAND LINE  */
/*          CAUSE AN ERROR MESSAGE TO BE PRINTED.                         */
/*                                                                        */
/*          OPTIONS: -s     -> SIGNED CONSTANTS AREN'T ALLOWED            */
/*                   -i     -> PRINT OPTIMIZATION INFORMATION TO stderr.  */
/*                   -m     -> PERFORM MINIMAL OPTIMIZATIONS              */
/*                   -c     -> DON'T MARK CONSTANT AGGREGATES             */
/*                   -t     -> DON'T IDENTIFY SINGLE THREADED STREAMS     */
/*                   -l     -> DON'T MIGRATE NODES TOWARD USES            */
/*                   -I     -> ENABLE SEQUENT CODE IMPROVEMENT MIGRATION  */
/**************************************************************************/

static void ParseCommandLine( argc, argv )
int    argc;
char **argv;
{
    register char *c;
    register int   fmode = 0;
    register int   idx;
    register FILE *fd;

    for ( idx = 1; idx < argc; ++idx ) {
        if ( *(c = argv[ idx ]) != '-' ) {
            switch ( fmode ) {
                case 0: 
                    if ( (fd = fopen( c, "r" )) == NULL )
			Error2( "CAN'T OPEN", c );

		    input = fd;

		    AssignSourceFileName( c );

                    fmode++;
                    break;

                case 1:
		    ofile = c;

		    fmode++;
                    break;

                default:
                    Error2( "ILLEGAL ARGUMENT", c );
                }

            continue;
            }

        switch ( *( ++c ) ) {
	    case '^':
		sdbx = TRUE;
		break;

            case '\0':
		fmode++;
                break;

	    case 'W':
		prof = TRUE;
		break;

	    case 't':
		ststr = FALSE;
		break;

	    case 'l':
		mig = FALSE;
		break;

	    case 'c':
		cagg = FALSE;
		break;

	    case 'm':
		minopt = TRUE;
		cagg   = FALSE;
		break;

            case 's':
                sgnok = FALSE;
                break;

	    case 'I':
	        seqimp = TRUE;
	        break;

	    case 'i':
		info = TRUE;
		break;

            default:
                Error2( "ILLEGAL ARGUMENT", --c );
            }
        }
}


/**************************************************************************/
/* GLOBAL **************           Stop            ************************/
/**************************************************************************/
/* PURPOSE: CLOSE ALL OPEN FILES AND STOP PROGRAM EXECUTION.  THE STATUS  */
/*          (status) IS RETURNED TO THE INVOKER OF THE PROGRAM.           */
/**************************************************************************/

void Stop( status )
int status;
{
    exit( status );
}


/**************************************************************************/
/* GLOBAL **************            main           ************************/
/**************************************************************************/
/* PURPOSE: PERFORM UPDATE-IN-PLACE ANALYSIS.  THE INPUT FILE MUST BE     */
/*          DATA FLOW ORDERED, NORMALIZED, MONOLITHIC, AND NOT HAVE       */
/*          OFFSETS ASSIGNED (BY THE LLNL UTILITY if1offset). FURTHER,    */
/*          MINIMAL BUILD-IN-PLACE ANALYSIS MUST HAVE ALREADY BEEN DONE.  */
/*          THE 'U' STAMP IS APPENDED TO THE RESULTING OUTPUT.            */
/**************************************************************************/

void main( argc, argv )
int    argc;
char **argv;
{
    register FILE *fd;

    ParseCommandLine( argc, argv );

    StartProfiler();
    If2Read();
    StopProfiler( "If2Read" );

    fclose( input );                      /* AS IT MAY BE THE OUTPUT FILE */

    if ( !IsStamp( DFORDERED ) )
	Error1( "IF2 INPUT IS NOT DFOrdered" );

    if ( IsStamp( OFFSETS ) )
	Error1( "OFFSETS ASSIGNED---NoOp NODES NOT IMPLEMENTED" );

    if ( !IsStamp( NORMALIZED ) )
	Error1( "NORMALIZATION REQUIRED" );

    if ( !IsStamp( BUILDINPLACE ) )
	Error1( "MINIMAL BUILD-IN-PLACE REQUIRED" );

    /* if ( !IsStamp( MONOLITH ) ) */ /* NEW CANN 2/92 */
	/* Error1( "MONOLITHIC INPUT REQUIRED" ); */

    if ( info )
        fprintf( stderr, "\n**** UPDATE-IN-PLACE OPTIMIZATION\n" );

    StartProfiler();
    If2Up( sdbx );
    StopProfiler( "If2Up" );

    sprintf( ustmp, "    CSU -> UPDATE-IN-PLACE: %s%s%s%s",
	            ( minopt )? " minopt" : "", ( cagg )?   "cagg"    : "",
		    ( ststr )?  " ststr"  : "", ( sgnok  )? " sgnok"  : "" );

    if ( univso )
	AddStamp( UNIVSTROWNER, "    CSU -> UNIVERSAL STREAM OWNERSHIP" );

    AddStamp( UPDATEINPLACE,  ustmp );

    /* OPEN THE OUTPUT FILE AND WRITE THE OPTIMIZED PROGRAM               */

    if ( ofile != NULL ) {
        if ( (fd = fopen( ofile, "w" )) == NULL )
            Error2( "CAN'T OPEN", ofile );

            output = fd;
	    }

    StartProfiler();
    If2Write();
    StopProfiler( "If2Read" );

    Stop( OK );
}
