#include "world.h"


FILE *input  = stdin;                  /* IF2 INPUT  FILE POINTER         */
FILE *output = stdout;                 /* IF2 OUTPUT FILE POINTER         */

char *program    = "if2part";          /* PROGRAM NAME                    */

int   sgnok      = TRUE;     /* ARE SIGNED ARITHMETIC CONSTANTS ALLOWED?  */
int   info       = FALSE;    /* GENARATE INFORMATION ABOUT OPTIMIZATIONS? */
int   vinfo      = FALSE;    /* GENERATE VECTOR-CONCURRENT INFO           */

int   streams    = FALSE;
int   cycle      = FALSE;
int   nopred     = FALSE;

int   prof       = FALSE;    /* PROFILE THE OPTIMIZER?                    */

int   dovec      = FALSE;

int   procs      = 1;    /* NUMBER OF AVAILABLE PROCESSORS IN THE SYSTEM  */
int   cRay       = FALSE;                        /* VECTORIZE FOR A CRAY? */
int   vadjust    = 1;                    /* VECTORIZATION COST ADJUSTMENT */

static char  pstmp[100];     /* CSU-PARTITION STAMP COMMENTARY            */
static char *ofile = NULL;   /* OUTPUT FILE NAME                          */

/**************************************************************************/
/* LOCAL  **************      ParseCommandLine     ************************/
/**************************************************************************/
/* PURPOSE: PARSE THE COMMAND LINE argv CONTAINING argc ENTRIES. THE 1ST  */
/*          ENTRY (argv[0]) IS IGNORED.   IF AN ARGUMENT DOES NOT BEGIN   */
/*          WITH A DASH, IT IS CONSIDERED THE NAME OF A FILE.  THE FIRST  */
/*          ENCOUNTERED FILE IS FOR IF2 INPUT.  THE SECOND ENCOUNTERED    */
/*          FILE IS FOR IF2 OUTPUT.  ANY OTHER FILES ON THE COMMAND LINE  */
/*          CAUSE AN ERROR MESSAGE TO BE PRINTED.                         */
/*                                                                        */
/*          OPTIONS: -s     -> SIGNED CONSTANTS AREN'T ALLOWED            */
/*                   -i     -> PRINT OPTIMIZATION INFORMATION TO stderr.  */
/*                   -H#    -> SLICE THRESHOLD                            */ 
/*                   -I#    -> ASSUMED NUMBER OF LOOP ITERATIONS          */
/*                   -L#    -> NESTED PARALLELIZATION THRESHOLD           */
/*                   -O     -> DISABLE OPTIMIZED PARTITIONING             */
/*                   -A     -> DIABLE PARALLELIZATION OF REDUCTION OPS    */
/*                   -v     -> ENABLE VECTORIZER                          */
/*                   -P#    -> PROCESSORS AVAILABLE IN THE SYSTEM         */
/*                   -C     -> VECTORIZE FOR A CRAY X-MP                  */
/*                   -Xfile -> MODULE DATA BASE FILE NAME                 */
/**************************************************************************/

static void ParseCommandLine( argc, argv )
int    argc;
char **argv;
{
    register char *c;
    register int   fmode = 0;
    register int   idx;
    register FILE *fd;
    register double huge = -1.0;
    register int   iter = -1;
    register int   rcf = FALSE;

    for ( idx = 1; idx < argc; ++idx ) {
        if ( *(c = argv[ idx ]) != '-' ) {
            switch ( fmode ) {
		case 0:
		    ReadCostFile( c );
		    fmode++; rcf = TRUE;
		    break;

                case 1: 
                    if ( (fd = fopen( c, "r" )) == NULL )
			Error2( "CAN'T OPEN", c );

		    input = fd;

		    AssignSourceFileName( c );

                    fmode++;
                    break;

                case 2:
		    ofile = c;

		    fmode++;
                    break;

                default:
                    Error2( "ILLEGAL ARGUMENT", c );
                }

            continue;
            }

        switch ( *( ++c ) ) {
	    case 'X':
		mdbfile = c+1;
	        break;

	    case 'W': 
		prof = TRUE;
		break;

	    case 'C':
		cRay = TRUE;
		vadjust = atoi( c+1 );
		break;

            case '\0':
		fmode++;
                break;

            case 's':
                sgnok = FALSE;
                break;

	    case 'R':
		nopred = TRUE;
		break;

	    case 'i':
		info = TRUE;
		break;

	    case 'P':
		if ( (procs = atoi( c + 1 )) <= 0 )
		    Error2( "ILLEGAL ARGUMENT", --c );

		break;

	    case 'H':
		if ( (huge = atof( c + 1 )) < 0.0 )
		    Error2( "ILLEGAL ARGUMENT", --c );

		break;

	    case 'V':
		vinfo = TRUE;
		break;

	    case 'v':
		dovec = TRUE;
		break;

	    case 'A':
		if ( (atlevel = atoi( c + 1 )) < 0 )
		    Error2( "ILLEGAL ARGUMENT", --c );

		break;

	    case 'L':
		if ( (level = atoi( c + 1 )) < 0 )
		    Error2( "ILLEGAL ARGUMENT", --c );

		break;

	    case '@':
		if ( (iter = atoi( c + 1 )) < 0 )
		    Error2( "ILLEGAL ARGUMENT", --c );

		break;

            default:
                Error2( "ILLEGAL ARGUMENT", --c );
            }
        }

    if ( !rcf )
	Error1( "COST FILE NOT PROVIDED ON COMMAND LINE" );

    if ( huge != -1.0 )
	SliceThreshold = huge;

    if ( iter != -1 ) {
	Iterations    = (double) iter;
	ArrayCopyCost = (double) iter;
	}
}


/**************************************************************************/
/* GLOBAL **************           Stop            ************************/
/**************************************************************************/
/* PURPOSE: CLOSE ALL OPEN FILES AND STOP PROGRAM EXECUTION.  THE STATUS  */
/*          (status) IS RETURNED TO THE INVOKER OF THE PROGRAM.           */
/**************************************************************************/

void Stop( status )
int status;
{
    exit( status );
}


/**************************************************************************/
/* GLOBAL **************            main           ************************/
/**************************************************************************/
/* PURPOSE: PERFORM GRAPH PARTITIONING ANALYSIS. THE INPUT FILE MUST BE   */
/*          DATA FLOW ORDERED, NORMALIZED, MONOLITHIC, AND NOT HAVE       */
/*          OFFSETS ASSIGNED (BY THE LLNL UTILITY if1offset). FURTHER,    */
/*          MINIMAL BUILD-IN-PLACE AND UPDATE-IN-PLACE ANALYSIS MUST HAVE */
/*          ALREADY BEEN DONE. THE 'P' STAMP IS APPENDED TO THE RESULTING */
/*          OUTPUT.                                                       */
/**************************************************************************/

void main( argc, argv )
int    argc;
char **argv;
{
    register FILE *fd;

    ParseCommandLine( argc, argv );

    StartProfiler();
    If2Read();
    StopProfiler( "If2Read" );

    ReadModuleDataBase();

    fclose( input );                      /* AS IT MAY BE THE OUTPUT FILE */

    if ( !IsStamp( DFORDERED ) )
	Error1( "IF2 INPUT IS NOT DFOrdered" );

    if ( IsStamp( OFFSETS ) )
	Error1( "OFFSETS ASSIGNED---NoOp NODES NOT IMPLEMENTED" );

    if ( !IsStamp( NORMALIZED ) )
	Error1( "NORMALIZATION REQUIRED" );

    if ( !IsStamp( BUILDINPLACE ) )
	Error1( "MINIMAL BUILD-IN-PLACE REQUIRED" );

    if ( !IsStamp( UPDATEINPLACE ) )
	Error1( "MINIMAL UPDAYE-IN-PLACE REQUIRED" );

    /* if ( !IsStamp( MONOLITH ) ) */ /* NEW CANN */
	/* Error1( "MONOLITHIC INPUT REQUIRED" ); */

    if ( info )
        fprintf( stderr, "\n**** GRAPH PARTITIONING\n" );

    StartProfiler();
    If2Cost();
    StopProfiler( "If2Cost" );

    StartProfiler();
    If2Part();
    StopProfiler( "If2Part" );

    if ( info || vinfo )
	If2Count();

    sprintf( pstmp, "     CSU -> PARTITIONED: %s",
	            ( sgnok  )? " sgnok"  : ""  );

    AddStamp( PARTITIONED,  pstmp );

    AddModuleStamp();
    WriteModuleDataBase();

    /* OPEN THE OUTPUT FILE AND WRITE THE OPTIMIZED PROGRAM               */

    if ( ofile != NULL ) {
        if ( (fd = fopen( ofile, "w" )) == NULL )
            Error2( "CAN'T OPEN", ofile );

            output = fd;
	    }

    StartProfiler();
    If2Write();
    StopProfiler( "If2Write" );

    Stop( OK );
}
