#include "world.h"


/**************************************************************************/
/* GLOBAL **************        PrintSelect        ************************/
/**************************************************************************/
/* PURPOSE: PRINT Select NODE n TO output.                                */
/**************************************************************************/

void PrintSelect( indent, n )
int   indent;
PNODE n;
{
    PrintIndentation( indent );

    fprintf( output, "if ( " );

    if ( n->usucc != NULL ) {
	if ( IsNot( n->usucc ) )
	    fprintf( output, " !( " );

        PrintTemp( n->usucc->imp );

	switch ( n->usucc->type ) {
	    case IFGreat:
		fprintf( output, " > " );
		goto DyadicFinish;

	    case IFGreatEqual:
		fprintf( output, " >= " );
		goto DyadicFinish;

	    case IFLess:
		fprintf( output, " < " );
		goto DyadicFinish;

	    case IFLessEqual:
		fprintf( output, " <= " );
		goto DyadicFinish;

	    case IFEqual:
		fprintf( output, " == " );
		goto DyadicFinish;

	    case IFNotEqual:
		fprintf( output, " != " );
		goto DyadicFinish;

	    case IFPlus:
		fprintf( output, " || " );
		goto DyadicFinish;

	    case IFTimes:
		fprintf( output, " && " );

DyadicFinish:
		PrintTemp( n->usucc->imp->isucc );
		break;

	    case IFNot:
		fprintf( output, " )" );
		break;
	    }

	}
    else
        PrintTemp( n->S_TEST->imp );

    fprintf( output, " ) {\n" );

	PrintProducerModifiers( indent + 2, n->S_CONS );
	PrintGraph( indent + 2, n->S_CONS );
	PrintProducerModifiers( indent + 2, n );
	PrintConsumerModifiers( indent + 2, n->S_CONS );

    PrintIndentation( indent );
    fprintf( output, "} else {\n" );

	PrintProducerModifiers( indent + 2, n->S_ALT );
	PrintGraph( indent + 2, n->S_ALT );
	PrintProducerModifiers( indent + 2, n );
	PrintConsumerModifiers( indent + 2, n->S_ALT );

    PrintIndentation( indent );
    fprintf( output, "}\n" );

    PrintConsumerModifiers( indent, n );
}


/**************************************************************************/
/* GLOBAL **************        PrintTagCase       ************************/
/**************************************************************************/
/* PURPOSE: PRINT TagCase NODE n TO output.                               */
/**************************************************************************/

void PrintTagCase( indent, n )
int   indent;
PNODE n;
{
  register PALIST c;
  register PNODE sg;

  PrintIndentation( indent );

  fprintf( output, "switch ( " );
  PrintTemp( n->usucc->exp );
  fprintf( output, " ) {\n" );

  for ( sg = n->C_SUBS; sg != NULL; sg = sg->gsucc ) {
    for ( c = sg->G_TAGS; c != NULL; c = c->next ) {
      PrintIndentation( indent + 2 );
      fprintf( output, "case %d:\n", c->datum );
      }

    if ( sg->G_TAGS == NULL )
      continue;

    PrintProducerModifiers( indent + 4, sg );
    PrintGraph( indent + 4,sg );
    PrintProducerModifiers( indent + 4, n );
    PrintConsumerModifiers( indent + 4, sg );

    PrintIndentation( indent + 4 );
    fprintf( output, "break;\n" );
    }

  PrintIndentation( indent + 2 );
  fprintf( output, "default:\n" );
  PrintIndentation( indent + 4 );
  fprintf( output, "Error( \"TagCase\", \"ILLEGAL UNION TAG\" );\n" );

  PrintIndentation( indent );
  fprintf( output, "}\n" );

  PrintConsumerModifiers( indent, n );
}
