#include "world.h"


/**************************************************************************/
/* GLOBAL **************       PrintUGetTag        ************************/
/**************************************************************************/
/* PURPOSE: PRINT UNION GET TAG NODE n TO output.                         */
/**************************************************************************/

void PrintUGetTag( indent, n )
int   indent;
PNODE n;
{
  PrintIndentation( indent );
  PrintTemp( n->exp );
  fprintf( output, " = ((%s*)", n->imp->info->sname );
  PrintTemp( n->imp );
  fprintf( output, ")->Tag;\n" );
}


/**************************************************************************/
/* GLOBAL **************       PrintUElement       ************************/
/**************************************************************************/
/* PURPOSE: PRINT UElement NODE n TO output. THE DEREFERENCED FIELD IS    */
/*          ASSUMED THE FIRST ENTRY IN THE SUBGRAPHS TAG LIST.            */
/**************************************************************************/

void PrintUElement( indent, n )
int   indent;
PNODE n;
{
    PrintIndentation( indent );

    PrintTemp( n->exp );
    fprintf( output, " = " );
    PrintFldRef( n->imp->info->sname, NULL, n->imp, "Data.Fld", 
                 n->imp->src->G_TAGS->datum                  );
    fprintf( output, ";\n" );

    PrintProducerModifiers( indent, n );
    PrintConsumerModifiers( indent, n );
}


/**************************************************************************/
/* GLOBAL **************        PrintUBuild        ************************/
/**************************************************************************/
/* PURPOSE: PRINT UNION RBuild NODE n TO output.                          */
/**************************************************************************/

void PrintUBuild( indent, n )
int   indent;
PNODE n;
{
    PrintIndentation( indent );

    fprintf( output, "UBld( " );
    PrintTemp( n->exp );
    fprintf( output, ", %s, %d, %d );\n", n->exp->info->sname,
	     n->exp->sr, n->imp->iport - 1                  );

    PrintFldAssgn( indent, n->exp->info->sname, NULL, n->exp, 
		   "Data.Fld", n->imp->iport - 1, n->imp   );
}


/**************************************************************************/
/* GLOBAL **************        PrintRBuild        ************************/
/**************************************************************************/
/* PURPOSE: PRINT RECORD BUILD NODE n TO output. IF n IS A CONSTANT NODE  */
/*          THEN ONLY THE LOCK IS INITIALIZED.                            */
/**************************************************************************/

void PrintRBuild( indent, n )
int   indent;
PNODE n;
{
    register PEDGE i;

    if ( n->cmark ) {
	PrintIndentation( indent );
	fprintf( output, "%s( ", GetIncRefCountName( n->exp->info ) );
	PrintTemp( n->exp );
	fprintf( output, ", %s, %d );\n", n->exp->info->sname, 1 );
	return;
	}

    PrintIndentation( indent );

    fprintf( output, "RBld( " );
    PrintTemp( n->exp );
    fprintf( output, ", %s, %d );\n", n->exp->info->sname, n->exp->sr );

    for ( i = n->imp; i != NULL; i = i->isucc )
	PrintFldAssgn( indent, n->exp->info->sname, NULL, n->exp,
			"Fld", i->iport, i );
}


/**************************************************************************/
/* GLOBAL **************       PrintRElements      ************************/
/**************************************************************************/
/* PURPOSE: PRINT RECORD ELEMENTS NODE n TO output.                       */
/**************************************************************************/

void PrintRElements( indent, n )
int   indent;
PNODE n;
{
    register PEDGE e;
    register PEDGE ee;

    for ( e = n->exp; e != NULL; e = e->esucc ) {
	if ( e->eport < 0 ) {
	    e->eport = -(e->eport);
	    continue;
	    }

        PrintIndentation( indent );

        PrintTemp( e );
        fprintf( output, " = " );
        PrintFldRef( n->imp->info->sname, NULL, n->imp, "Fld", e->eport );
        fprintf( output, ";\n" );

	for ( ee = e->esucc; ee != NULL; ee = ee->esucc )
	    if ( ee->eport == e->eport )
                ee->eport = -(ee->eport);
	}

    PrintProducerModifiers( indent, n );
    PrintConsumerModifiers( indent, n );
}


/**************************************************************************/
/* GLOBAL **************       PrintRReplace       ************************/
/**************************************************************************/
/* PURPOSE: PRINT RECORD REPLACE NODE n TO output. IF n->nmark IS TRUE,   */
/*          AN ATTEMPT IS NOT MADE TO RECYCLE REPLACED AGGREGATES.        */
/**************************************************************************/

void PrintRReplace( indent, n )
int   indent;
PNODE n;
{
  register PEDGE i;

  if ( n->exp->temp != n->imp->temp )
    PrintAssgn( indent, n->exp, n->imp );

  PrintSetRefCount( indent, n->exp, n->exp->sr, FALSE );

  for ( i = n->imp->isucc; i != NULL; i = i->isucc ) {
    if ( !( n->nmark ) )
      if ( !IsBasic( i->info ) ) {
	PrintIndentation( indent );

	fprintf( output, "%s( (((%s*)", 
		 GetFreeName( i->info ), n->imp->info->sname );
	PrintTemp( n->imp );
	fprintf( output, ")->Fld%d) );\n", i->iport - 1 );
        }
	
    PrintFldAssgn( indent, n->exp->info->sname, NULL, n->exp,
		   "Fld", i->iport - 1, i                  );
    }
}


/**************************************************************************/
/* GLOBAL **************      PrintRecordNoOp      ************************/
/**************************************************************************/
/* PURPOSE: PRINT RECORD NoOp NODE n TO output.  IF THE INPUT HAS AN R    */
/*          MARK, COPYING ISN'T DONE.  AN r MARK RESULTS IN CONDITIONAL   */
/*          COPYING AND NO MARK ALWAYS RESULTS IN COPYING.                */
/**************************************************************************/

void PrintRecordNoOp( indent, n )
int   indent;
PNODE n;
{
    register char  *opcode;
    register PINFO  i;
    register int    c;

    if ( n->imp->rmark1 == RMARK ) {
	if ( n->imp->temp != n->exp->temp )
	    PrintAssgn( indent, n->exp, n->imp );

	return;
	}

    if ( n->imp->rmark1 == rMARK )
	opcode = "CRNoOp";
    else
	opcode = "RNoOp";

    PrintIndentation( indent );

    fprintf( output, "%s( ", opcode );
    PrintTemp( n->exp );
    fprintf( output, ", " );
    PrintTemp( n->imp );
    fprintf( output, ", %s );\n", n->exp->info->sname );

    for ( c = 1, i = n->exp->info->R_FIRST; i != NULL; i = i->L_NEXT, c++ ) {
	if ( IsBasic( i->L_SUB ) )
	    continue;

	PrintIndentation( indent );

        fprintf( output, "%s( ((%s*)", GetIncRefCountName( n->exp->info ),
		 n->exp->info->sname                                    );
	PrintTemp( n->exp );
	fprintf( output, ")->Fld%d, %s, 1 );\n", c, i->L_SUB->sname );
	}

    PrintConsumerModifiers( indent, n );

    if ( n->imp->rmark1 == rMARK ) {
        PrintIndentation( indent );

        fprintf( output, "EndCRNoOp( " );
	PrintTemp( n->exp );
	fprintf( output, ", " );
	PrintTemp( n->imp );
	fprintf( output, " );\n" );
	}
}


/**************************************************************************/
/* GLOBAL **************       PrintBRAStore       ************************/
/**************************************************************************/
/* PURPOSE: PRINT BRAStore NODE n OF AGatherAT NODE gat TO output.        */
/**************************************************************************/

void PrintBRAStore( indent, n, gat )
int   indent;
PNODE n;
PNODE gat;
{
  register PNODE l;
  register PEDGE i;

  l = gat->exp->dst->G_DAD;

  for ( i = n->imp; i != NULL; i = i->isucc ) {
    PrintIndentation( indent );

    fprintf( output, "((%s*)", n->exp->info->tname );
    PrintTemp( gat->exp );

    if ( l->vmark || l->smark ) {
      fprintf( output, ")[" );
      PrintTemp( l->F_GEN->imp );
      fprintf( output, "].Fld%d = ", i->iport );
      PrintTemp( i );
      fprintf( output, ";\n" );
    } else {
      fprintf( output, ")->Fld%d =", i->iport );
      PrintTemp( i );
      fprintf( output, ";\n" );
      }
    }

    if ( !( l->vmark || l->smark ) ) {
      PrintIndentation( indent );
      PrintTemp( gat->exp );
      fprintf( output, " = (POINTER)(((%s*)", n->exp->info->tname );
      PrintTemp( gat->exp );
      fprintf( output, ")+1);\n" );
      }
}


/**************************************************************************/
/* GLOBAL **************        PrintBRBuild       ************************/
/**************************************************************************/
/* PURPOSE: PRINT BRBuild NODE n TO output.                               */
/**************************************************************************/

void PrintBRBuild( indent, n )
int   indent;
PNODE n;
{
  register PEDGE i;

  if ( n->cmark )
    return;

  for ( i = n->imp; i != NULL; i = i->isucc ) {
    PrintIndentation( indent );
    PrintTemp( n->exp );
    fprintf( output, ".Fld%d = ", i->iport );
    PrintTemp( i );
    fprintf( output, ";\n" );
    }
}


/**************************************************************************/
/* GLOBAL **************    PrintBROptAElement     ************************/
/**************************************************************************/
/* PURPOSE: PRINT AOptAElement-BRElement PAIR ROOTED BY NODE n TO stderr. */
/**************************************************************************/

void PrintBROptAElement( indent, n )
int   indent;
PNODE n;      /* IFBRElement NODE */
{
  register PEDGE e;
  register PEDGE ee;
  register PNODE ae;

  ae = n->imp->src;

  for ( e = n->exp; e != NULL; e = e->esucc ) {
    if ( e->eport < 0 ) {
      e->eport = -(e->eport);
      continue;
      }

    PrintIndentation( indent );
    PrintTemp( e );
    fprintf( output, " = " );

    /* PRINT THE ARRAY DEREFERENCE HERE */
    fprintf( output, "((%s*)", ae->exp->info->tname );
    PrintTemp( ae->imp );
    fprintf( output, ")[" );
    PrintTemp( ae->imp->isucc );
    fprintf( output, "]" );

    fprintf( output, ".Fld%d;\n", e->eport );

    for ( ee = e->esucc; ee != NULL; ee = ee->esucc )
      if ( ee->eport == e->eport )
        ee->eport = -(ee->eport);
    }

  PrintProducerModifiers( indent, ae );
  PrintConsumerModifiers( indent, ae );
}


/**************************************************************************/
/* GLOBAL **************      PrintBRElements      ************************/
/**************************************************************************/
/* PURPOSE: PRINT BRElements NODE n TO output.                            */
/**************************************************************************/

void PrintBRElements( indent, n )
int   indent;
PNODE n;
{
  /*
  register PEDGE e;

  for ( e = n->exp; e != NULL; e = e->esucc ) {
    PrintIndentation( indent );
    PrintTemp( e );
    fprintf( output, " = " );
    PrintTemp( n->imp );
    fprintf( output, ".Fld%d;\n", e->eport );
    } 
  */

  register PEDGE e;
  register PEDGE ee;

  for ( e = n->exp; e != NULL; e = e->esucc ) {
    if ( e->eport < 0 ) {
      e->eport = -(e->eport);
      continue;
      }

    PrintIndentation( indent );
    PrintTemp( e );
    fprintf( output, " = " );
    PrintTemp( n->imp );
    fprintf( output, ".Fld%d;\n", e->eport );

    for ( ee = e->esucc; ee != NULL; ee = ee->esucc )
      if ( ee->eport == e->eport )
        ee->eport = -(ee->eport);
    }
}


/**************************************************************************/
/* GLOBAL **************      PrintBRReplace       ************************/
/**************************************************************************/
/* PURPOSE: PRINT BRReplace NODE n TO output.                             */
/**************************************************************************/

void PrintBRReplace( indent, n )
int   indent;
PNODE n;
{
  register PEDGE i;
  register PINFO r;
  register int   c;

  if ( n->exp->temp != n->imp->temp )
    PrintAssgn( indent, n->exp, n->imp );

  /* DO THE REPLACEMENTS */
  for ( i = n->imp->isucc; i != NULL; i = i->isucc ) {
    PrintIndentation( indent );
    PrintTemp( n->exp );
    fprintf( output, ".Fld%d = ", i->iport - 1 );
    PrintTemp( i );
    fprintf( output, ";\n" );
    }
}


/**************************************************************************/
/* GLOBAL **************      PrintUTagTest        ************************/
/**************************************************************************/
/* PURPOSE: PRINT UNION TAG TEST NODE n TO output.                        */
/**************************************************************************/

void PrintUTagTest( indent, n )
int   indent;
PNODE n;
{
  PrintIndentation( indent );
  PrintTemp( n->exp );
  fprintf( output, " = ( ((%s*)", n->imp->info->sname );
  PrintTemp( n->imp );
  fprintf( output, ")->Tag == %d )? TRUE : FALSE;\n", n->imp->iport );
}
