#include "world.h"


/* scc UNDER Unicos APPEARS TO HAVE TROUBLE CORRECTLY VECTORIZING LOOPS */
/* NOT ALREADY SUBJECTED TO cse AND gcse OPTIMIZATIONS                  */
static int WasCseANDGcseDone()
{
  register char *s;
  register int   gcse;
  register int   cse;
  
  if ( (s = stamps[ IF1OPTIMIZED ]) == NULL )
    return( FALSE );

  gcse = cse = FALSE;

  while ( *s != '\0' ) {
    if ( *(s) == ' ' )
      if ( *(s+1) == 'g' )
        if ( *(s+2) == 'c' )
          if ( *(s+3) == 's' )
            if ( *(s+4) == 'e' )
              gcse = TRUE;

    if ( *(s) == ' ' )
      if ( *(s+1) == 'c' )
        if ( *(s+2) == 's' )
          if ( *(s+3) == 'e' )
            cse = TRUE;

    s++;
    }

  return( gcse && cse );
}


static int AreImportReferenceCountOps( n )
PNODE n;
{
  register PEDGE i;

  for ( i = n->imp; i != NULL; i = i->isucc )
    if ( i->cm != 0 || i->pm > 0 || i->sr > 0 || i->pl > 0 )
      return( TRUE );

  return( FALSE );
}


static int AreComplexImports( n )
PNODE n;
{
  register PEDGE i;

  i = (IsCall( n ))? n->imp->isucc : n->imp;
  for ( /* NOTHING */; i != NULL; i = i->isucc )
    if ( !IsBasic( i->info ) )
      /* BUFFERS ALLOWED IN SPECIAL ReduceAT CONSTRUCTIONS */
      if ( !IsBuffer( i->info ) )
        return( TRUE );

  return( FALSE );
}


static int IsIvdepOk( g )
PNODE g;
{
  register PNODE n;
  register PEDGE i;
  register PEDGE e;

  if ( !WasCseANDGcseDone() )
    return( FALSE );

  if ( AreImportReferenceCountOps( g ) )
    return( FALSE );

  for ( n = g->G_NODES; n != NULL; n = n->nsucc ) {
    if ( AreImportReferenceCountOps( n ) )
      return( FALSE );

    if ( IsSelect( n ) ) {
      if ( IsConst( n->S_TEST->imp ) )
	return( FALSE );

      if ( !IsIvdepOk( n->S_CONS ) )
	return( FALSE );

      if ( !IsIvdepOk( n->S_ALT ) )
	return( FALSE );

      continue;
      }

    if ( IsCompound( n ) )
      return( FALSE );

    if ( n->type == IFOptAElement ) {
      /* basic record dereferences within selects seem to confuse scc */
      if ( IsBRecord( n->exp->info ) )
	if ( !IsForall( g->G_DAD ) )
	  return( FALSE );

      continue;
      }

    /* select imported indirection seems to confuse scc */
    if ( n->type == IFGetArrayBase ) {
      for ( e = n->exp; e != NULL; e = e->esucc )
	if ( IsCompound( e->dst ) )
	  return( FALSE );

      continue;
      }


    if ( AreComplexImports( n ) )
      return( FALSE );
    }

  return( TRUE );
}


static char *PrintVectorTemp( fd, i )
FILE  *fd;
PEDGE  i;
{
  register int  type;
	   char buf[100];

  if ( i->vtemp <= 0 )
    Error2( "PrintVectorTemp", "VECTOR TEMP NOT ASSIGNED" );

  if ( IsBuffer( i->info ) )
    type = i->info->A_ELEM->A_ELEM->type;
  else if ( IsArray( i->info ) )
    type = i->info->A_ELEM->type;
  else
    Error2( "PrintVectorTemp", "ILLEGAL VECTOR TYPE" );

  switch ( type ) {
    case IF_DOUBLE:
      sprintf( buf, "VD%d", i->vtemp );
      break;

    case IF_REAL:
      sprintf( buf, "VF%d", i->vtemp );
      break;

    case IF_INTEGER:
      sprintf( buf, "VI%d", i->vtemp );
      break;

    default:
      Error2( "PrintVectorTemp", "ILLEGAL BUFFER COMPONENT TYPE" );
      break;
    }

  if ( fd != NULL ) {
    fprintf( fd, "%s", buf );
    return( NULL );
    }
  return( CopyString( buf ) );
}


/**************************************************************************/
/* GLOBAL **************        PrintAStore        ************************/
/**************************************************************************/
/* PURPOSE: PRINT AStore NODE n OF AGatherAT NODE gat TO output.          */
/**************************************************************************/

void PrintAStore( indent, n, gat )
int   indent;
PNODE n;
PNODE gat;
{
  register PNODE l;

  l = gat->exp->dst->G_DAD;

  PrintIndentation( indent );

  if ( l->vmark || l->smark ) {
    fprintf( output, "VecGathATUpd( " );
    PrintTemp( l->F_GEN->imp );
    fprintf( output, ", %s, ", gat->exp->info->A_ELEM->tname );
    }
  else
    fprintf( output, "GathATUpd( %s, ", gat->exp->info->A_ELEM->tname ); 

  PrintTemp( gat->exp );
  fprintf( output, ", " );
  PrintTemp( n->imp );
  fprintf( output, " );\n" );
}


/**************************************************************************/
/* LOCAL  **************      PrintYankedRed       ************************/
/**************************************************************************/
/* PURPOSE: PRINT YANKED BASIC REDUCTION UPDATE NODE n TO OUTPUT.         */
/**************************************************************************/

void PrintYankedRed( indent, n, macro )
int    indent;
PNODE  n;
char  *macro;
{
    register PEDGE i = n->gsucc->exp;

    fprintf( output, "/* YankedRed */\n" );
    PrintIndentation( indent );
    fprintf( output, "Opt%s( ", macro );

    PrintTemp( i );
    fprintf( output, ", " );
    PrintTemp( i );
    fprintf( output, ", " );
    PrintTemp( n->imp );
    fprintf( output, " );\n" );
}


/**************************************************************************/
/* GLOBAL **************      AreAllUnitFanout     ************************/
/**************************************************************************/
/* PURPOSE: RETURN TRUE IF THE FANOUT OF EACH EXPORT OF EACH NODE IN THE  */
/*          NODE LIST OF LOOP TEST SUBGRAPH g IS 1.                       */
/**************************************************************************/

int AreAllUnitFanout( g )
PNODE g;
{
    register PNODE n;

    for ( n = g->G_NODES; n != NULL; n = n->nsucc )
	if ( n->exp->esucc != NULL )
	    return( FALSE );

    return( TRUE );
}


/**************************************************************************/
/* LOCAL  **************       PrintLoopTest       ************************/
/**************************************************************************/
/* PURPOSE: PRINT THE LOOP TEST EXPRESSION TREE ROOTED BY EDGE i TO       */
/*          output.                                                       */
/**************************************************************************/

static void PrintLoopTest( i )
PEDGE i;
{
    if ( IsConst( i ) ) {
	PrintTemp( i );
	return;
	}

    switch ( i->src->type ) {
        case IFPlus:
	    fprintf( output, "( " );
	    PrintLoopTest( i->src->imp );
	    fprintf( output, " || " );
	    PrintLoopTest( i->src->imp->isucc );
	    fprintf( output, " )" );
	    break;

	case IFTimes:
	    fprintf( output, "( " );
	    PrintLoopTest( i->src->imp );
	    fprintf( output, " && " );
	    PrintLoopTest( i->src->imp->isucc );
	    fprintf( output, " )" );
	    break;

	case IFGreat:
	    fprintf( output, "( " );
	    PrintLoopTest( i->src->imp );
	    fprintf( output, " > " );
	    PrintLoopTest( i->src->imp->isucc );
	    fprintf( output, " )" );
	    break;

	case IFGreatEqual:
	    fprintf( output, "( " );
	    PrintLoopTest( i->src->imp );
	    fprintf( output, " >= " );
	    PrintLoopTest( i->src->imp->isucc );
	    fprintf( output, " )" );
	    break;

	case IFLess:
	    fprintf( output, "( " );
	    PrintLoopTest( i->src->imp );
	    fprintf( output, " < " );
	    PrintLoopTest( i->src->imp->isucc );
	    fprintf( output, " )" );
	    break;

	case IFLessEqual:
	    fprintf( output, "( " );
	    PrintLoopTest( i->src->imp );
	    fprintf( output, " <= " );
	    PrintLoopTest( i->src->imp->isucc );
	    fprintf( output, " )" );
	    break;

	case IFNotEqual:
	    fprintf( output, "( " );
	    PrintLoopTest( i->src->imp );
	    fprintf( output, " != " );
	    PrintLoopTest( i->src->imp->isucc );
	    fprintf( output, " )" );
	    break;

	case IFEqual:
	    fprintf( output, "( " );
	    PrintLoopTest( i->src->imp );
	    fprintf( output, " == " );
	    PrintLoopTest( i->src->imp->isucc );
	    fprintf( output, " )" );
	    break;

	case IFNot:
	    fprintf( output, "( !( " );
	    PrintLoopTest( i->src->imp );
	    fprintf( output, " ) )" );
	    break;

	case IFSGraph:
	    PrintTemp( i );
	    break;

	default:
	    Error2( "PrintLoopTest", "ILLEGAL LOOP TEST NODE" );
	}
}


/**************************************************************************/
/* GLOBAL **************       PrintSumOfTerms     ************************/
/**************************************************************************/
/* PURPOSE: PRINT SUM OF TERMS MACRO FOR FORALL NODE e->src AND THE       */
/*          ASSOCIATED MUTLIPLE NODE TO output.                           */
/**************************************************************************/

void PrintSumOfTerms( indent, e )
int   indent;
PEDGE e;
{
    register PEDGE i = FindImport( e->src->F_RET, e->eport );

    PrintIndentation( indent );

    switch ( i->src->imp->CoNsT[0] ) {
        case REDUCE_LEAST: 
            fprintf( output, "OptMin( " );
            break;

        case REDUCE_GREATEST:
            fprintf( output, "OptMax( " );
            break;

        case REDUCE_PRODUCT:
            if ( IsBoolean( i->info ) )
                fprintf( output, "OptAnd( " );
            else
                fprintf( output, "OptTimes( " );

            break;

        case REDUCE_SUM:
            if ( IsBoolean( i->info ) )
                fprintf( output, "OptOr( " );
            else
                fprintf( output, "OptPlus( " );

            break;
        }

    PrintFldRef( e->dst->info->sname, "args", NULL, "Out", e->iport );
    fprintf( output, ", " );
    PrintFldRef( e->dst->info->sname, "args", NULL, "Out", e->iport );
    fprintf( output, ", " );
    PrintTemp( e );
    fprintf( output, " );\n" );
}


/**************************************************************************/
/* LOCAL  **************       PrintBasicRed       ************************/
/**************************************************************************/
/* PURPOSE: PRINT BASIC REDUCTION UPDATE MACRO macro TO OUTPUT.           */
/**************************************************************************/

static void PrintBasicRed( indent, i, macro )
int    indent;
PEDGE  i;
char  *macro;
{
    register PEDGE v = i->src->imp->isucc->isucc;

    PrintIndentation( indent );

    fprintf( output, "%sOpt%s( ", (v->isucc != NULL)? "B" : "", macro );

    PrintTemp( i );
    fprintf( output, ", " );
    PrintTemp( i );
    fprintf( output, ", " );
    PrintTemp( v );

    if ( v->isucc != NULL ) {
	fprintf( output, ", " );
	PrintTemp( v->isucc );
	}

    fprintf( output, " );\n" );
}


/**************************************************************************/
/* LOCAL  **************       PrintRCatUpd        ************************/
/**************************************************************************/
/* PURPOSE: PRINT A Reduce Catenate UPDATE NODE TO output. THE REDUCE     */
/*          NODE IS ASSUMED TO BE i->src.                                 */
/**************************************************************************/

static void PrintRCatUpd( indent, i, v, bool, atnode )
int    indent;
PEDGE  i;
PEDGE  v;
PEDGE  bool;
int    atnode;
{
  register char  *macro;

  macro = (atnode)? "RCatAT" : "RCat";

  PrintIndentation( indent );

  fprintf( output, "%s%s%s( %s, ", (bool != NULL)? "B" : "", macro, 
	   IsBasic( i->info->A_ELEM )? "" : "X", i->info->A_ELEM->tname  );

  PrintTemp( i );

  fprintf( output, ", " );
  PrintTemp( v );

  if ( bool != NULL ) {
    fprintf( output, ", " );
    PrintTemp( bool );
    }

  if ( !atnode ) {
    if ( IsBasic( i->info->A_ELEM ) )
      fprintf( output, ", %s ", i->info->A_ELEM->tname );
    else
      fprintf( output, ", %s ", i->info->A_ELEM->sname );
    }

  if ( atnode ) {
    fprintf( output, ", %s, ", GetCopyFunction( i->info ) );
    /* THERE ISN'T A BOOLEAN IMPORT */
    PrintTemp( i->src->imp->isucc->isucc->isucc->isucc );
    }

  fprintf( output, " );\n" );
}


/**************************************************************************/
/* LOCAL  **************         PrintBldAT        ************************/
/**************************************************************************/
/* PURPOSE: PRINT AN ARRAY BuildAT AT MACRO TO output.                    */
/**************************************************************************/

static void PrintBldAT( indent, i, e, low, sz, b, n )
int   indent;
PEDGE i;
PEDGE e;
PEDGE low;
PEDGE sz;
PEDGE b;
PNODE n;
{
    register char *s;

    PrintIndentation( indent );

    switch ( n->type ) {
      case IFAGatherATDVI:
      case IFReduceATDVI:
	s = "DVI";
	break;

      case IFAGatherATDV:
      case IFReduceATDV:
	s = "DV";
	break;

      default:
	s = "";
	break;
      }

    fprintf( output, "%sBldAT%s( %s, ", 
	     (n->nmark)? "Opt" : "", s, i->info->A_ELEM->tname );

    PrintTemp( e );
    fprintf( output, ", " );
    PrintTemp( low );
    fprintf( output, ", " );
    PrintTemp( sz );
    fprintf( output, ", " );
    PrintTemp( b );
    fprintf( output, " );\n" );

    if ( i->src->usucc != NULL )
      if ( i->src->usucc->usucc == i->src )
	 return;

    if ( !(n->nmark) )
      PrintSetRefCount( indent, e, i->sr, FALSE );
}


/**************************************************************************/
/* LOCAL  **************      PrintReduceInit      ************************/
/**************************************************************************/
/* PURPOSE: PRINT THE INITIALIZATION OF e->temp WITH THE INITIAL VALUE    */
/*          ASSOCIATED WITH THE REDUCTION FUNCTION DEFINED BY EDGE f      */
/*          TO output.                                                    */
/**************************************************************************/

static void PrintReduceInit( indent, f, e )
int   indent;
PEDGE f;
PEDGE e;
{
    PrintIndentation( indent );

    PrintTemp( e );
    fprintf( output, " = " );

    switch ( f->CoNsT[0] ) {
        case REDUCE_LEAST: 
            switch ( e->info->type ) {
                case IF_REAL:
                    fprintf( output, "MaxFloat;\n" );
                    break;

                case IF_DOUBLE:
                    fprintf( output, "MaxDouble;\n" );
                    break;

                case IF_INTEGER:
                    fprintf( output, "MaxInt;\n" );
                    break;

                case IF_BOOL:
                    fprintf( output, "True;\n" );
                    break;
                }

            break;

        case REDUCE_GREATEST:
            switch ( e->info->type ) {
                case IF_REAL:
                    fprintf( output, "MinFloat;\n" );
                    break;

                case IF_DOUBLE:
                    fprintf( output, "MinDouble;\n" );
                    break;

                case IF_INTEGER:
                    fprintf( output, "MinInt;\n" );
                    break;

                case IF_BOOL:
                    fprintf( output, "False;\n" );
                    break;
                }

            break;

        case REDUCE_SUM:
            if ( !IsBoolean( e->info ) ) {
	        PrintTemp( f->isucc );
	        fprintf( output, ";\n" );
	        }
            else
	        fprintf( output, "False;\n" );

	    break;

        case REDUCE_PRODUCT:
            if ( !IsBoolean( e->info ) ) {
	        PrintTemp( f->isucc );
	        fprintf( output, ";\n" );
	        }
            else
	        fprintf( output, "True;\n" );

	    break;

	default:
	    break;
	}
}


/**************************************************************************/
/* LOCAL  **************     GetSliceParam     ************************/
/**************************************************************************/
/* PURPOSE: IF EDGE i DEFINES A CONSTANT THEN RETURN IT, ELSE FIND AND    */
/*          RETURN THE CORRESPONDING IMPORT TO ENQUE NODE n.              */
/**************************************************************************/

PEDGE GetSliceParam( i, n )
PEDGE i;
PNODE n;
{
    register PEDGE ii;

    if ( IsConst( i ) )
	return( i );

    /* MAKE SOME COMPILER CORRECTNESS CHECKS ON PORT NUMBERS, ETC. */
    if ( !IsSGraph( i->src ) )
      Error2( "GetSliceParam", "i->src NOT AN IFSGraph" );

    if ( (ii = FindImport( i->src->G_DAD, i->eport )) == NULL )
      Error2( "GetSliceParam", "FindImport FOR LOOP FAILED" );

    if ( !IsForall( i->src->G_DAD ) )
      Error2( "GetSliceParam", "i->src->G_DAD NOT IFForall" );

DoItAgain:
    if ( IsConst( ii ) )
      Error2( "GetSliceParam", "FindImport FOUND A CONSTANT" );

    if ( ii->src->type != IFLPGraph ) {
      if ( ii->src->type != IFAssign )
        Error2( "GetSliceParam", "FindImport FOUND A NON-IFLPGraph SOURCE" );

      ii = ii->src->imp;
      goto DoItAgain;
      }

    if ( ii->eport != i->eport )
      Error2( "GetSliceParam", "FindImport FOUND A PORT NUMBER ERROR" );

    if ( (ii = FindImport( n, i->eport )) == NULL )
      Error2( "GetSliceParam", "FindImport FOR ENQUE FAILED" );

    return( ii );
}


/**************************************************************************/
/* GLOBAL **************        PrintRanges        ************************/
/**************************************************************************/
/* PURPOSE: PRINT LoopPoolEnq NODE n'S RANGE ARGUMENTS TO output.  THE    */
/*          SLICED LOOPS CONTROLLING RANGES ARE PRINTED.                  */
/**************************************************************************/

void PrintRanges( n )
PNODE n;
{
    register PEDGE i;
    register int   c = 0;

    /* GUARANTEED NOT TO BE ScatterBufPartitions                         */
    i = n->usucc->imp->src->F_GEN->imp;

    fprintf( output, ", " );                              /* CONTROL LOW */
    PrintTemp( GetSliceParam( i->src->imp->src->imp, n ) );

    fprintf( output, ", " );                             /* CONTROL HIGH */
    PrintTemp( GetSliceParam( i->src->imp->isucc->src->imp, n ) );
}


/**************************************************************************/
/* GLOBAL **************    PrintSliceTaskInit     ************************/
/**************************************************************************/
/* PURPOSE: PRINT SLICE TASK INTIALIZATION MACROS TO output. EACH Out     */
/*          FIELD IS INTIALIZED ACCORDING TO THE MULTIPLE NODE BUILDING   */
/*          ITS VALUE.                                                    */
/**************************************************************************/

void PrintSliceTaskInit( indent, n )
int   indent;
PNODE n;
{
    register PEDGE i;

    for ( i = n->usucc->imp->src->F_RET->imp; i != NULL; i = i->isucc ) {
	if ( i->iport == 0 )
	    continue;

	switch ( i->src->type ) {
	    case IFReduce:
	    case IFRedLeft:
	    case IFRedRight:
	    case IFRedTree:
		PrintReduceInit( indent, i->src->imp, FindExport( n, i->iport));
		break;

	    case IFReduceAT:
	    case IFReduceATDVI:
	    case IFReduceATDV:
	    case IFRedLeftAT:
	    case IFRedRightAT:
	    case IFRedTreeAT:
		PrintBldAT( indent, i, FindExport( n, i->iport ), 
			    GetSliceParam( i->src->imp->isucc, n ),
			    GetSliceParam( FindImport( i->src, 6 ), n ),
			    GetSliceParam( FindImport( i->src, 5 ), n ),
			    i->src );
		break;

	    case IFAGatherATDVI:
	    case IFAGatherATDV:
	    case IFAGatherAT:
		PrintBldAT( indent, i, FindExport( n, i->iport ), 
			    GetSliceParam( i->src->imp, n ),
			    GetSliceParam( FindImport( i->src, 5 ), n ),
			    GetSliceParam( FindImport( i->src, 4 ), n ),
			    i->src );
		break;
	    }
	}
}


/**************************************************************************/
/* LOCAL  **************     PrintReturnRapUp      ************************/
/**************************************************************************/
/* PURPOSE: PRINT RETRUN SUBGRAPH r'S RAP-UP MACROS TO output.  THIS IS   */
/*          DONE AFTER THE LOOP HAS COMPLETED TO FINIALIZE THE RESULTS.   */
/**************************************************************************/

static void PrintReturnRapUp( indent, r )
int   indent;
PNODE r;
{
    register PEDGE i;

    if ( r->G_DAD->smark )                               /* SLICED LOOP? */
	return;

    for ( i = r->imp; i != NULL; i = i->isucc ) {
	if ( i->iport == 0 )
	    continue;

	switch ( i->src->type ) {
	    case IFFinalValue:
	    case IFFinalValueAT:
		if ( i->src->lmark )
		    PrintAssgn( indent, i, i->src->imp );

		PrintProducerModifiers( indent, i->src );
		break;

            case IFReduceAT:
	    case IFReduceATDVI:
	    case IFReduceATDV:
	    case IFRedLeftAT:
	    case IFRedRightAT:
	    case IFRedTreeAT:
		PrintBldAT( indent, i, i, i->src->imp->isucc,  
			    FindImport( i->src, 6 ), FindImport( i->src, 5 ),
			    i->src );

		if ( i->src->imp->isucc->isucc->pmark )
		    if ( !(i->src->nmark)  ) {
		      PrintIndentation( indent );

		      fprintf( output, "PRedATRapUp( " );
		      PrintTemp( FindImport( i->src, 5 ) );
		      fprintf( output, " );\n" );
		      }

		break;

	    case IFAGatherATDVI:
	    case IFAGatherATDV:
	    case IFAGatherAT:
                PrintBldAT( indent, i, i, i->src->imp, 
			    FindImport( i->src, 5 ), FindImport( i->src, 4 ),
			    i->src );
		break;

	    case IFAGather:
		break;

            case IFReduce:
	    case IFRedLeft:
	    case IFRedRight:
	    case IFRedTree:
		break;

	    default:
		break;
	    }
	}
}


/**************************************************************************/
/* LOCAL  **************       PrintReturnUpd      ************************/
/**************************************************************************/
/* PURPOSE: PRINT RETURN SUBGRAPH r'S UPDATE MACROS TO output.            */
/**************************************************************************/

static void PrintReturnUpd( indent, r )
int   indent;
PNODE r;
{
    register PEDGE i;
    register PEDGE b;

    for ( i = r->imp; i != NULL; i = i->isucc ) {
	if ( i->iport == 0 )
	    continue;

	switch ( i->src->type ) {
	    case IFAGather:
		b = i->src->imp->isucc->isucc;

		PrintIndentation( indent );

		fprintf( output, "%sGathUpd%s( %s, ", (b != NULL)? "B" : "",
			 (b != NULL & !IsBasic( i->info->A_ELEM ))? "X" : "",
			 i->info->A_ELEM->tname                           );

		PrintTemp( i );
		fprintf( output, ", " );
		PrintTemp( i->src->imp->isucc );

		if ( b != NULL ) {
		    fprintf( output, ", " );
		    PrintTemp( b );

		    if ( !IsBasic( i->info->A_ELEM ) )
	              fprintf( output, ", %s ", GetFreeName( i->info->A_ELEM ));
                    }

		fprintf( output, " );\n" );
		break;

	    case IFReduceAT:
	    case IFReduceATDVI:
	    case IFReduceATDV:
	    case IFRedLeftAT:
	    case IFRedRightAT:
	    case IFRedTreeAT:
              if ( !(i->src->imp->isucc->isucc->pmark) )
		PrintRCatUpd( indent, i,i->src->imp->isucc->isucc, NULL, TRUE );

	      PrintConsumerModifiers( indent, i->src );
              break;

	    case IFReduce:
	    case IFRedLeft:
	    case IFRedRight:
	    case IFRedTree:
		if ( i->src->gsucc != NULL )
		    break;

		if ( i->src->imp->CoNsT[0] == REDUCE_CATENATE ) {
		    PrintRCatUpd( indent, i, i->src->imp->isucc->isucc,
			          i->src->imp->isucc->isucc->isucc, FALSE );

		    PrintConsumerModifiers( indent, i->src );
		    break;
		    }

		switch ( i->src->imp->CoNsT[0] ) {
                    case REDUCE_LEAST: 
			PrintBasicRed( indent, i, "Min" );
			break;

                    case REDUCE_GREATEST:
                        PrintBasicRed( indent, i, "Max" );
			break;

                    case REDUCE_PRODUCT:
			if ( IsBoolean( i->info ) )
                            PrintBasicRed( indent, i, "And" );
			else
                            PrintBasicRed( indent, i, "Times" );

			break;

                    case REDUCE_SUM:
			if ( IsBoolean( i->info ) )
                            PrintBasicRed( indent, i, "Or" );
			else
                            PrintBasicRed( indent, i, "Plus" );

			break;
		    }

		break;
		
	    case IFAGatherATDVI:
	    case IFAGatherATDV:
	    case IFAGatherAT:
		/* NEW CANN 2/92 SKIP IMPLICIT ITERATION */
		if ( i->src->umark ) {
		  if ( !IsBasic( i->src->imp->isucc->info ) )
		    if ( i->src->imp->isucc->cm != -1 )
		      PrintFreeCall( indent, i->src->imp->isucc );

		  i->src->umark = FALSE;
		  break;
		  }

		if ( i->src->gsucc != NULL )
		    break;

		PrintIndentation( indent );

		if ( r->G_DAD->vmark || r->G_DAD->smark ) {
		    fprintf( output, "VecGathATUpd( " );
		    PrintTemp( r->G_DAD->F_GEN->imp );
		    fprintf( output, ", %s, ", i->info->A_ELEM->tname );
		    }
		else
		    fprintf( output, "GathATUpd( %s, ", i->info->A_ELEM->tname);

		PrintTemp( i );
		fprintf( output, ", " );
		PrintTemp( i->src->imp->isucc );
		fprintf( output, " );\n" );
		break;

	    case IFFinalValueAT:
	    case IFFinalValue:
		if ( i->src->lmark )
		    break;

		PrintIndentation( indent );

		b = i->src->imp->isucc;

		fprintf( output, "%sFvUpd", (b != NULL)? "B" : "" );

		if ( IsBasic( i->info ) )
		  fprintf( output, "( " );
		else { 
		  if ( i->src->imp->cm == -1 || i->src->imp->dmark )
		    fprintf( output, "X( " );
		  else 
		    fprintf( output, "( " );
		  /* else Error2( "DEBUG", "FvUpdX ERROR" ); */
		  }

		PrintTemp( i );
		fprintf( output, ", " );
		PrintTemp( i->src->imp );

		if ( b != NULL ) {
		    fprintf( output, ", " );
		    PrintTemp( b );
		    }

		if ( !IsBasic( i->info ) )
		  if ( i->src->imp->cm == -1 || i->src->imp->dmark )
	            fprintf( output, ", %s ", GetFreeName( i->info ) );

		fprintf( output, " );\n" );
		break;
	    }
	}
}


/**************************************************************************/
/* LOCAL  **************      PrintReturnInit      ************************/
/**************************************************************************/
/* PURPOSE: PRINT RETURN SUBGRAPH r'S INITIALIZATION MACROS TO output.    */
/**************************************************************************/

static void PrintReturnInit( indent, r )
int   indent;
PNODE r;
{
    register PEDGE  i;
    register PNODE  n;
    register PEDGE  e;
    register char  *s;

    for ( i = r->imp; i != NULL; i = i->isucc ) {
	if ( i->iport == 0 )
	    continue;

	switch ( i->src->type ) {
	    case IFAGather:
		PrintIndentation( indent );

		fprintf( output, "DoABld( " );
		PrintTemp( i );
		fprintf( output, ", " );
		PrintTemp( i->src->imp );
		fprintf( output, ", %d );\n", i->sr );
		break;

	    case IFReduce:
	    case IFRedLeft:
	    case IFRedRight:
	    case IFRedTree:
		if ( i->src->imp->CoNsT[0] == REDUCE_CATENATE ) {
		    PrintIndentation( indent );

		    fprintf( output, "DoABld( " );
		    PrintTemp( i );
		    fprintf( output, ", " );
		    PrintTemp( i->src->imp->isucc );
		    fprintf( output, ", %d );\n", i->sr );
		    break;
		    }

		PrintReduceInit( indent, i->src->imp, i );
		break;
		
	    case IFFinalValue:
	    case IFFinalValueAT:
		if ( i->src->lmark || IsBasic( i->info ) )
		    break;

		if ( i->src->imp->cm == -1 || i->src->imp->dmark ) {
		  PrintIndentation( indent );
		  fprintf( output, "InitFvUpdX( " );
		  PrintTemp( i );
		  fprintf( output, " );\n" );
		  }
		/* else Error2( "DEBUG", "InitFvUpdX ERROR" ); */

		break;

	    case IFReduceAT:
	    case IFReduceATDVI:
	    case IFReduceATDV:
	    case IFRedLeftAT:
	    case IFRedRightAT:
	    case IFRedTreeAT:
		if ( r->G_DAD->smark )
		    break;

		s = NULL;

		if ( i->src->imp->isucc->isucc->pmark ) {
		  if ( !(i->src->nmark) )
		    s = "PRedATInit";
		  }
                else
		    s = "RedATInit";

		if ( s == NULL )
		  break;

		PrintIndentation( indent );
		fprintf( output, "%s( ", s );
		PrintTemp( i );
		fprintf( output, ", " );
		PrintTemp( FindImport( i->src, 5 ) );
		fprintf( output, " );\n" );
		break;

	    case IFAGatherATDVI:
	    case IFAGatherATDV:
	    case IFAGatherAT:
		PrintIndentation( indent );

		if ( r->G_DAD->smark ) {
		    fprintf( output, "VecSliceGathATInit( " );
		    PrintTemp( r->G_DAD->F_GEN->imp );
		    fprintf( output, "," );
		    }
		else if ( r->G_DAD->vmark ) {
		    fprintf( output, "VecGathATInit( " );
		    PrintTemp( r->G_DAD->F_GEN->imp );
		    fprintf( output, "," );
		    }
                else
		    fprintf( output, "GathATInit(" );

		fprintf( output, " %s, ", i->info->A_ELEM->tname );
		PrintTemp( i );
		fprintf( output, ", " );
		PrintTemp( FindImport( i->src, 4 ) );
		fprintf( output, " );\n" );
		break;
	    }
	}
}


/**************************************************************************/
/* LOCAL  **************       PrintGenInit        ************************/
/**************************************************************************/
/* PURPOSE: PRINT THE INTIALIZATION MACROS FOR Forall NODE f'S GENERATE   */
/*          SUBGRAPH TO output. ONLY NoOp AND Assgn NODES ARE CONSIDERED. */
/**************************************************************************/

static void PrintGenInit( indent, f )
int   indent;
PNODE f;
{
    register PNODE n;
    register PEDGE e;
    register PEDGE i;
    register int   idx;
	     char  buf[100];

    if ( f->smark ) {
	i = f->F_GEN->imp;

        PrintIndentation( indent );
        PrintTemp( i->src->imp );
        fprintf( output, " = lo;\n" );

        PrintIndentation( indent );
        PrintTemp( i->src->imp->isucc );
        fprintf( output, " = hi;\n" );
	}

    for ( n = f->F_GEN->G_NODES; n != NULL; n = n->nsucc )
	switch ( n->type ) {
	    case IFRangeGenerate:
		break;

	    case IFScatterBufPartitions:
		if ( f->smark )
                    sprintf( buf, "%sSliceBufCpy( %s, ",
			     (f->vmark)? "Vec" : "",
			     n->imp->info->A_ELEM->A_ELEM->tname );
                else if ( n->imp->temp != n->exp->temp )
                    sprintf( buf, "%sBufCpy( ", (f->vmark)? "Vec" : "" );
                else
		    break;

		PrintIndentation( indent );

		fprintf( output, "%s", buf );
		PrintTemp( n->exp );
		fprintf( output, ", " );
		PrintTemp( n->imp );
		fprintf( output, ", " );
		PrintTemp( n->imp->isucc );

		if ( f->smark ) {
		  fprintf( output, ", " );
		  PrintTemp( f->F_GEN->imp );
		  }

		fprintf( output, " );\n" );

		break;

	    case IFAssign:
		if ( IsScatterBufPartitions( n->exp->dst ) ) {
		  if ( !(f->vmark) )
		    PrintAssgn( indent, n->exp, n->imp );

		  break;
                  }

		if ( !(f->smark) )
		  PrintAssgn( indent, n->exp, n->imp );

		break;

	    default:
		break;
	    }
}


/**************************************************************************/
/* LOCAL  **************        PrintGenUpd        ************************/
/**************************************************************************/
/* PURPOSE: PRINT Forall NODE f'S GENERATE UPDATE MACROS TO output.       */
/**************************************************************************/

static void PrintGenUpd( indent, f )
int   indent;
PNODE f;
{
    register PNODE n;
    register PEDGE e;

    for ( n = f->F_GEN->G_NODES; n != NULL; n = n->nsucc )
        switch ( n->type ) {
	    case IFScatterBufPartitions:
		PrintIndentation( indent );

		fprintf( output, "%sOptShiftB( %s, ", 
			 (f->vmark)? "Vec" : "",
			 n->exp->info->A_ELEM->A_ELEM->tname );
		PrintTemp( n->exp );
		fprintf( output, ", " );
		PrintTemp( n->exp );
		fprintf( output, ", " );
		PrintTemp( n->imp->isucc );
		fprintf( output, " );\n" );
		break;

	    case IFRangeGenerate:
		if ( (alliantfx && (!f->vmark)) || 
		     (!(n == f->F_GEN->imp->src)) ) {
		  PrintIndentation( indent );
		  PrintTemp( n->exp );
		  fprintf( output, "++;\n" );
		  }

		break;

	    default:
		break;
	    }
}


/**************************************************************************/
/* LOCAL  **************       PrintGenRapUp       ************************/
/**************************************************************************/
/* PURPOSE: PRINT Forall NODE f'S GENERATE RAP-UP MACROS TO output.       */
/**************************************************************************/

static void PrintGenRapUp( indent, f )
int   indent;
PNODE f;
{
}


/**************************************************************************/
/* LOCAL  **************      PrintGenControl      ************************/
/**************************************************************************/
/* PURPOSE: PRINT Forall NODE f's LOOP CONTROL MACROS TO output.          */
/**************************************************************************/

static void PrintGenControl( indent, f )
int   indent;
PNODE f;
{
    register PNODE  n;
    register PNODE  nn;
    register PEDGE  i;
    register PEDGE  e;
    register PNODE  g;
    register char  *p;
	     char   buf[200];

    n = f->F_GEN->imp->src;
    g = f->F_BODY;

    if ( IsRangeGenerate( n ) ) {

      if ( g->flps != NULL ) {
        if ( g->flps[ARITHMETICS] > 0 ) {
          fprintf( output, "IncFlopCountA(" );
          fprintf( output, "(((double)%d)*((double)", g->flps[ARITHMETICS] );
          fprintf( output, "(((" );
          PrintTemp( n->imp->isucc );
          fprintf( output, "-" );
          PrintTemp( n->imp );
          fprintf( output, "+1) < 0)? 0 : " );
          PrintTemp( n->imp->isucc );
          fprintf( output, "-" );
          PrintTemp( n->imp );
          fprintf( output, "+1))));\n" );
          }
        if ( g->flps[LOGICALS] > 0 ) {
          fprintf( output, "IncFlopCountL(" );
          fprintf( output, "(((double)%d)*((double)", g->flps[LOGICALS] );
          fprintf( output, "(((" );
          PrintTemp( n->imp->isucc );
          fprintf( output, "-" );
          PrintTemp( n->imp );
          fprintf( output, "+1) < 0)? 0 : " );
          PrintTemp( n->imp->isucc );
          fprintf( output, "-" );
          PrintTemp( n->imp );
          fprintf( output, "+1))));\n" );
          }
        if ( g->flps[INTRINSICS] > 0 ) {
          fprintf( output, "IncFlopCountI(" );
          fprintf( output, "(((double)%d)*((double)", g->flps[INTRINSICS] );
          fprintf( output, "(((" );
          PrintTemp( n->imp->isucc );
          fprintf( output, "-" );
          PrintTemp( n->imp );
          fprintf( output, "+1) < 0)? 0 : " );
          PrintTemp( n->imp->isucc );
          fprintf( output, "-" );
          PrintTemp( n->imp );
          fprintf( output, "+1))));\n" );
          }

        g->flps = NULL;
        }


	if ( f->vmark ) {
	  if ( alliantfx ) {
	    for ( i = f->imp; i != NULL; i = i->isucc )
	      if ( IsBuffer( i->info ) ) {
	        PrintVectorTemp( output, i );
	        e = FindExport( f->F_RET, i->iport );
	        fprintf( output, " = (%s *) ", i->info->A_ELEM->A_ELEM->tname );
	        PrintTemp( e->dst->exp );
	        fprintf( output, ";\n" );
	        }

	    PrintVECTOR();
	    }

	  if ( cRay ) {
	    if ( IsIvdepOk( f->F_BODY ) )
	      PrintVECTOR();
            else
              fprintf( stderr, "OSC INTERNAL WARNING: IVDEP FAILURE %s\n", 
		       GetSisalInfo( f, buf )                           );
            }

	  PrintASSOC();

	  if ( cRay && fvc )
	    fprintf( output, "#line %d \"%s\"\n", 
		     (f->line <= 0)? 1 : f->line,
		     (f->file == NULL)? "UNKNOWN_FILE.SIS" : f->file );

	  if ( alliantfx )
	    for ( nn = f->F_RET->G_NODES; nn != NULL; nn = nn->nsucc )
	      if ( nn->type == IFAGatherAT || 
		   nn->type == IFAGatherATDV ||
		   nn->type == IFAGatherATDVI ) {
	        i = FindImport( nn, 4 );
		PrintSAFE(p = PrintVectorTemp( NULL, FindImport(f,i->eport) ));
		/* free( p ); */
	        }
          }
        /* NOVECTOR sometimes breaks fxc */
        else if ( f->line == 9999999 && (!alliantfx) )
	  PrintNOVECTOR();

	if ( (!alliantfx) || f->vmark ) {
	  PrintIndentation( indent );
	  fprintf( output, "for ( " );

	  if ( alliantfx ) {
	    PrintTemp( n->imp );
	    fprintf( output, " = " );
	    PrintTemp( n->imp );
	    }

	  fprintf( output, "; " );
	  PrintTemp( n->imp );
	  fprintf( output, " <= " );
	  PrintTemp( n->imp->isucc );
	  fprintf( output, "; " );
	  PrintTemp( n->imp );
	  fprintf( output, "++ ) {\n" );
        } else {
	  PrintIndentation( indent );
	  fprintf( output, "while ( " );
	  PrintTemp( n->imp );
	  fprintf( output, " <= " );
	  PrintTemp( n->imp->isucc );
	  fprintf( output, ") {\n" );
	  }
    } else {
	PrintIndentation( indent );
	fprintf( output, "for ( ;; ) {\n" );
	}
}


static void PrintVecNodeImport( indent, i )
int   indent;
PEDGE i;
{
  extern void PrintVecNode();

  if ( IsConst( i ) ) {
    fprintf( output, "%s", i->CoNsT );
    return;
    }

  if ( i->temp != NULL ) {
    PrintTemp( i );
    return;
    }

  PrintVecNode( indent, i->src );
}

static int ncnt = 0;

static void PrintVecNode( indent, n )
int   indent;
PNODE n;
{
  register char op;

  switch ( n->type ) {
    case IFPlus:
      op = '+'; goto PrintIt;
    case IFMinus:
      op = '-'; goto PrintIt;
    case IFTimes:
      op = '*'; goto PrintIt;
    case IFDiv:
      op = '/';

PrintIt:
      if ( ncnt++ > 6 ) {
	 fprintf( output, "\n" );
         PrintIndentation( indent + 2 );
	 ncnt = 0;
	 }

      fprintf( output, "(" );
      PrintVecNodeImport( indent,  n->imp );
      fprintf( output, " %c ", op );

      if ( IsDivByZero( n ) )
	fprintf( output, "DivByZero()" );
      else
        PrintVecNodeImport( indent, n->imp->isucc );
      fprintf( output, ")" );
      break;

    case IFNeg:
      if ( ncnt++ > 6 ) {
	 fprintf( output, "\n" );
         PrintIndentation( indent + 2 );
	 ncnt = 0;
	 }

      fprintf( output, "(-(" );
      PrintVecNodeImport( indent, n->imp );
      fprintf( output, "))" );
      break;

    case IFDouble:
      if ( ncnt++ > 6 ) {
	 fprintf( output, "\n" );
         PrintIndentation( indent + 2 );
	 ncnt = 0;
	 }

      fprintf( output, "((double)" );
      PrintVecNodeImport( indent, n->imp );
      fprintf( output, ")" );
      break;

    case IFTrunc:
      if ( ncnt++ > 6 ) {
	 fprintf( output, "\n" );
         PrintIndentation( indent + 2 );
	 ncnt = 0;
	 }

      fprintf( output, "((int)" );
      PrintVecNodeImport( indent, n->imp );
      fprintf( output, ")" );
      break;

    case IFSingle:
      if ( ncnt++ > 6 ) {
	 fprintf( output, "\n" );
         PrintIndentation( indent + 2 );
	 ncnt = 0;
	 }

      fprintf( output, "((float)" );
      PrintVecNodeImport( indent, n->imp );
      fprintf( output, ")" );
      break;

    case IFAbs:
      if ( ncnt++ > 6 ) {
	 fprintf( output, "\n" );
         PrintIndentation( indent + 2 );
	 ncnt = 0;
	 }

      if (n->exp->info->type == IF_INTEGER)
        fprintf( output, "abs(" );
      else
        fprintf( output, "fabs(" );

      PrintVecNodeImport( indent, n->imp );
      fprintf( output, ")" );
      break;

    case IFOptAElement:
      if ( ncnt++ > 6 ) {
	 fprintf( output, "\n" );
         PrintIndentation( indent + 2 );
	 ncnt = 0;
	 }

      PrintTemp( FindImport( n->imp->src->G_DAD, n->imp->eport ) );
      fprintf( output, "[" );
      PrintVecNodeImport( indent, n->imp->isucc );
      fprintf( output, "]" );
      break;

    default:
      Error2( "PrintVecNode", "ILLEGAL VECTOR NODE\n" );
      break;
    }
}


static void PrintVecUpd( indent, i, f )
int   indent;
PEDGE i;
PNODE f;
{
  register PEDGE e;

  if ( IsConst( i ) )
    fprintf( output, "%s", i->CoNsT );
  else if ( (e=FindImport( f->F_BODY, i->eport)) == NULL )
    PrintTemp( i );
  else
    PrintVecNodeImport( indent, e );
}


static void PrintVecBody( indent, f )
int   indent;
PNODE f;
{
  register PNODE n;
  register PEDGE e;
  register PEDGE i;
  register char  op;

  for ( n = f->F_BODY->G_NODES; n != NULL; n = n->nsucc )
    if ( n->exp->temp != NULL ) {
      ncnt = 0;
      PrintIndentation( indent );
      PrintTemp( n->exp );
      fprintf( output, " = " );
      PrintVecNode( indent, n );
      fprintf( output, ";\n" );
      }

  for ( n = f->F_RET->G_NODES; n != NULL; n = n->nsucc )
    switch ( n->type ) {
      case IFReduce:
      case IFRedLeft:
      case IFRedRight:
      case IFRedTree:
        switch ( n->imp->CoNsT[0] ) {
          case REDUCE_LEAST: 
	    op = '>'; goto PrintIt1;
          case REDUCE_GREATEST:
	    op = '<';
PrintIt1:
	    if ( !IsConst( n->imp->isucc->isucc ) )
	      if ( IsImport( n->exp->dst->G_DAD->F_BODY, 
			     n->imp->isucc->isucc->eport ) ) {
	      PrintIndentation( indent );
	      PrintTemp( n->imp->isucc->isucc );
	      fprintf( output, " = " );
	      PrintVecUpd( indent, n->imp->isucc->isucc, f );
	      fprintf( output, ";\n" );
	      }

            PrintIndentation( indent );
            fprintf( output, "if ( " );
            PrintTemp( n->exp );
            fprintf( output, " %c ", op );
            PrintTemp( n->imp->isucc->isucc );
            fprintf( output, " ) " );
            PrintTemp( n->exp );
            fprintf( output, " = " );
            PrintTemp( n->imp->isucc->isucc );
            fprintf( output, ";\n" );
            break;
      
          case REDUCE_PRODUCT:
	    op = '*'; goto PrintIt2;
          case REDUCE_SUM:
            op = '+';
PrintIt2:
	    ncnt =0;
            PrintIndentation( indent );
            PrintTemp( n->exp );
            fprintf( output, " %c= ", op );

	    PrintVecUpd( indent, n->imp->isucc->isucc, f );

            fprintf( output, ";\n" );
            break;
      
          default:
            Error2( "PrintVecBody", "ILLEGAL VECTOR RETURN NODE\n" );
            break;
          }
      
        break;

      case IFAGatherATDVI:
      case IFAGatherATDV:
      case IFAGatherAT:
	ncnt =0;
        PrintIndentation( indent );
	i = FindImport( n, 4 );
        PrintVectorTemp( output, FindImport( f, i->eport ) );
        fprintf( output, "[" );
        PrintTemp( f->F_GEN->imp );
        fprintf( output, " ] = " );

	PrintVecUpd( indent, n->imp->isucc, f );

        fprintf( output, ";\n" );
        break;

      default:
        Error2( "PrintVecBody", "ILLEGAL VECTOR RETURN NODE\n" );
        break;
      }
}


#define GENF_NODE_THRESHOLD 4
#define GENF_IMP_THRESHOLD  10

static int hcnt = 0;

static void PrintHTemp( e )
PEDGE e;
{
    register PTEMP t;

    if ( IsConst( e ) ) {
        fprintf( hyfd, "(%s)", e->CoNsT );
	return;
	}

    if ( (t = e->temp) == NULL ) {
	if ( e->src->type == IFAIndexMinus ) {
	  PrintHTemp( e->src->imp );

	  if ( IsConst( e->src->imp->isucc ) )
	    if ( atoi( e->src->imp->isucc->CoNsT ) == 0 )
	      return;

	  fprintf( hyfd, "-" );
	  PrintHTemp( e->src->imp->isucc );
	  return;
	  }

	if ( e->src->type == IFAIndexPlus ) {
	  PrintHTemp( e->src->imp );

	  if ( IsConst( e->src->imp->isucc ) )
	    if ( atoi( e->src->imp->isucc->CoNsT ) == 0 )
	      return;

	  fprintf( hyfd, "+" );
	  PrintHTemp( e->src->imp->isucc );
	  return;
	  } 

	Error1( "PrintHTemp: temp == NULL" );
	}

    switch ( e->info->type ) {
      case IF_REAL:
	fprintf( hyfd, "R" );
	break;

      case IF_DOUBLE:
	fprintf( hyfd, "D" );
	break;

      case IF_INTEGER:
	fprintf( hyfd, "I" );
	break;

      default:
	break;
      }

    fprintf( hyfd, "%s", e->temp->name );
}


static char *GetHybridTypeProlog( i )
PEDGE i;
{
  switch( i->info->type ) {
    case IF_ARRAY:
      switch( i->info->A_ELEM->type ) {
	case IF_INTEGER:
	  return( "integer" );

	case IF_REAL:
	  return( "real*4" );

	case IF_DOUBLE:
	  return( "real*8" );

	default:
	  Error2( "GetHybridTypeProlog", "ILLEGAL ARRAY COMPONENT TYPE!!!" );
	}

      break;

    case IF_PTR_INTEGER:
    case IF_INTEGER:
      return( "integer" );

    case IF_PTR_REAL:
    case IF_REAL:
      return( "real*4" );

    case IF_PTR_DOUBLE:
    case IF_DOUBLE:
      return( "real*8" );

    default:
      Error2( "GetHybridTypeProlog", "ILLEGAL TYPE ENCOUNTERED!!!" );
    }
}


static void PrintHybridGraph( f, g, crod )
PNODE f;
PNODE g;
PEDGE crod;
{
  register PNODE  n;
  register char  *op;

  for ( n = g->G_NODES; n != NULL; n = n->nsucc ) {
    switch ( n->type ) {
      case IFAssign:
        fprintf( hyfd, "       " );
	PrintHTemp( n->exp );
	fprintf( hyfd, " = " );
	PrintHTemp( n->imp );
	fprintf( hyfd, "\n" );
	break;

      case IFGreat:
      case IFGreatEqual:
      case IFLess:
      case IFLessEqual:
      case IFEqual:
      case IFNotEqual:
        break;

      case IFSelect:
        fprintf( hyfd, "       if ( " );
	PrintHTemp( n->usucc->imp );

        switch ( n->usucc->type ) {
          case IFGreat:
	    fprintf( hyfd, " .gt. " );
	    break;

          case IFGreatEqual:
	    fprintf( hyfd, " .ge. " );
	    break;

          case IFLess:
	    fprintf( hyfd, " .lt. " );
	    break;

          case IFLessEqual:
	    fprintf( hyfd, " .le. " );
	    break;

          case IFEqual:
	    fprintf( hyfd, " .eq. " );
	    break;

          case IFNotEqual:
	    fprintf( hyfd, " .ne. " );
	    break;

          default:
	    break;
          }

	PrintHTemp( n->usucc->imp->isucc );
	fprintf( hyfd, " ) then\n" );

        PrintHybridGraph( f, n->S_CONS, crod );

        fprintf( hyfd, "       else\n" );

        PrintHybridGraph( f, n->S_ALT, crod );

        fprintf( hyfd, "       endif\n" );
        break;

      case IFLeast:
	op = "min";
	goto DoReduction1;
      case IFGreatest:
	op = "max";
DoReduction1:
        fprintf( hyfd, "       " );
	PrintHTemp( n->gsucc->exp );
	fprintf( hyfd, " = %s( ", op );
	PrintHTemp( n->gsucc->exp );
	fprintf( hyfd, ", " );
	PrintHTemp( n->imp );
	fprintf( hyfd, " )\n" );
	break;

      case IFProduct:
	op = " * ";
	goto DoReduction2;
      case IFSum:
        op = " + ";
DoReduction2:
        fprintf( hyfd, "       " );
	PrintHTemp( n->gsucc->exp );
	fprintf( hyfd, " = " );
	PrintHTemp( n->gsucc->exp );
	fprintf( hyfd, "%s", op );
	PrintHTemp( n->imp );
	fprintf( hyfd, "\n" );
	break;

      case IFAStore:
        fprintf( hyfd, "       " );
	PrintHTemp( n->gsucc->exp );
	fprintf( hyfd, "(" );

	if ( f->vmark || f->smark )
	  PrintHTemp( crod );
	else
	  fprintf( hyfd, "iii" );

	fprintf( hyfd, ") = " );
	PrintHTemp( n->imp );
	fprintf( hyfd, "\n" );
	break;

      case IFCall:
        fprintf( hyfd, "       " );
	PrintHTemp( n->exp );
	fprintf( hyfd, " = %s(", n->imp->CoNsT );
	PrintHTemp( n->imp->isucc );
	fprintf( hyfd, ")\n" );
	break;

      case IFSingle:
	op = "real";
	goto DoMop;
      case IFDouble:
        op = "dble";
	goto DoMop;
      case IFTrunc:
        op = "int";
	goto DoMop;
      case IFNeg:
	op = "-";
DoMop:
        fprintf( hyfd, "       " );
	PrintHTemp( n->exp );
	fprintf( hyfd, " = %s(", op );
	PrintHTemp( n->imp );
	fprintf( hyfd, ")\n" );
	break;

      case IFPlus:
	op = " + ";
	goto DoDyadic;
      case IFMinus:
	op = " - ";
	goto DoDyadic;
      case IFTimes:
	op = " * ";
	goto DoDyadic;
      case IFDiv:
	op = " / ";
DoDyadic:
        fprintf( hyfd, "       " );
	PrintHTemp( n->exp );
	fprintf( hyfd, " = " );
	PrintHTemp( n->imp );
	fprintf( hyfd, "%s", op );
	PrintHTemp( n->imp->isucc );
	fprintf( hyfd, "\n" );
	break;
 

      case IFMod:
	op = "mod";
	goto DoPrefix;
      case IFMin:
        op = "min";
	goto DoPrefix;
      case IFMax:
        op = "max";
DoPrefix:
        fprintf( hyfd, "       " );
	PrintHTemp( n->exp );
	fprintf( hyfd, " = %s(", op );
	PrintHTemp( n->imp );
	fprintf( hyfd, ", " );
	PrintHTemp( n->imp->isucc );
	fprintf( hyfd, " )\n" );
	break;

      case IFAbs:
        fprintf( hyfd, "       " );
	PrintHTemp( n->exp );
	fprintf( hyfd, " = " );
	fprintf( hyfd, "abs( " );
	PrintHTemp( n->imp );
	fprintf( hyfd, " ) \n"  );
	break;


      case IFAIndexPlus:
      case IFAIndexMinus:
	break;

      case IFOptAElement:
        fprintf( hyfd, "       " );
	PrintHTemp( n->exp );
	fprintf( hyfd, " = " );
	PrintHTemp( n->imp );
	fprintf( hyfd, "(" );
	PrintHTemp( n->imp->isucc );
	fprintf( hyfd, ")\n" );
	break;

      default:
	Error2( "PrintHybridGraph", "ILLEGAL BODY NODE!!!" );
      }
    }
}


static void PrintHybrid( f )
PNODE f;
{
  register PEDGE  i;
  register char  *nm;
  register PEDGE  crod;
           char   buf[100];

  sprintf( buf, "h%d%3.3s", ++hcnt, hybrid );
  nm = BindInterfaceName( buf, FOR_FORTRAN, ' ' );

  crod = f->F_GEN->imp;


  /* PRINT THE HYBRID CALL */

  fprintf( output, "{\n" );
  fprintf( output, "  int lo1,lo2; \n" );

  for ( i = f->imp; i != NULL; i = i->isucc ) {
    if ( !IsExport( f->F_BODY, i->iport ) )
      continue;
    if ( !IsArithmetic( i->info ) )
      continue;

    fprintf( output, "  %s fin%d;\n", i->info->tname, i->iport );
    }

  for ( i = f->F_RET->imp; i != NULL; i = i->isucc ) {
    if ( !IsArithmetic( i->info ) )
      continue;

    fprintf( output, "  %s fout%d;\n", i->info->tname, i->iport );
    }

  i = crod->src->imp;

  fprintf( output, "  lo1 = " );
  PrintTemp( i );
  fprintf( output, ";\n" );

  fprintf( output, "  lo2 = " );
  PrintTemp( i->isucc );
  fprintf( output, ";\n" );

  for ( i = f->imp; i != NULL; i = i->isucc ) {
    if ( !IsExport( f->F_BODY, i->iport ) )
      continue;
    if ( !IsArithmetic( i->info ) )
      continue;

    fprintf( output, "  fin%d = ", i->iport );
    PrintTemp( i );
    fprintf( output, ";\n" );
    }

  for ( i = f->F_RET->imp; i != NULL; i = i->isucc ) {
    if ( !IsArithmetic( i->info ) )
      continue;

    fprintf( output, "  fout%d = ", i->iport );
    PrintTemp( i );
    fprintf( output, ";\n" );
    }

  fprintf( output, "  %7.7s( &lo1, &lo2", nm );

  for ( i = f->imp; i != NULL; i = i->isucc ) {
    if ( !IsExport( f->F_BODY, i->iport ) )
      continue;

    if ( IsArithmeticPtr( i->info ) ) {
      fprintf( output, ", " );
      PrintTemp( i );
      fprintf( output, "+1" );
      continue;
      }

    fprintf( output, ", &fin%d", i->iport );
    }

  for ( i = f->F_RET->imp; i != NULL; i = i->isucc ) {
    if ( IsArithmetic( i->info ) ) {
      fprintf( output, ", &fout%d", i->iport );
      continue;
      }

    fprintf( output, ", ((%s*)", i->info->A_ELEM->tname );
    PrintTemp( i );
    fprintf( output, ")+1" );
    }

  fprintf( output, " );\n" );

  for ( i = f->F_RET->imp; i != NULL; i = i->isucc ) {
    if ( !IsArithmetic( i->info ) )
      continue;

    fprintf( output, "  " );
    PrintTemp( i );
    fprintf( output, " = fout%d;\n", i->iport );
    }

  fprintf( output, "}\n" );

  /* PRINT THE HYBRID SUBROUTINE */

  fprintf( hyfd, "\n       subroutine %7.7s( lo,hi\n", buf );

  for ( i = f->imp; i != NULL; i = i->isucc ) {
    if ( !IsExport( f->F_BODY, i->iport ) )
      continue;

    fprintf( hyfd, "     *," );
    PrintHTemp( i );
    fprintf( hyfd, "\n" );
    }

  for ( i = f->F_RET->imp; i != NULL; i = i->isucc ) {
    fprintf( hyfd, "     *," );
    PrintHTemp( i );
    fprintf( hyfd, "\n" );
    }

  fprintf( hyfd, "     *)\n" );

  fprintf( hyfd, "      implicit integer (I)\n" );
  fprintf( hyfd, "      implicit real*4  (R)\n" );
  fprintf( hyfd, "      implicit real*8  (D)\n" );

  fprintf( hyfd, "      integer lo,hi,iii\n" );

  for ( i = f->imp; i != NULL; i = i->isucc ) {
    if ( !IsExport( f->F_BODY, i->iport ) )
      continue;

    if ( IsArithmetic( i->info ) )
      continue;

    fprintf( hyfd, "      %s ", GetHybridTypeProlog( i ) );
    PrintHTemp( i );
    fprintf( hyfd, "(*)\n" );
    }

  for ( i = f->F_RET->imp; i != NULL; i = i->isucc ) {
    if ( IsArithmetic( i->info ) )
      continue;

    fprintf( hyfd, "      %s ", GetHybridTypeProlog( i ) );
    PrintHTemp( i );
    fprintf( hyfd, "(*)\n" );
    }

  if ( !(f->vmark || f->smark) )
    fprintf( hyfd, "\n      iii = 0\n" );

  if ( f->vmark && cRay )
    fprintf( hyfd, "CDIR$ IVDEP" );

  fprintf( hyfd, "\n      do 100 " );
  PrintHTemp( crod );
  fprintf( hyfd, " = lo,hi\n" );

  PrintHybridGraph( f, f->F_BODY, crod );

  if ( !(f->vmark || f->smark) )
    fprintf( hyfd, "       iii = iii + 1\n" );

  fprintf( hyfd, " 100  continue\n\n" );


  fprintf( hyfd, "      return\n" );
  fprintf( hyfd, "      end\n" );
}

static int IsHybridGraph( g, outer )
PNODE g;
int   outer;
{
  register PNODE n;
  register PEDGE i;
  register PNODE f;
  register int   c;

  for ( c = 0, n = g->G_NODES; n != NULL; n = n->nsucc ) {
    switch ( n->type ) {
      case IFAssign:
        if ( !IsArithmetic( n->imp->info ) )
	  return( FALSE );

        break;

      case IFGreat:
      case IFGreatEqual:
      case IFLess:
      case IFLessEqual:
      case IFEqual:
      case IFNotEqual:
        if ( !IsArithmetic( n->imp->info ) )
	  return( FALSE );

	if ( n->exp != NULL )
	  return( FALSE );

        c++;
        break;
  
      case IFSelect:
        if ( n->usucc == NULL )
          return( FALSE );
  
        switch ( n->usucc->type ) {
          case IFGreat:
          case IFGreatEqual:
          case IFLess:
          case IFLessEqual:
          case IFEqual:
          case IFNotEqual:
	    break;
  
          default:
	    return( FALSE );
          }
  
	for ( i = n->S_ALT->imp; i != NULL; i = i->isucc )
          if ( !IsArithmetic( i->info ) )
            if ( !IsArithmeticPtr( i->info ) )
	      return( FALSE );

	for ( i = n->S_CONS->imp; i != NULL; i = i->isucc )
          if ( !IsArithmetic( i->info ) )
            if ( !IsArithmeticPtr( i->info ) )
	      return( FALSE );

	for ( i = n->imp; i != NULL; i = i->isucc )
          if ( !IsArithmetic( i->info ) )
            if ( !IsArithmeticPtr( i->info ) )
	      return( FALSE );

        if ( IsHybridGraph( n->S_ALT, FALSE ) )
	  if ( IsHybridGraph( n->S_CONS, FALSE ) ) {
	    c++;
	    break;
	    }
  
        return( FALSE );

      case IFCall:
	if ( n->exp == NULL )
	  return( FALSE );

	if ( (f = FindFunction( n->imp->CoNsT )) == NULL )
	  Error2( "IsHybridGraph", "FindFunction FAILED!!!" );

	if ( !IsIntrinsic( f ) )
	  return( FALSE );

	if ( strcmp( n->imp->CoNsT, "sin" ) == 0 )
	  goto DoIntrinsic;
	if ( strcmp( n->imp->CoNsT, "cos" ) == 0 )
	  goto DoIntrinsic;
	if ( strcmp( n->imp->CoNsT, "tan" ) == 0 )
	  goto DoIntrinsic;
	if ( strcmp( n->imp->CoNsT, "asin" ) == 0 )
	  goto DoIntrinsic;
	if ( strcmp( n->imp->CoNsT, "acos" ) == 0 )
	  goto DoIntrinsic;
	if ( strcmp( n->imp->CoNsT, "atan" ) == 0 )
	  goto DoIntrinsic;
	if ( strcmp( n->imp->CoNsT, "sqrt" ) == 0 )
	  goto DoIntrinsic;

        return( FALSE );
DoIntrinsic:
        if ( !(IsReal( n->imp->isucc->info ) || 
	       IsDouble( n->imp->isucc->info )) )
	  return( FALSE );

	break;

      case IFSum:
      case IFSingle:
      case IFDouble:
      case IFTrunc:
      case IFNeg:
      case IFAStore:
      case IFLeast:
      case IFGreatest:
      case IFProduct:
        if ( !IsArithmetic( n->imp->info ) )
	  return( FALSE );

	break;

      case IFPlus:
      case IFMinus:
      case IFTimes:
	if ( n->imp->info->type != IF_INTEGER )
	  c++;

	if ( !IsArithmetic( n->imp->info ) )
	  return( FALSE );

	break;

      case IFMod:
      case IFMin:
      case IFMax:
      case IFAbs:
      case IFDiv:
	if ( !IsArithmetic( n->imp->info ) )
	  return( FALSE );

	c++;
	break;

      case IFAIndexPlus:
      case IFAIndexMinus:
	break;

      case IFOptAElement:
	if ( !IsArithmeticPtr( n->imp->info ) )
	  return( FALSE );

	break;

      default:
	return( FALSE );
      }
    }

  if ( outer )
    if ( c >= GENF_NODE_THRESHOLD )
      return( TRUE );

  return( FALSE );
}


static int IsHybridCandidate( f )
PNODE f;
{
  register PNODE n;
  register PNODE sg;
  register PEDGE e;
  register PEDGE i;
  register int   c;
  register PTEMP t;

  if ( f->F_GEN->imp->isucc != NULL )
    return( FALSE );
  if ( !IsRangeGenerate( f->F_GEN->imp->src ) )
    return( FALSE );

  for ( n = f->F_RET->G_NODES; n != NULL; n = n->nsucc ) {
    if ( n->gsucc == NULL )
      return( FALSE );

    switch ( n->gsucc->type ) {
      case IFAStore:
      case IFLeast:
      case IFGreatest:
      case IFProduct:
      case IFSum:
	break;

      default:
        return( FALSE );
      }
    }

  for ( e = f->F_BODY->exp; e != NULL; e = e->esucc ) 
    if ( !IsArithmetic( e->info ) )
      if ( !IsArithmeticPtr( e->info ) )
	return( FALSE );

  for ( c = 0, i = f->imp; i != NULL; i = i->isucc ) {

    if ( IsConst( i ) )
      return( FALSE );

    /* IS IT A FRAME REFERENCE??? IF SO, ABORT!!! */
    if ( IsExport( f->F_BODY, i->iport ) ) {
      c++;

      if ( (t = i->temp) == NULL )
        return( FALSE );

      if ( IsFunction( t->info ) )
        return( FALSE );
      }
    }

  if ( c > GENF_IMP_THRESHOLD )
    return( FALSE );

  for ( i = f->F_BODY->imp; i != NULL; i = i->isucc ) 
    if ( !IsArithmetic( i->info ) )
      if ( !IsArithmeticPtr( i->info ) )
	return( FALSE );

  if ( !IsHybridGraph( f->F_BODY, TRUE ) )
    return( FALSE );

  return( TRUE );
}

/**************************************************************************/
/* GLOBAL **************        PrintForall        ************************/
/**************************************************************************/
/* PURPOSE: PRINT Forall NODE f TO output. THIS ROUTINE HANDLES BOTH      */
/*          SLICED AND NONSLICED FORMS.                                   */
/**************************************************************************/

void PrintForall( indent, f )
int   indent;
PNODE f;
{
    PrintProducerModifiers( indent, f->F_GEN );
    PrintGenInit( indent, f );

    PrintReturnInit( indent, f->F_RET ); /* ONCE WAS THE FIRST CALL */

    if ( hybrid != NULL )
      if ( IsHybridCandidate( f ) ) {
        PrintHybrid( f );

	if ( info )
          fprintf( stderr, "Hybrid Loop: [%s,%s,%d]\n", 
		   f->funct, f->file, f->line );

	goto MoveOn;
	}

    PrintGenControl( indent, f );
    PrintProducerModifiers( indent + 2, f->F_BODY );

    if ( f->vmark && alliantfx )
      PrintVecBody( indent + 2, f );
    else
      PrintGraph( indent + 2, f->F_BODY );

    if ( !(f->vmark && alliantfx) ) {
      PrintProducerModifiers( indent + 2, f->F_RET );
      PrintReturnUpd( indent + 2, f->F_RET );
      PrintConsumerModifiers( indent + 2, f->F_RET );
      PrintConsumerModifiers( indent + 2, f->F_BODY );
      PrintConsumerModifiers( indent + 2, f->F_GEN  );
      PrintGenUpd( indent + 2, f );
      }

    PrintIndentation( indent + 2 );
    fprintf( output, "}\n" );

MoveOn:
    PrintReturnRapUp( indent, f->F_RET );
    PrintGenRapUp( indent, f );
    PrintConsumerModifiers( indent, f );
}


/**************************************************************************/
/* GLOBAL **************         PrintLoop         ************************/
/**************************************************************************/
/* PURPOSE: PRINT LOOP NODE l (LoopA OR LoopB, TASK OR NON-TASK) TO       */
/*          output.                                                       */
/**************************************************************************/

void PrintLoop( indent, l )
int   indent;
PNODE l;
{
    register PEDGE i;
    register PEDGE ii;

    PrintProducerModifiers( indent, l->L_INIT );
    PrintReturnInit( indent, l->L_RET );
    PrintGraph( indent, l->L_INIT );

    /* PRINT RETURN UPDATE FOR IMPLICT FIRST ITERATION */
    PrintProducerModifiers( indent + 2, l->L_RET );
    PrintReturnUpd( indent + 2, l->L_RET );
    PrintConsumerModifiers( indent + 2, l->L_RET );

    /* PRINT LOOP CONTROL HEADER */
    PrintIndentation( indent );

    if ( IsLoopB( l ) ) {
	if ( AreAllUnitFanout( l->L_TEST ) ) {
          fprintf( output, "for ( ; " );
	  PrintLoopTest( l->L_TEST->imp );
          fprintf( output, "; ) {\n" );
	} else {
            fprintf( output, "for ( ;; ) {\n" );
	    PrintGraph( indent + 2, l->L_TEST );
	    PrintIndentation( indent + 2 );
	    fprintf( output, "if ( !" );
	    PrintTemp( l->L_TEST->imp );
	    fprintf( output, " ) break;\n" );
	    }
	}
    else
	fprintf( output, "do {\n" );

    /* PRINT LOOP BODY */
    PrintProducerModifiers( indent + 2, l->L_BODY );
    PrintGraph( indent + 2, l->L_BODY );

    /* UPDATE LOOP CARRIED TEMPORARIES: FIRST DEALLOCATING OLD AGGREGATES */

    for ( i = l->L_BODY->imp; i != NULL; i = i->isucc ) {
        if ( IsBasic( i->info ) )
	    continue;

	if ( i->cm != -1 && (!(i->dmark)) )
	    continue;

	if ( i->iport == 0 )
	    PrintFreeCall( indent+2, i );
	else
	    PrintFreeCall( indent+2, FindImport( l->L_INIT, i->iport ) );
	}

    for ( i = l->L_BODY->imp; i != NULL; i = i->isucc ) {
	if ( i->iport == 0 )
	    continue;

        if ( IsConst( i ) )
	    continue;

        if ( (ii = FindImport( l->L_INIT, i->iport )) == NULL )     /* T */
	    continue;

	if ( ii->temp == i->temp )
	    continue;

	if ( !IsSGraph( i->src ) )
	    continue;

	PrintAssgn( indent + 2, ii, i );
	}

    for ( i = l->L_BODY->imp; i != NULL; i = i->isucc ) {
	if ( i->iport == 0 )
	    continue;

        if ( IsConst( i ) )
	    continue;

	if ( IsSGraph( i->src ) )
	    continue;

        if ( (ii = FindImport( l->L_INIT, i->iport )) == NULL )     /* T */
	    continue;

	if ( ii->temp == i->temp )
	    continue;

	PrintAssgn( indent+2, ii, i );
	}

    for ( i = l->L_BODY->imp; i != NULL; i = i->isucc )
	if ( IsConst( i ) )
	    PrintAssgn( indent+2, FindImport( l->L_INIT, i->iport ), i );

    /* PRINT RETURN UPDATE FOR BODY EXECUTION */
    PrintProducerModifiers( indent+2, l->L_RET );
    PrintReturnUpd( indent+2, l->L_RET );
    PrintConsumerModifiers( indent+2, l->L_RET );

    /* PRINT LOOP CONTINUATION TEST FOR LoopA NODES */
    if ( IsLoopA( l ) ) {
	if ( AreAllUnitFanout( l->L_TEST ) ) {
	    PrintIndentation( indent );
	    fprintf( output, "} while ( " );
	    PrintLoopTest( l->L_TEST->imp );
	    fprintf( output, " );\n" );
	} else {
	    PrintGraph( indent+2, l->L_TEST );
	    PrintIndentation( indent );
	    fprintf( output, "} while ( " );
	    PrintTemp( l->L_TEST->imp );
	    fprintf( output, " );\n" );
	    }
    } else {
      PrintIndentation( indent+2 );
      fprintf( output, "}\n" );
      }

    PrintProducerLastModifiers( indent, l->L_RET );
    PrintReturnRapUp( indent, l->L_RET );

    if ( freeall )
      goto DoTheFrees;

    /* SKIP DEALLOCATIONS IF THEY ARE THE LAST THINGS DONE IN THE PROGRAM */
    if ( sequential && standalone ) {
      register PNODE nn;

      /* IF COMPLEX LIES AHEAD THEN FREE THE STORAGE */
      for ( nn = l->nsucc; nn != NULL; nn = nn->nsucc )
	if ( IsCompound( nn ) || IsCall( nn ) )
	  break;

      if ( nn == NULL ) {
	register PEDGE ee;
	register PEDGE ii;

	for ( ee = l->exp; ee != NULL; ee = ee->esucc )
	  if ( ee->dst != NULL )
	    if ( IsXGraph( ee->dst ) ) {
	      for ( ii = l->L_INIT->imp; ii != NULL; ii = ii->isucc )
		if ( ii->cm == -1 )
		  rmcmcnt++;

	      goto LastThing;
	      }
	}
      }
      
DoTheFrees:
    PrintConsumerModifiers( indent, l->L_INIT );
    PrintConsumerModifiers( indent, l );

LastThing:
    return;
}


/**************************************************************************/
/* LOCAL  **************       GetTypePrefix       ************************/
/**************************************************************************/
/* PURPOSE: RETURN THE PREFIX CHARACTER ASSOCIATED WITH TYPE i.           */
/**************************************************************************/

static char GetTypePrefix( i )
PINFO i;
{
  switch( i->type ) {
    case IF_DOUBLE:
      return( 'd' );

    case IF_REAL:
      return( 'r' );

    case IF_INTEGER:
      return( 'i' );

    default:
      fprintf( stderr, "HELP type = %d\n", i->type );
      Error2( "GetTypePrefix", "ILLEGAL TYPE" );
      break;
    }
}


void PrintFirstSum( indent, l )
int   indent;
PNODE l;
{
             char   fn[100];
    register PEDGE  x;
    register PEDGE  y;
    register PEDGE  lo;
    register PEDGE  hi;
    register PEDGE  iv;

    PrintReturnInit( indent, l->L_RET );

    iv = FindImport( l->L_INIT, l->L_RET->imp->src->imp->isucc->eport );

    if ( (lo = iv->isucc) == NULL )
      lo = l->L_INIT->imp;
   
    if ( !IsConst( iv ) )
      iv = FindImport( l, iv->eport );

    if ( !IsConst( lo ) )
      lo = FindImport( l, lo->eport );

    hi = l->L_TEST->imp->src->imp->isucc;

    if ( !IsConst( hi ) )
      hi = FindImport( l, hi->eport );

    for ( y = l->L_BODY->exp; y != NULL; y = y->esucc )
      if ( IsArrayBase( y->info ) )
	break;

    y = FindImport( l, y->eport );

    x = l->L_RET->imp;

    sprintf( fn, "%cfsum", GetTypePrefix( x->src->imp->isucc->info ) );

    PrintIndentation( indent );
    fprintf( output, "FirstSum( " );
    PrintTemp( x ); 
    fprintf( output, ", " );
    PrintTemp( y ); 
    fprintf( output, ", " );
    PrintTemp( lo ); 
    fprintf( output, ", " );
    PrintTemp( hi ); 
    fprintf( output, ", " );
    PrintTemp( iv ); 
    fprintf( output, ", %s, %s );\n",
             l->L_RET->imp->src->imp->isucc->info->tname, 
	     BindInterfaceName( fn, FOR_FORTRAN, 's' ) );

    PrintReturnRapUp( indent, l->L_RET );
    PrintConsumerModifiers( indent, l );
}


void PrintTri( indent, l )
int   indent;
PNODE l;
{
             char  fn[100];
    register PEDGE x;
    register PEDGE y;
    register PEDGE z;
    register PEDGE e;
    register PEDGE lo;
    register PEDGE hi;
    register PEDGE iv;

    PrintReturnInit( indent, l->L_RET );

    iv = FindImport( l->L_INIT, l->L_RET->imp->src->imp->isucc->eport );

    if ( (lo = iv->isucc) == NULL )
      lo = l->L_INIT->imp;
   
    if ( !IsConst( iv ) )
      iv = FindImport( l, iv->eport );

    if ( !IsConst( lo ) )
      lo = FindImport( l, lo->eport );

    hi = l->L_TEST->imp->src->imp->isucc;

    if ( !IsConst( hi ) )
      hi = FindImport( l, hi->eport );

    z = y = NULL;
    for ( e = l->L_BODY->exp; e != NULL; e = e->esucc )
      if ( IsArrayBase( e->info ) ) {
	if ( e->dst->exp->dst->type == IFTimes ) {
	  z = e;
	  continue;
	  }

	y = e;
	continue;
	}

    if ( z == NULL ) z = y;
    if ( y == NULL ) y = z;

    y = FindImport( l, y->eport );
    z = FindImport( l, z->eport );

    x = l->L_RET->imp;

    sprintf( fn, "%ctri", GetTypePrefix( x->src->imp->isucc->info ) );

    PrintIndentation( indent );
    fprintf( output, "TrI( " );
    PrintTemp( x ); 
    fprintf( output, ", " );
    PrintTemp( y ); 
    fprintf( output, ", " );
    PrintTemp( z );
    fprintf( output, ", " );
    PrintTemp( lo ); 
    fprintf( output, ", " );
    PrintTemp( hi ); 
    fprintf( output, ", " );
    PrintTemp( iv ); 
    fprintf( output, ", %s, %s );\n", 
	     l->L_RET->imp->src->imp->isucc->info->tname, 
	     BindInterfaceName( fn, FOR_FORTRAN, 's' ) );

    PrintReturnRapUp( indent, l->L_RET );
    PrintConsumerModifiers( indent, l );
}


void PrintVMinMax( indent, l, root )
int    indent;
PNODE  l;
char  *root;
{
             char  fn[100];
    register PEDGE x;
    register PEDGE y;
    register PEDGE z;
    register PEDGE e;
    register PEDGE lo;
    register PEDGE hi;
    register PEDGE iv;

    PrintReturnInit( indent, l->L_RET );

    iv = FindImport( l->L_INIT, l->L_RET->imp->src->imp->eport );

    if ( (lo = iv->isucc) == NULL )
      lo = l->L_INIT->imp;
   
    if ( !IsConst( iv ) )
      iv = FindImport( l, iv->eport );

    if ( !IsConst( lo ) )
      lo = FindImport( l, lo->eport );

    hi = l->L_TEST->imp->src->imp->isucc;

    if ( !IsConst( hi ) )
      hi = FindImport( l, hi->eport );

    for ( x = l->L_BODY->exp; x != NULL; x = x->esucc )
      if ( IsArrayBase( x->info ) )
	  break;

    y = l->L_RET->imp;

    sprintf( fn, "%c%s", GetTypePrefix( x->dst->exp->info ), root );

    PrintIndentation( indent );
    fprintf( output, "FirstMinMax( " );
    PrintTemp( y ); 
    fprintf( output, ", " );
    PrintTemp( FindImport( l, x->eport ) ); 
    fprintf( output, ", " );
    PrintTemp( lo ); 
    fprintf( output, ", " );
    PrintTemp( hi ); 
    fprintf( output, ", " );
    PrintTemp( iv ); 
    fprintf( output, ", %s, %s );\n", x->dst->exp->info->tname, 
	     BindInterfaceName( fn, FOR_FORTRAN, 's' )     );

    PrintReturnRapUp( indent, l->L_RET );
    PrintConsumerModifiers( indent, l );
}
