#define IFForall           0           /* IF1 NODE TYPES --- COMPOUND         */
#define IFSelect           1
#define IFTagCase          2
#define IFLoopA            3
#define IFLoopB            4
#define IFIfThenElse       5           /* IF1 Version 1.1                     */
#define IFIterate          6           /* IF1 Version 1.1                     */

#define IFAAddH            100         /* IF1 NODE TYPES --- SIMPLE           */
#define IFAAddL            101
#define IFAAdjust          102
#define IFABuild           103
#define IFACatenate        104
#define IFAElement         105
#define IFAFill            106
#define IFAGather          107
#define IFAIsEmpty         108
#define IFALimH            109
#define IFALimL            110
#define IFARemH            111
#define IFARemL            112
#define IFAReplace         113
#define IFAScatter         114
#define IFASetL            115
#define IFASize            116
#define IFAbs              117
#define IFBindArguments    118
#define IFBool             119
#define IFCall             120
#define IFChar             121
#define IFDiv              122
#define IFDouble           123
#define IFEqual            124
#define IFExp              125
#define IFFirstValue       126
#define IFFinalValue       127
#define IFFloor            128
#define IFInt              129
#define IFIsError          130
#define IFLess             131
#define IFLessEqual        132
#define IFMax              133
#define IFMin              134
#define IFMinus            135
#define IFMod              136
#define IFNeg              137
#define IFNoOp             138
#define IFNot              139
#define IFNotEqual         140
#define IFPlus             141
#define IFRangeGenerate    142
#define IFRBuild           143
#define IFRElements        144
#define IFRReplace         145
#define IFRedLeft          146
#define IFRedRight         147
#define IFRedTree          148
#define IFReduce           149
#define IFRestValues       150
#define IFSingle           151
#define IFTimes            152
#define IFTrunc            153
#define IFReplaceMulti     160         /* IF1 Version 1.1                     */

#define IFSGraph           1000        /* IF1 GRAPH NODE TYPES (NONSTANDARD)  */
#define IFLGraph           1001
#define IFIGraph           1002
#define IFXGraph           1003

#define IFCBegin           2000        /* NONSTANDARD GENERALIZED NODE TYPES  */
#define IFCEnd             2001
#define IFEdge             2002
#define IFLiteral          2003

#define IFUndefined        9999

#define IsUndefined(x) ( (x)->type == IFUndefined )
#define IsSimple(x)    ( ((x)->type >= IFAAddH)  && ((x)->type <  IFSGraph) )
#define IsGraph(x)     ( ((x)->type >= IFSGraph) && ((x)->type <= IFXGraph) )
#define IsIGraph(x)    ( (x)->type == IFIGraph )
#define IsSGraph(x)    ( (x)->type == IFSGraph )
#define IsXGraph(x)    ( (x)->type == IFXGraph )

#define IsLiteral(x)   ( (x)->type == IFLiteral )
#define IsEdge(x)      ( (x)->type == IFEdge )

#define IF_ARRAY          0            /* IF SYMBOL TABLE TYPES               */
#define IF_BASIC          1
#define IF_FIELD          2
#define IF_FUNCTION       3
#define IF_MULTPLE        4
#define IF_RECORD         5
#define IF_STREAM         6
#define IF_TAG            7
#define IF_TUPLE          8
#define IF_UNION          9
#define IF_UNKNOWN        10

#define BASIC_TYPE_START  11
#define IF_BOOL           0 + BASIC_TYPE_START
#define IF_CHAR           1 + BASIC_TYPE_START
#define IF_DOUBLE         2 + BASIC_TYPE_START
#define IF_INTEGER        3 + BASIC_TYPE_START
#define IF_NULL           4 + BASIC_TYPE_START
#define IF_REAL           5 + BASIC_TYPE_START
#define IF_NONTYPE        6 + BASIC_TYPE_START

#define IsBasic(x)          ( (x)->type >= BASIC_TYPE_START )
#define IsFunction(x)       ( (x)->type == IF_FUNCTION )
#define IsDouble(x)         ( (x)->type == IF_DOUBLE )
#define IsInteger(x)        ( (x)->type == IF_INTEGER )
#define IsArray(x)          ( (x)->type == IF_ARRAY )

#define IsArithmetic(x)     ( ((x)->type == IF_INTEGER) ||    \
			      ((x)->type == IF_DOUBLE)  ||    \
			      ((x)->type == IF_REAL)     )

#define ERROR_CONSTANT    "error"
#define GRAPH_LABEL       0
#define CONST_PORT        -1

#define DFORDERED         'D'          /* LLNL STAMPS                         */
#define IF1CHECK          'C'
#define FRONTEND          'F'
#define OFFSETS           'O'
#define LOOPINVARS        'L'
#define COMMONSUBS        'C'
#define CONSTANT          'G'
#define QMODE             'Q'

#define MONOLITH          'M'          /* CSU STAMPS                          */


typedef struct node       NODE,  *PNODE;
typedef struct info       INFO,  *PINFO;
typedef struct name       NAME,  *PNAME;
typedef struct prags      PRAGS;

#define PRAGMAS unsigned  na : 1; /* PRAGMAS %na=name %sl=line %mk=mark */ \
                unsigned  sl : 1; /*         %sf=file %fn=funct         */ \
                unsigned  mk : 1;                                          \
		unsigned  sf : 1;                                          \
		unsigned  fn : 1;                                          \
                char     *name;                                            \
                int       line;                                            \
                char      mark;                                            \
		char     *file;                                            \
		char     *funct

#define AssignPragmas(x) (x)->na = pragmas.na; (x)->name  = pragmas.name;  \
			 (x)->sl = pragmas.sl; (x)->line  = pragmas.line;  \
			 (x)->mk = pragmas.mk; (x)->mark  = pragmas.mark;  \
			 (x)->sf = TRUE;                                   \
			 if ( pragmas.sf ) (x)->file = pragmas.file;       \
                         else              (x)->file = sfile;              \
			 (x)->fn = TRUE;                                   \
			 if ( pragmas.fn ) (x)->funct = pragmas.funct;     \
                         else              (x)->funct = sfunct

#define InitPragmas(x)   (x)->na = FALSE;    (x)->name  = "";              \
			 (x)->mk = FALSE;    (x)->mark  = 'V';             \
			 (x)->fn = FALSE;    (x)->funct = "?()";           \
			 (x)->sf = FALSE;    (x)->file  = "?.sis";         \
			 (x)->sl = FALSE;    (x)->line  = -1


#define CopyPragmas(x,y) (y)->na = (x)->na; (y)->name  = (x)->name;        \
			 (y)->sl = (x)->sl; (y)->line  = (x)->line;        \
			 (y)->mk = (x)->mk; (y)->mark  = (x)->mark;        \
			 (y)->sf = (x)->sf; (y)->file  = (x)->file;        \
			 (y)->fn = (x)->fn; (y)->funct = (x)->funct

struct prags {
    PRAGMAS;
    };

struct name {
    char  *name;                                             /* FUNCTION NAME */

    char     mark;
    unsigned mk:1;

    PNODE  node;                       /* GLOBAL GRAPH NODE                   */

    PINFO  info;                       /* SYMBOL TABLE ENTRY FOR THE FUNCTION */
    PNAME  next;                       /* NEXT FUNCTION NAME IN NAME LIST     */
    PNAME  usucc;                      /* UTILITY LIST                        */
    };

struct node {
    int    type;                       /* IF NODE TYPE                        */
    int    label;                      /* UNIQUE (IN SCOPE) NODE IDENTIFIER   */

    PINFO  info;                /* EDGE, LITERAL, OR GRAPH SYMBOL TABLE ENTRY */
    char  *CoNsT;               /* LITERAL CONSTANT OR FUNCTION NAME          */

    int    snode;           /* EDGE AND LITERAL SOURCE AND DESTINATION LABELS */
    int    eport;
    int    dnode;
    int    iport;

    PRAGMAS;

    PNODE  next;                       /* NEXT NODE IN THE NODE LIST          */
    };

struct info {
    int   type;                        /* IF SYMBOL TABLE TYPE                */
    int   label;                       /* UNIQUE SYMBOL IDENTIFIER            */
    int   print;                       /* SHOULD THIS NODE BE PRINTED?        */
    int   eid;                         /* EQUIVALENCE CLASS IDENTIFIER        */

    PINFO info1;                       /* UTILITY POINTERS                    */
    PINFO info2;

    PRAGMAS;

    PINFO  next;                       /* NEXT INFO NODE IN SYMBOL TABLE      */
    PINFO  mnext;                      /* NEXT MEMBER OF EQUIVALENCE CLASS    */
    };

#define A_ELEM      info1              /* ARRAY-STREAM-MULTIPLE SUBCOMPONENT  */
#define R_FIRST     info1              /* FIRST RECORD-UNION MEMBER           */
#define F_IN        info1              /* FUNCTION IMPORT TYPES               */
#define F_OUT       info2              /* FUNCTION EXPORT TYPES               */
#define L_NEXT      info1              /* NEXT LIST ENTRY                     */
#define L_SUB       info2              /* LIST COMPONENT TYPE                 */

#define MAIN_NAME   "main"             /* NAME OF IF1 PROGRAM ENTRY POINT     */
