/* $Header: omitstrt.c,v 3.0 88/04/13 16:05:56 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#include "types.h"
#include "ambigu.h"
#include "att_gen.h"
#include "context.h"
#include "element.h"
#include "node.h"
#include "omitstrt.h"

#ifdef DEBUG
static Bool debug = FALSE;
#endif

Bool declared_content(elem)
P_Element elem;
{
	P_Node node;
	int    key;

	node = content(elem);
	if (node_type(node) == KEY)
	    if (((key = node_key(node)) == CDATA) or
		(key == EMPTY) or (key == RCDATA))
		return(TRUE);
	return(FALSE);
}

Bool content_any(elem)
P_Element elem;
{
	P_Node node;

	node = content(elem);
	if ((node_type(node) == KEY) and (node_key(node) == ANY))
		return(TRUE);
	return(FALSE);
}

void omit_starttag(node, element)
P_Node     node;
P_Element  element;
{
	P_Iterator group;
	P_Node     startnode;

	if(omit_ok(node, element)){
	    group = group_iterator(node_group(node));
	    startnode = next_node(group);
	    node_set_occ(startnode, OCC_OPT);
	    node_set_nullable(startnode, Yes);
	    iterator_delete(group);
#ifdef DEBUG
	    DEB("YES omitted\n");
#endif
	}
#ifdef DEBUG
	else {
	    DEB("NOT omitted\n");
	}
#endif
}

void starttag(node, node_element)
P_Node     node;
P_Element  node_element;
{
	P_Element  elem;
	String     name;

	if (node_type(node) != GI) return;
	name = node_gi(node);
	elem = element(name);
	if (!elem) {
	    report(ELEM_UNDEF, FATAL, 0, 0, name);
	    return;
	}
	if (!omit_start(elem) or declared_content(elem) or
	     attr_required(name) or content_any(elem))     ;
	else if ((node_status(node) != INHERENTLY_OPT) and
	         (node_status(node) != UNDEFINED))
		    omit_starttag(node, node_element);
}

#ifdef DEBUG
void debug_omitstrt(b)
Bool b;
{
	debug = b;
}
#endif
