/*  $Header: ent.g,v 3.0 88/04/13 16:38:57 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
{
#include "types.h"
#include "entity.h"
#include "lexical.h"
#include "modes.h"
}

ent_decl
{
    char          ent_name[NAMELEN + 1];
    char          not_name[NAMELEN + 1];
    int           type = UNDEFINED;
    int           gen_or_par  ;
    char          text[LITLEN + 1];
    P_Extern_id   ex_id = 0;

    ent_name[0] = '\0';
    not_name[0] = '\0';
    text[0]     = '\0';
} :
	[ MDO_ENTITY                                    { enter_mode(MODE_MD); }
							{ pero(TRUE);   }
						        /* See constr.c */
	  ps_plus ent_name(ent_name, &gen_or_par)
	  ps_plus ent_text(text, &ex_id, &type, not_name, gen_or_par)
              { if( gen_or_par == GENERAL ){
	            define_general_entity(ent_name, text,ex_id, type, not_name);
		} else {
		    define_parameter_entity(ent_name, text,ex_id,type,not_name);
                }
              }
	  TOK_MDC                                      { leave_mode(); }
	] ;

ent_name(String str; int *gen_or_par;) :
	[  param_ent_name(str)
	        { *gen_or_par = PARAMETER; }
	  | general_ent_name(str)
	        { *gen_or_par = GENERAL; }
	] ;

general_ent_name(String name;)
{
    int    key;
    String str;
} :
        [   name(name, NAMECASE_ENTITY)
	        { pero(FALSE); }
	  | [ TOK_RNI keyword(&key, &str)                       /* DEFAULT */
	      {
		  if( not check_int(key, DEFAULT, 0) ) {
		      report(KEY_WRONG, NOTFATAL, 0, 0, str,
			     "general entity name", "DEFAULT", "DEFAULT");
		      key = DEFAULT;
		  }
		  strcpy(name, "DEFAULT");
	      }
	    ]
	] ;

param_ent_name(String str;) :
	[ TOK_PERODEF					{ pero(FALSE); }
	  ps_plus name(str, NAMECASE_ENTITY)
	      { if (strlen(str) > NAMELEN - 1) {
		   report(WAR_PAR_NAME, NOTFATAL, 0, 0, str, NAMELEN-1);
		   str[NAMELEN - 1] = '\0';
		}
	      }
	] ;

ent_text(String       text;
	 P_Extern_id *ex_id;
	 int         *type;
	 String       not_name;
	 int          gen_or_par; )
{
    int    key;
    String str;
} :
	[   [ keyword(&key, &str)
	      {
		  if( not check_int(key, SYSTEM, PUBLIC, CDATA, SDATA,
					PI, STARTTAG, ENDTAG, MS, MD, 0) )
		  { report(KEY_WRONG, NOTFATAL, 0, 0, str, "entity text", 
			   "SYSTEM, PUBLIC, C/SDATA, PI, START/ENDTAG, MS, MD",
			   "CDATA");
		    key = CDATA;
		  } else if( gen_or_par == PARAMETER ){
		      if( check_int(key, SDATA, CDATA, 0) ){
			  report(ENT_PAR_SCDATA, FATAL, 0, 0);
		      }
		  }
	      }
	      [%if( (key==SYSTEM) || (key==PUBLIC) )
	          extern_ent_spec(ex_id, key, type, not_name, gen_or_par)
		|
		  /* CDATA, SDATA, PI, STARTTAG, ENDTAG, MS, MD */
		  [
		    ps_plus param_literal(text) ps_star
		      { *type = key; }
		  ]
	      ]
	    ]
	  |
	    [ param_literal(text) ps_star
		  { *type = LITERAL; }
	    ]
	] ;

extern_ent_spec(P_Extern_id *ex_id;
		int          ex_type;
		int         *type;
		String       not_name;
		int          gen_or_par;)
 :
	[     { *type = UNDEFINED; }
	  ps_plus
	  extern_ident_short(ex_id, ex_type)
	  [ ent_type(type, not_name) ps_star
	      { if( gen_or_par == PARAMETER ){
		    report(ENT_PAR_NDATA, FATAL, 0, 0);
		    *type = EXTERNAL;
		}
	      }
	  ]?
	      { if( *type == UNDEFINED ){ *type = EXTERNAL; } }
	] ;

ent_type(int *type; String not_name;)
{
    String str;
} :
	[ keyword(type, &str)
	  {
	      if( not check_int(*type, SUBDOC, NDATA, 0) ){
		  report(KEY_WRONG, NOTFATAL, 0, 0, str, "entity type",
			 "SUBDOC, NDATA", "NDATA");
		  *type = NDATA;
	      }
	  }
	  [%if( (*type)==SUBDOC )                      /* else "NDATA" */
	    | ps_plus name(not_name, NAMECASE_GENERAL) /* was : notation_name */
	  ]
	] ;
