/* $Header: conc_syn.h,v 3.0 88/04/14 09:13:16 jos Exp $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */
#ifndef CONCRETE_SYNTAX_H
#define CONCRETE_SYNTAX_H

#ifndef TYPES_H
#include "types.h"
#endif

/* enum Constraint; */

#define  C_NO      60
#define  C_CREF    61
#define  C_DCL     62
#define  C_ELEM    63
#define  C_GI      64
#define  C_MSE     65
#define  C_NMS     66

extern void       init_conc            ();
extern String     delimiter_to_string  (PAR  Delimiter  RAP);
extern Delimiter  string_to_delimiter  (PAR  String, RecognitionMode  RAP);
extern Bool       is_delim_char        (PAR  int  RAP);
extern Constraint constraint           (PAR  Delimiter  RAP);
extern int        token_length         (PAR  int token, int value  RAP);
extern String     token_to_string      (PAR  Token, int value  RAP);
extern int        function_char        (PAR  String function_name  RAP);

#endif
