/* $Header: att_gen.c,v 3.0 88/04/13 15:40:43 jos Locked $ */
/*
 *  This file is part of the Amsterdam SGML Parser.
 *
 *  Copyright: Faculteit Wiskunde en Informatica
 *             Department of Mathematics and Computer Science
 *             Vrije Universiteit Amsterdam
 *             The Netherlands
 *
 *  Authors:   Sylvia van Egmond
 *             Jos Warmer
 */

#include "types.h"
#include "att_chk.h"
#include "att_gen.h"
#include "element.h"
#include "keywords.h"
#include "node.h"
#include "notation.h"

struct attdef_struct {
	String   name;
	int      decl_val;
	P_Group  range;
	int      def_type;
	String   def_val;
};

struct attlist_struct {
	P_Group attrs;
	P_Group elems;
	int     elem_nr;
};

Bool attr_unique(PAR  P_Attlist attlist, P_Attdef  attdef  RAP);
static P_Group attributes = 0;

P_Attdef new_attdef(nm, decl_val, range, def_type, def_val)
String   nm;
int      decl_val;
P_Group  range;
int      def_type;
String   def_val;
{
	P_Attdef attdef;

	attdef = (P_Attdef) MALLOC( (unsigned)sizeof(struct attdef_struct) );
	attdef->name     = nm;
	attdef->decl_val = decl_val;
	attdef->range    = range;
	attdef->def_type = def_type;
	attdef->def_val  = def_val;

	return(attdef);
}

P_Attlist new_attlist(elems)
P_Group elems;
{
	static int number = 1;
	P_Attlist  attlist;

	attlist = (P_Attlist) MALLOC( (unsigned)sizeof(struct attlist_struct) );
	attlist->elems   = elems;
	attlist->elem_nr = number++;
	attlist->attrs   = group_create();

	return(attlist);
}

Bool attr_unique(attlist, attdef)
P_Attlist attlist;
P_Attdef  attdef;
{
    P_Iterator it;
    P_Attdef   listdef;
    P_Iterator iter1;
    P_Iterator iter2;
    String     name1;
    String     name2;

    if( (attdef->decl_val == ID) ){
	if( check_int(attdef->def_type, CONREF, CURRENT, FIXED, 0) ){
	    report(ATTR_ID_TYPE, FATAL, 0, 0, attdef->name,
		   key_str(attdef->def_type));
	    return(FALSE);
	}
	if( attdef->def_val != 0 ){
	    report(ATTR_ID_DEFAULT, FATAL, 0, 0, attdef->name);
	    return(FALSE);
	}
    }

    it = group_iterator(attlist->attrs);
    while (listdef = (P_Attdef) iterator_next(it)) {
	if( streq(attdef->name, listdef->name) ){
	    report(ATTR_NOT_UNIQUE, FATAL, 0, 0, attdef->name);
	    return(FALSE);
	}
	if( (attdef->decl_val == ID) and (listdef->decl_val == ID) ){
	    report(ATTR_TWO_ID, FATAL, attlist->elems, 0, "ID");
	    return(FALSE);
	}
	if( (attdef->decl_val  == NOTATION) and
	    (listdef->decl_val == NOTATION) )
	{
	    report(ATTR_TWO_ID, FATAL, attlist->elems, 0, "NOTATION");
	    return(FALSE);
	}
	if( ((attdef->decl_val==NOTATION) or (attdef->decl_val==ENUMERATE))
	    and
	    ((listdef->decl_val==NOTATION) or (listdef->decl_val==ENUMERATE)) )
	{
	    iter1 = group_iterator(attdef->range);
	    while( name1 = next_name(iter1) ){
		iter2 = group_iterator(listdef->range);
		while( name2 = next_name(iter2) ){
		    if( streq(name1, name2) ){
			report(ATTR_TWO_TOKEN, FATAL, attlist->elems, 0,
			       name1);
			iterator_delete(iter1);
			iterator_delete(iter2);
			return(FALSE);
		    }
		}
	    }
	}
    }
    return(TRUE);
}

void attdef_delete(attdef)
P_Attdef attdef;
{
	CFREE(attdef->name);
	delete_group(attdef->range, CFREE);
	CFREE(attdef->def_val);
	FREE(attdef, sizeof(struct attdef_struct));
}

void add_attdef(attlist, attdef)
P_Attlist attlist;
P_Attdef  attdef;
{
	if( not attr_unique(attlist, attdef) ){
	    attdef_delete(attdef);
	    return;
	}

	group_add(attlist->attrs, attdef);
}

void store_attlist(attlist)
P_Attlist attlist;
{
	if (attributes == 0) attributes = group_create();
	group_add(attributes, attlist);
}

String attr_var_name(name)
String name;
{
	P_Iterator  it, it_elem;
	String      elem = 0;
	static char att_name[10];
	P_Attlist   attlist;

	it = group_iterator(attributes);
	while (attlist = (P_Attlist) iterator_next(it)) {
	    it_elem = group_iterator(attlist->elems);
	    while ((elem = next_name(it_elem)) and
		   (strcmp(elem, name) != 0)) ;
	    if (elem) break;
	}
	if (elem) {
	    sprintf(att_name, "attr%d", attlist->elem_nr);
	} else {
	    sprintf(att_name, "0");
	}
	return(att_name);
}

Bool attr_conref(elem)
String elem;
{
	P_Iterator it, it_elem, it_attr;
	String     name = 0;
	P_Attlist  attlist;
	P_Attdef   attdef;

	it = group_iterator(attributes);
	while (attlist = (P_Attlist) iterator_next(it)) {
	    it_elem = group_iterator(attlist->elems);
	    while ((name = next_name(it_elem)) and
		   (strcmp(name, elem) != 0)) ;
	    if (name) break;
	}
	if (name) {
	    it_attr = group_iterator(attlist->attrs);
	    while (attdef = (P_Attdef) iterator_next(it_attr))
		if (attdef->def_type == CONREF) return(TRUE);
	}
	return(FALSE);
}

Bool attr_required(elem)
String elem;
{
	P_Iterator it, it_elem, it_attr;
	String     name = 0;
	P_Attlist  attlist;
	P_Attdef   attdef;

	it = group_iterator(attributes);
	while (attlist = (P_Attlist) iterator_next(it)) {
	    it_elem = group_iterator(attlist->elems);
	    while ((name = next_name(it_elem)) and
		   (strcmp(name, elem) != 0)) ;
	    if (name) break;
	}
	if (name) {
	    it_attr = group_iterator(attlist->attrs);
	    while (attdef = (P_Attdef) iterator_next(it_attr))
		if (attdef->def_type == REQUIRED) return(TRUE);
	}
	return(FALSE);
}

void check_attributes()
{
	P_Iterator attr_it, att_it, it;
	P_Attlist  attlist;
	P_Attdef   attdef;
	P_Element  elem;
	String     name;

	attr_it = group_iterator(attributes);
	while (attlist = (P_Attlist) iterator_next(attr_it)) {
	    it = group_iterator(attlist->elems);
	    while (name = next_name(it)) {
		if (!element(name))
		    report(ATTR_NOT_ELEM, FATAL, 0, 0, name);
	    }
	    att_it = group_iterator(attlist->attrs);
	    while (attdef = (P_Attdef) iterator_next(att_it)) {
		if ((attdef->decl_val == NOTATION) or
		    (attdef->def_type == CONREF)) {
		    it = group_iterator(attlist->elems);
		    while (name = next_name(it)) {
			elem = element(name);
			if (!elem) continue;
		        if ((node_type(content(elem)) == KEY) and 
			    (node_key(content(elem)) == EMPTY)) {
			    report(ATTR_EMP_CONT, FATAL, 0, 0, name);
		        }
	            }
                }
		if (attdef->decl_val == NOTATION) {
		    it = group_iterator(attdef->range);
		    while (name = next_name(it)) {
			if (!get_notation(name)) {
			    report(NOT_UNDEF, FATAL, 0, 0, name,
				   "attribute", attdef->name);
			}
		    }
		}

	    }
	}
}

void attr_gen_group(fp, attlist)
FILE   *fp;
P_Group attlist;
{
	P_Iterator it1, it2;
	P_Attdef   attdef;
	String     name;
	static int nr_range = 1;

	it1 = group_iterator(attlist);
	while (attdef = (P_Attdef) iterator_next(it1)) {
	    if (attdef->range != 0) {
		fprintf(fp, "String range%d[] = { ", nr_range); nr_range++;
		it2 = group_iterator(attdef->range);
		while (name = next_name(it2))
		    fprintf(fp, "\"%s\", ", name);
		fprintf(fp, "0 };\n");
	    }
	}
}

void attr_gen_attr(fp, attlist, nr)
FILE   *fp;
P_Group attlist;
int     nr;
{
	P_Iterator it;
	static int nr_range = 1;
	P_Attdef   a;

	fprintf(fp, "struct attdef_struct attr%d[] = {\n", nr);
	it = group_iterator(attlist);
	while (a = (P_Attdef) iterator_next(it)) {
	    fprintf(fp, "\t{ \"%s\", %s, ", a->name, key_str(a->decl_val));
	    if (a->range) {
		fprintf(fp, "range%d, %s, ", nr_range, key_str(a->def_type));
		nr_range++;
	    }
	    else fprintf(fp, "0, %s, ", key_str(a->def_type));
	    if (a->def_val) fprintf(fp, " \"%s\", 0 },\n", cstring(a->def_val));
	    else fprintf(fp, "0, 0 },\n");
	}
	fprintf(fp,"{0, 0, 0, 0, 0, 0 } };\n");
}

void attrs_generate(file_attr, file_extern)
String file_attr;
String file_extern;
{
	P_Iterator it;
	P_Attlist  attlist;
	FILE      *fp1, *fp2;

	fp1 = fopen(file_attr, "w");
	fp2 = fopen(file_extern, "w");

	if (fp1 == 0) {
	    report(FILE_OPEN, FATAL, 0, 0, file_attr);
	}
	if (fp2 == 0) {
	    report(FILE_OPEN, FATAL, 0, 0, file_extern);
	}
	it = group_iterator(attributes);
	while (attlist = (P_Attlist) iterator_next(it)) {
	    attr_gen_group(fp1, attlist->attrs);
	    attr_gen_attr(fp1, attlist->attrs, attlist->elem_nr);
	    fprintf(fp2, "extern struct attdef_struct attr%d[];\n", attlist->elem_nr);
	}
	fclose(fp1);
	fclose(fp2);
}

void attr_cap_points(att, attch, avgrp, id, idref)
int *att, *attch, *avgrp, *id, *idref;
{
	P_Attlist  attlist;
	P_Attdef   attdef;
	P_Iterator it, it_att, it_elem;
	String     elem;

	it = group_iterator(attributes);
	while (attlist = (P_Attlist) iterator_next(it)) {
	    it_att = group_iterator(attlist->attrs);
	    while (attdef = (P_Attdef) iterator_next(it_att)) {
		(*att)++;
		it_elem = group_iterator(attdef->range);
		while (elem = next_name(it_elem))
		    (*avgrp)++;
		if (attdef->def_val) {
		    switch (attdef->decl_val) {
		      case NUMBERS  :
		      case NUTOKENS :
		      case IDREFS   :
		      case NAMES    :
		      case NMTOKENS :
			    *attch += norm_val_length(attdef->def_val, attdef->decl_val);
			    break;
		      default       :
		            *attch += strlen(attdef->def_val) + NORMSEP;
			    break;
		   }
		}
		else if (attdef->def_type == CURRENT) *attch += NAMELEN;
	    }
	}
}

#ifdef DEBUG
void attdef_print(fp, attdef)
FILE    *fp;
P_Attdef attdef;
{
	P_Iterator it;
	String     elem;

	fprintf(fp, "%s %s { ", attdef->name, key_str(attdef->decl_val));
	it = group_iterator(attdef->range);
	while (elem = next_name(it)) fprintf(fp, "%s ", elem);
	fprintf(fp, "0 } %s ", key_str(attdef->def_type));
	if (attdef->def_val) fprintf(fp, "%s\n", attdef->def_val);
	else fprintf(fp, "\n");
}

void attrs_print(fp)
FILE *fp;
{
	P_Iterator it1, it2;
	String     elem;
	P_Attdef   attdef;
	P_Attlist  attlist;

	it1 = group_iterator(attributes);
	while (attlist = (P_Attlist) iterator_next(it1)) {
	    it2 = group_iterator(attlist->elems);
	    while (elem = next_name(it2)) fprintf(fp, "%s ", elem);
	    fprintf(fp, ":\n");
	    it2 = group_iterator(attlist->attrs);
	    while (attdef = (P_Attdef) iterator_next(it2)) 
		attdef_print(fp, attdef);
	    fprintf(fp, "\n\n");
	}
}
#endif
