/******************************************************************************/
/* TRACE.H: Declarations for internal trace functions. */
/******************************************************************************/
/* Trace variables.
*/
extern int  trace;            /* Switch: 1=trace state transitions; 0=don't. */
extern int atrace;            /* Switch: 1=trace attribute activity; 0=don't. */
extern int ctrace;            /* Switch: 1=trace context checking; 0=don't. */
extern int dtrace;            /* Switch: 1=trace declaration parsing; 0=don't.*/
extern int etrace;            /* Switch: 1=trace entity activity; 0=don't.*/
extern int gtrace;            /* Switch: 1=trace group creations; 0=don't. */
extern int itrace;            /* Switch: 1=trace ID activity; 0=don't. */
extern int mtrace;            /* Switch: 1=trace MS activity; 0=don't. */
extern int ntrace;            /* Switch: 1=trace data notation activity. */
extern UNCH emd[];            /* For "EMD" parameter type in dtrace calls. */
extern UNCH estype1[];        /* For estore values in trace messages. */
extern UNCH estype2[];        /* For estore values in trace messages. */
/******************************************************************************/
/*global*/  void traceadl(struct ad *);
/*global*/  void tracecon(int,int,int,struct parse *,int,int);
/*global*/  void tracedcn(struct dcncb *);
/*global*/  void tracedsk(struct tag *,struct tag *,int,int);
/*global*/  void traceecb(char *,struct entity *);
/*global*/  void traceend(char *,struct thdr *,struct mpos *,int,int,int);
/*global*/  void traceesn(struct ne *);
/*global*/  void traceetd(struct etd *);
/*global*/  void traceetg(struct tag *,struct etd *,int,int);
/*global*/  void tracegi(char *,struct etd *,struct thdr *,struct mpos *,int);
/*global*/  void tracegml(struct restate *,int,int,int);
/*global*/  void tracegrp(struct etd * *);
/*global*/  void traceid(char *,struct id *);
/*global*/  void tracemap(char *,char *,int);
/*global*/  void tracemd(char *);
/*global*/  void tracemod(struct thdr *);
/*global*/  void tracems(int,int,int,int);
/*global*/  void tracengr(struct dcncb * *);
/*global*/  void tracepcb(struct parse *);
/*global*/  void tracepro(void);
/*global*/  void traceset(void);
/*global*/  void tracesrm(char *,struct entity * *,char *);
/*global*/  void tracestg(struct etd *,int,int,struct etd *,int);
/*global*/  void tracestk(struct tag *,int,int);
/*global*/  void tracetkn(int,char *);
/*global*/  void traceval(struct parse *,unsigned int,char *,int);
/******************************************************************************/
