/******************************************************************************/
/* Changed ipbbuf from UNIV to char * for consistency with read() arg.        */
/******************************************************************************/
/* Deleted idcan, entref, and entdef services (prohibited by standard).       */
/* Add control blocks for getting and freeing memory.                         */
/******************************************************************************/
/* SGMLCB.H: Symbols for SGML interface control blocks that are used
             for parameters when calling SGML services (IPB), or as return
             control blocks after completing the services (RCB).
*/
/******************************************************************************/
/* Housekeeping.
*/
#define NAMEBUF   10                 /* Buffer size for names. */
/******************************************************************************/
/* Interface parameter block types (IPBTYPE) for calls to SGML:
*/
/* NULL pointer    0      SGML: parse current entity (returns RCB ptr). */
#define SGMLSET    1   /* SGML: set up first pass (RCB pts to delims). */
#define SGMLRSET   2   /* SGML: reset for subsequent pass (no RCB). */
#define SGMLEND    3   /* SGML: clean up after last pass (RCB pts to stat). */
#define ENTPRIME   6   /* Entity: declare & ref primary entity (RC: <0=error).*/
#define GISET      7   /* GI: store start- and end- ptrs with GI(RC: 1=no GI).*/
#define GIGET      8   /* GI: get start- and end- ptrs for GI (RC: 1=no GI). */
#define ENTGET    10   /* Entity: get entity text if data entity. */
/******************************************************************************/
/* NOTE: Names in IPBT are unsigned character arrays whose length
         (including the length byte itself and a zero terminator) is in the
         first character position; e.g., the name "JACK" is actually: \6JACK\0
         This convention is also followed for strings and arrays that (like
         names) cannot exceed a known maximum length (except that arrays have
         no zero terminator, and their length is stored as indicated
         by the #define statements in SGMLMAIN.H.
         For other strings and arrays, the length is in itl1 or itl2 and the
         array pointer in itp1 or itp2; there is no zero terminator.
*/
struct ipbt {                 /* IPB for calls to SGML. */
     UNS ipbtype;             /* Type of interface parameter block. */
     UNIV itnm;               /* Entity, GI, or ID name. */
     UNS itl1;                /* Length of string pointed to by p1 (if any). */
     UNIV itp1;               /* Start-GI proc; ID data. */
                              /* ENTPRIME: Permanent DOS fileid. */
                              /* SGMLSET: Address of return code from SGML. */
                              /* SGMLRESET: Address of sw switches array. */
                              /* ENTGET: Pointer to data entity text. */
     UNS itl2;                /* Length of string pointed to by p2 (if any). */
     UNIV itp2;               /* GI end-tag proc. */
                              /* SGMLSET: Address of SGML RCB pointer. */
                              /* From SGMLSET: Address of delimiter array. */
};
/******************************************************************************/
/* Return control block types (RCBTYPE) from calls to parser (SGML):
   Names and strings follow the convention for the IPBs.
*/
#define SGMLDAF    1   /* Data found. */
#define SGMLEOD    2   /* End of document. */
#define SGMLETG    3   /* End-tag found. */
#define SGMLPIS    4   /* Processing instruction (string). */
#define SGMLREF    5   /* Record end found. */
#define SGMLSTG    6   /* Start-tag found. */
#define SGMLSDTD   7   /* Document type definition started (data is type). */
#define SGMLEDTD   8   /* Document type definition ended (data is type). */
#define SGMLMV     9   /* Information for markup validator only (ignore). */
/******************************************************************************/
/* Default format classes (returned with SGMLSTG and SGMLETG RCBs).
*/
#define FORMATP    1   /* Phrase: change font (e.g., quote, citation). */
#define FORMATB    2   /* Block: vertical space (e.g., paragraph, list item). */
#define FORMATS    3   /* Structure: indent margins (e.g., list, long quote). */
#define FORMATN    4   /* Non-SGML data: print file ID and notation. */
/******************************************************************************/
/* NOTE: Pointers to data within SGML are offsets only; DS is returned
         by the call to SGMLSET.
*/
struct rcbdata {              /* Return control block: DAF EOD REF PIS DTD. */
     UNS rcbtype;             /* Type of return control block. */
     PSCB sgmlscbs;           /* Source control block stack. */
     int sgmles;              /* Index into sgmlscbs. */
     UNS contersw;            /* 1=context error; 2,4,8=data type; 0=not. */
     UNS datalen;             /* Length of data or PI (0=single nonchar). */
     UNCH *data;              /* Data, PI, single nonSGML, or NDATA ecb ptr. */
};
struct rcbtag {               /* Return control block for STG and ETG. */
     UNS rcbtype;             /* Type of return control block. */
     PSCB sgmlscbs;           /* Source control block stack. */
     int sgmles;              /* Index into sgmlscbs. */
     UNS contersw;            /* 1=context error; 2=NET enabled; 0/0=not. */
     UNS tagmin;              /* Minim: NONE NULL NET DATA; implied by S/ETAG */
     UNCH curgi[NAMEBUF];     /* Start-tag (or end-tag) GI. */
     UNIV gidata;             /* User data associated with start (or end) GI. */
     union {
          struct ad *al;      /* Start-tag: attribute list. */
          UNCH *oldgi;        /* End-tag: resumed GI. */
     } ru;
     long idrefl;             /* IDREF hits (in order of IDREF tokens in al). */
     struct ad *lal;          /* Start-tag: link attribute list (UNUSED). */
     UNS format;              /* Format class for default processing. */
     struct etd *tagreal;     /* Dummy etd or ptr to GI that implied this tag.*/
     int etictr;              /* Number of elements on stack with NET enabled.*/
     UNCH *srmnm;             /* Current SHORTREF map name (NULL=#EMPTY). */
     struct entity **aentl;   /* AENTITY ECBs (order of AENTITY tokens in al).*/
};
/******************************************************************************/
/* Interface parameter block types (IPBTYPE) for calls to I/O services
   performed for SGML by the text processor (SGMLIO).
   NOTE: Strings in these blocks are zero-terminated; no length byte
         (except that DOS fileid returned by FILENAME has length byte).
*/
#define FILENM     1   /* File: generate IO filename from fpi control block. */
#define FILEOPEN   2   /* File: open file. */
#define FILEREAD   3   /* File: read next block. */
#define FILEPEND   4   /* File: close file temporarily and save location. */
#define FILECONT   5   /* File: reopen file; position at saved location. */
#define FILECLOS   6   /* File: close file permanently. */
/******************************************************************************/
struct ipbfile {              /* IPB for FILEOPEN FILEREAD FILECLOS FILENM. */
     UNS ipbtype;             /* Type of interface parameter block. */
     PSCB sgmlscbs;           /* Source control block stack. */
     int sgmles;              /* This file's SCB level (NAME=current file's). */
     int ipbrc;               /* From OPEN FRST READ: -1=error; >=0 if o.k. */
     UNIV ipbn;               /* To NAME: fpi ptr; from NAME: SGMLIO name ptr.*/
                              /* To OPEN: name ptr; from OPEN: SGMLIO fcb ptr.*/
                              /* To FRST READ CLOSE PEND CONT: SGMLIO fcb ptr.*/
     char *ipbbuf;            /* To FRST READ: SGML read buffer. */
                              /* From FRST READ: actual read buffer. */
     UNS ipboff;              /* To PEND: characters parsed in current block. */
};
/******************************************************************************/
/* Error types (ERRTYPE) for calls to error-handling services
   performed for SGML by the text processor (SGMLIO).
   NOTE: Strings in these blocks have no lengths, but cannot exceed
   NAMELEN (plus 1 more byte for the zero terminator).
*/
#define FILERR    7           /* Error: file access. */
#define DOCERR    8           /* Error: in document markup. */
#define MDERR     9           /* Error: in markup declaration with subdcl. */
#define MDERR2   10           /* Error: in markup declaration with no subdcl. */
#define EXITERR  11           /* Error: terminal error in document markup. */
/******************************************************************************/
/* Quantities affecting error messages and their arguments.
*/
#define MAXARGS    2          /* Maximum number of arguments in a msg. */
#define MAXMSGS  255          /* Number of error messages in msgfile. */
#define MAXHDRS    7          /* Number of header messages in msgfile. */
#define MAXPCBS   25          /* Number of parse mode parameters in msgfile. */
#define MAXDCLS   11          /* Number of declaration name parms in msgfile. */
/******************************************************************************/
/* NOTE: Error handler must return, or next call to SGML must be RSET or END,
         except for errors with severity code 'C', which must not return.
*/
struct ipberr {               /* IPB for error messages. */
     UNS errtype;             /* Type of error: DOC, MD, MD2, FIL. */
     PSCB sgmlscbs;           /* Source control block stack. */
     int sgmles;              /* Index into sgmlscbs. */
     UNS errnum;              /* Error number. */
     UNS errsp;               /* Special parameter index in message file. */
     int parmno;              /* MDERROR: declaration parameter number. */
     UNCH subdcl[NAMEBUF];    /* MDERROR: subject of declaration. */
     UNIV eparm[MAXARGS];     /* Ptrs to arguments (no length, but EOS). */
};
/******************************************************************************/
/* Memory service request types (MEMTYPE) for calls to memory services
   performed for SGML by the support environment (SGMLMEM).
*/
#define MEMGET    1           /* Memory: get area of specified size. */
#define MEMFREE   2           /* Memory: free previously gotten area. */
/******************************************************************************/
struct ipbmem {               /* IPB for memory services. */
     UNS memtype;             /* Type of request: GET, FREE. */
     UNIV memarea;            /* From GET: area gotten; to FREE: gotten area. */
     UNS memsize;             /* To GET: size of area to get (in chars). */
     UNS mempool;             /* Subpool number (TEMP: unused - always 0). */
};
/******************************************************************************/
