; Wb-tree File Based Associative String Data Base System.
; Copyright (c) 1991, 1992, 1993 Holland Mark Martin
;
;Permission to use, copy, modify, and distribute this software and its
;documentation for educational, research, and non-profit purposes and
;without fee is hereby granted, provided that the above copyright
;notice appear in all copies and that both that copyright notice and
;this permission notice appear in supporting documentation, and that
;the name of Holland Mark Martin not be used in advertising or
;publicity pertaining to distribution of the software without specific,
;written prior consent in each case.  Permission to incorporate this
;software into commercial products can be obtained from Jonathan
;Finger, Holland Mark Martin, 174 Middlesex Turnpike, Burlington, MA,
;01803-4467, USA.  Holland Mark Martin makes no representations about
;the suitability or correctness of this software for any purpose.  It
;is provided "as is" without express or implied warranty.  Holland Mark
;Martin is under no obligation to provide any services, by way of
;maintenance, update, or otherwise.

(require 'stdio)
(require (in-vicinity (program-vicinity) "defs"))

;;; This is where all diagnostic and error messages will appear
(define diagout stderr)

(define lck-list '())
(define (make-lck name)
  (let ((lk (make-arbiter name)))
    (set! lck-list (cons lk lck-list))
    lk))
(define try-lck try-arbiter)
(define (lck! lck)
  (or (try-arbiter lck)
      (fprintf diagout ">>>>ERROR<<<< spinning %d\\n" lck)))
(define (unlck! lck)
  (or (release-arbiter lck)
      (fprintf diagout ">>>>ERROR<<<< unlcking %d\\n" lck)))
;;; this fixes lcks - testing only
(define (check-lcks)
  (for-each
   (lambda (l)
     (and (release-arbiter l)
	  (fprintf diagout ">>>>ERROR<<<< %d left lcked\\n" l)))
   lck-list))

(define (free! x)
  (if x #f (fprintf diagout ">>>>ERROR<<<< free!: object already freed\\n")))
(define (substring-move! src start end dst dstart)
  (if (eq? src dst)
      (fprintf diagout ">>>>ERROR<<<< substring-move!: called with same string\\n"))
  (substring-move-left! src start end dst dstart))

;;;; read-string and write-string are only used in blkio.scm, but are
;;; here for their C equivalents.

(define (write-string fildes buffer nbytes)
  (cond ((= nbytes (string-length buffer))
	 (display buffer fildes)
	 nbytes)
	((< nbytes (string-length buffer))
	 (display (substring buffer 0 nbytes) fildes)
	 nbytes)
	(else 0)))

(define (read-string fildes buffer nbytes)
  (cond ((= nbytes (string-length buffer))
	 (uniform-vector-read! buffer fildes))
	((< nbytes (string-length buffer))
	 (let* ((tmpbuf (make-string nbytes))
		(numread (uniform-vector-read! tmpbuf fildes)))
	   (substring-move! tmpbuf 0 nbytes buffer 0)
	   numread))
	(else 0)))

;;; The handle is a HAN
;;; [HAN-SEG, HAN-ID, HAN-TYP, HAN-LAST, HAN-WriteControlBits]
;;; HAN-ID is always the root of a B-tree.

(define (make-han)
  (vector #f #f #f #f 0 #f))

(define HAN-ID-POS 0)
(define HAN-SEG-POS 1)
(define HAN-TYP-POS 2)
(define HAN-LAST-POS 3)
(define HAN-WCB-POS 4)
(define HAN-SPARE-POS 5)

(define (HAN-ID han) (vector-ref han HAN-ID-POS))
(define (HAN-SEG han) (vector-ref han HAN-SEG-POS))
(define (HAN-TYP han) (vector-ref han HAN-TYP-POS))
(define (HAN-LAST han) (vector-ref han HAN-LAST-POS))
(define (HAN-WCB han) (vector-ref han HAN-WCB-POS))

(define (HAN-SET-NUM! han num) (vector-set! han HAN-ID-POS num))
(define (HAN-SET-SEG! han seg) (vector-set! han HAN-SEG-POS seg))
(define (HAN-SET-TYP! han dir) (vector-set! han HAN-TYP-POS dir))
(define (HAN-SET-LAST! han num) (vector-set! han HAN-LAST-POS num))
(define (HAN-SET-WCB! han wcb) (vector-set! han HAN-WCB-POS wcb))

;;; A segment descriptor is a SEGD:
;;; [SEGD-PORT,			; file handle for segment
;;;  SEGD-BSIZ,			; block-size
;;;  SEGD-USED,			; number of blocks used (file-size/SEGD-BSIZ)
;;;  SEGD-STR,			; string name of file
;;;  SEGD-RT-HAN,		; handle for 0 block
;;;  SEGD-FL-HAN,		; handle for free-list block (2)
;;;  SEGD-LCK,			; lock for FLC and superblock.
;;;  SEGD-FCK,			; lock for the free-list.
;;;  SEGD-FLC-LEN,		; number of available blocks in free-list-cache
					;-1 means to read in "FLC" image.
					;-2 means read only.
;;;  SEGD-FLC]			; free-list-cache

;;;; The SEG calls in defs.scm are the same except they take a segment
;;;; number (index into segd-tab).

(define (make-segd i)
  (vector #f 0 #f #f (make-han) (make-han)
	  (make-lck (+ 1000 i)) (make-lck (+ 2000 i)) 0 #f))

(define segd-tab (make-vector NUM-SEGS))
(do ((i NUM-SEGS (- i 1)))
    ((zero? i))
  (vector-set! segd-tab (- i 1) (make-segd (- i 1))))

(define SEGD-PORT-POS 0)
(define SEGD-BSIZ-POS 1)
(define SEGD-USED-POS 2)
(define SEGD-STR-POS 3)
(define SEGD-RT-HAN-POS 4)
(define SEGD-FL-HAN-POS 5)
(define SEGD-LCK-POS 6)
(define SEGD-FCK-POS 7)
(define SEGD-FLC-LEN-POS 8)
(define SEGD-FLC-POS 9)

(define (SEGD-PORT segd) (vector-ref segd SEGD-PORT-POS))
(define (SEGD-BSIZ segd) (vector-ref segd SEGD-BSIZ-POS))
(define (SEGD-USED segd) (vector-ref segd SEGD-USED-POS))
(define (SEGD-STR segd) (vector-ref segd SEGD-STR-POS))
(define (SEGD-RT-HAN segd) (vector-ref segd SEGD-RT-HAN-POS))
(define (SEGD-FL-HAN segd) (vector-ref segd SEGD-FL-HAN-POS))
(define (SEGD-FLC-LEN segd) (vector-ref segd SEGD-FLC-LEN-POS))
(define (SEGD-FLC segd) (vector-ref segd SEGD-FLC-POS))
(define (SEGD-LCK segd) (vector-ref segd SEGD-LCK-POS))
(define (SEGD-FCK segd) (vector-ref segd SEGD-FCK-POS))

(define (SEGD-SET-PORT! segd port) (vector-set! segd SEGD-PORT-POS port))
(define (SEGD-SET-BSIZ! segd bsiz) (vector-set! segd SEGD-BSIZ-POS bsiz))
(define (SEGD-SET-USED! segd used) (vector-set! segd SEGD-USED-POS used))
(define (SEGD-SET-STR! segd str) (vector-set! segd SEGD-STR-POS str))
(define (SEGD-SET-FLC-LEN! segd flc-len) (vector-set! segd SEGD-FLC-LEN-POS flc-len))
(define (SEGD-SET-FLC! segd flc) (vector-set! segd SEGD-FLC-POS flc))


;;; The hash table element is an ENT:
;;; [ENT-TAG			; The number of this entry (diagnostic).
;;;  ENT-NEXT			; The next entry in this bucket (hash table element)
;;;  ENT-SEG			; segment number for this entry
;;;  ENT-ID			; block number for this entry
;;;  ENT-BLK			; string of length (SEG-BSIZ (ENT-SEG ent))
;;;  ENT-AGE			; aging count.  Gets bigger as time goes on
;;;  ENT-DTY			; buffer has been modified
;;;  ENT-PUS			; parent update state 1, 0 , -1 , -2
;;;  ENT-ACC			; either ACCREAD, ACCWRITE, ACCPEND, or #f.
;;;  ENT-REF]			; count of outstanding pointers to this entry and block

(define (make-ent tag)
  (vector tag #f -1 -1 (make-string blk-size #\~) 0 #f 0 #f 0))

(define ENT-TAG-POS 0)
(define ENT-NEXT-POS 1)
(define ENT-SEG-POS 2)
(define ENT-ID-POS 3) ; blk #
(define ENT-BLK-POS 4)
(define ENT-AGE-POS 5) ; grows with age, starts at 0
(define ENT-DTY-POS 6) ; needs writing out if not #f
(define ENT-PUS-POS 7) ; parent uptdate state.
(define ENT-ACC-POS 8) ; ACC-READ, ACC-WRITE, or ACC-PEND (reading)
(define ENT-REF-POS 9) ; ref count for NAME access

(define (ENT-TAG ent) (vector-ref ent ENT-TAG-POS))
(define (ENT-NEXT ent) (vector-ref ent ENT-NEXT-POS))
(define (ENT-SEG ent) (vector-ref ent ENT-SEG-POS))
(define (ENT-ID ent) (vector-ref ent ENT-ID-POS))
(define (ENT-BLK ent) (vector-ref ent ENT-BLK-POS))
(define (ENT-AGE ent) (vector-ref ent ENT-AGE-POS))
(define (ENT-DTY? ent) (vector-ref ent ENT-DTY-POS))
(define (ENT-ACC ent) (vector-ref ent ENT-ACC-POS))
(define (ENT-PUS ent) (vector-ref ent ENT-PUS-POS))
(define (ENT-REF ent) (vector-ref ent ENT-REF-POS))

(define (ENT-SET-TAG! ent tag) (vector-set! ent ENT-TAG-POS tag))
(define (ENT-SET-NEXT! ent next) (vector-set! ent ENT-NEXT-POS next))
(define (ENT-SET-SEG! ent seg) (vector-set! ent ENT-SEG-POS seg))
(define (ENT-SET-ID! ent num) (vector-set! ent ENT-ID-POS num))
(define (ENT-SET-AGE! ent age) (vector-set! ent ENT-AGE-POS age))
(define (ENT-SET-DTY! ent dty) (vector-set! ent ENT-DTY-POS dty))
(define (ENT-SET-PUS! ent pus) (vector-set! ent ENT-PUS-POS pus))
(define (ENT-SET-ACC! ent acc) (vector-set! ent ENT-ACC-POS acc))
(define (ENT-SET-REF! ent ref) (vector-set! ent ENT-REF-POS ref))

;;; BLK PREDICATES

(define (ROOT? blk) (= (BLK-ID blk) (BLK-TOP-ID blk)))

(define (END-OF-CHAIN? blk) (zero? (BLK-NXT-ID blk)))
