; Wb-tree File Based Associative String Data Base System.
; Copyright (c) 1991, 1992, 1993 Holland Mark Martin
;
;Permission to use, copy, modify, and distribute this software and its
;documentation for educational, research, and non-profit purposes and
;without fee is hereby granted, provided that the above copyright
;notice appear in all copies and that both that copyright notice and
;this permission notice appear in supporting documentation, and that
;the name of Holland Mark Martin not be used in advertising or
;publicity pertaining to distribution of the software without specific,
;written prior consent in each case.  Permission to incorporate this
;software into commercial products can be obtained from Jonathan
;Finger, Holland Mark Martin, 174 Middlesex Turnpike, Burlington, MA,
;01803-4467, USA.  Holland Mark Martin makes no representations about
;the suitability or correctness of this software for any purpose.  It
;is provided "as is" without express or implied warranty.  Holland Mark
;Martin is under no obligation to provide any services, by way of
;maintenance, update, or otherwise.


;;;	       MUMPS Style Database Phone Book Example

(make-seg 5 "mydata" 2048)
(open-seg 5 "mydata" 2)			;opens a previously created segment.
(define pb (create-db 5 #\T "phone-book")) ;create an array called
					;"phone-book" which will
					;contain the phone book
					;records.
(define pi (create-db 5 #\T "phone-index"))	;create an array called
					;"phone-index" which we will
					;use for indexing by phone
					;number.
(define lni (create-db 5 #\T "lastname-index"))
					;create an array called
					;"lastname-index" which we will
					;use for indexing by last name
(define record-number 0)

;;;MAKE-NAME is a routine which concatenates its arguments together
;;;separated by control characters.  This assures that the arguments act
;;;as independent subscripts.
(define (make-name arg1 . args)
  (apply string-append
	 (if (number? arg1) (number->string arg1) arg1)
	 (apply append
		(map (lambda (arg)
		       (cond ((equal? "" arg) (list stringofnull))
			     ((number? arg)
			      (set! arg (number->string arg))
			      (list (string (integer->char
					     (min 30 (string-length arg))))
				    arg))
			     (else (list (string (integer->char 30)) arg))))
		     args))))

(bt:put! pb (make-name record-number "LN") "Doe") ;last name
(bt:put! pb (make-name record-number "FN") "Joe") ;first name
(bt:put! pb (make-name record-number "PN") "5551212") ;phone number
(bt:put! pb (make-name record-number "AD1") "13 Hi St.") ;street address
(bt:put! pb (make-name record-number "CITY") "Podunk")
(bt:put! pb (make-name record-number "ST") "NY")
(bt:put! pb (make-name record-number "ZIP") "10000")
(bt:put! lni (make-name "Doe" record-number) "")
					;This adds index entry so that
					;(bt:next lni (make-name "Doe")) 
					;will find the record with
					;complete information.
(bt:put! pi (make-name "5551212" record-number) "")
					;similarly for looking up by
					;phone number.

;;; Note we put the record number into the key.  This is so that we
;;; can index records for more than one "Doe".

;(define doe-rec
;  (get-subscript
;   (bt:next lni (make-name "Doe"))		;returns the a name which
;   2))					;includes the record number of
					;the record.

;(bt:get pb (make-name doe-rec "PN"))	;returns Doe's Phone number.

(bt:scan pb 0 "" "zz" (lambda (k v) (print k v) #t) -1)

(close-seg 5 0)
