/* db.c: Scheme interface to WB functions
Copyright (c) 1991, 1992, 1993 Holland Mark Martin

Permission to use, copy, modify, and distribute this software and its
documentation for educational, research, and non-profit purposes and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of Holland Mark Martin not be used in advertising or
publicity pertaining to distribution of the software without specific,
written prior consent in each case.  Permission to incorporate this
software into commercial products can be obtained from Jonathan
Finger, Holland Mark Martin, 174 Middlesex Turnpike, Burlington, MA,
01803-4467, USA.  Holland Mark Martin makes no representations about
the suitability or correctness of this software for any purpose.  It
is provided "as is" without express or implied warranty.  Holland Mark
Martin is under no obligation to provide any services, by way of
maintenance, update, or otherwise. */


#include "scm.h"
/* #include "setjump.h" */
#include "sys.h"

/* used for returns of bt-get bt-next bt-prev */
static unsigned char buff[256];

static char s_iwb[] = "init-wb";
SCM iwb(max_ents, max_buks, max_size)
     SCM max_ents, max_buks, max_size;
{
  ASSERT(INUMP(max_ents),max_ents, ARG1, s_iwb);
  ASSERT(INUMP(max_buks),max_buks, ARG2, s_iwb);
  ASSERT(INUMP(max_size),max_size, ARG3, s_iwb);
  return MAKINUM(init_wb(INUM(max_ents), INUM(max_buks), INUM(max_size)));
}

SCM fwb()
{
  return MAKINUM(final_wb());
}
void final_db()
{
  final_wb();
}

static char s_open_seg[]="open-seg";
SCM lopen_seg(seg, filename, mode)
     SCM seg, filename, mode;
{
  ASSERT(INUMP(seg),seg,ARG1,s_open_seg);
  ASSERT(NIMP(filename) && STRINGP(filename),filename,ARG2,s_open_seg);
  return MAKINUM(open_seg(INUM(seg),UCHARS(filename),!(BOOL_F==mode || INUM0==mode)));
}

static char s_close_seg[]="close-seg";
SCM lclose_seg(seg,hammer)
     SCM seg, hammer;
{
  ASSERT(INUMP(seg),seg,ARG1,s_close_seg);
  return MAKINUM(close_seg(INUM(seg), NFALSEP(hammer)));
}

static char s_make_seg[]="make-seg";
SCM lmake_seg(seg,filename,bsiz)
     SCM seg,filename,bsiz;
{
  ASSERT(INUMP(seg),seg,ARG1,s_make_seg);
  ASSERT(NIMP(filename) && STRINGP(filename),filename,ARG2,s_make_seg);
  ASSERT(INUMP(bsiz),bsiz,ARG3,s_make_seg);
  return MAKINUM(make_seg(INUM(seg),UCHARS(filename),INUM(bsiz)));
}

static char s_open_bt[]="open-bt";
SCM lopen_bt(seg, blknum, wcb)
     SCM seg, blknum, wcb;
{
  SCM bthan=makstr(sizeof (HAND));
  ASSERT(INUMP(seg),seg,ARG1,s_open_bt);
  ASSERT(INUMP(blknum),blknum,ARG2,s_open_bt);
  ASSERT(INUMP(wcb),wcb,ARG3,s_open_bt);
  if (!err_P(bt_open(INUM(seg),INUM(blknum),(HAND *)CHARS(bthan),INUM(wcb))))
    return bthan;
  else return BOOL_F;
}

static char s_create_bt[]="create-bt";
SCM lcreate_bt(seg, typ, wcb)
     SCM seg, typ, wcb;
{
  SCM bthan=makstr(sizeof (HAND));
  ASSERT(INUMP(seg),seg,ARG1,s_create_bt);
  ASSERT(ICHRP(typ),typ,ARG2,s_create_bt);
  ASSERT(INUMP(wcb),wcb,ARG3,s_create_bt);
  if (!err_P(bt_create(INUM(seg),ICHR(typ),(HAND *)CHARS(bthan),INUM(wcb))))
    return bthan;
  else return BOOL_F;
}

static char s_close_bt[]="close-bt!";
SCM lclose_bt(bthan)
     SCM bthan;
{
  ASSERT(NIMP(bthan) && STRINGP(bthan),bthan,ARG1,s_close_bt);
  bt_close((HAND *)CHARS(bthan));
  return UNSPECIFIED;
}

int wrapproc(keystr, klen, vstr, vlen, long_tab)
     unsigned char *keystr;
     int klen;
     unsigned char *vstr;
     int vlen;
     unsigned long *long_tab;
{
  /* put in dynwinds = ... to return unkerr and not allow reentry to wrapproc */
  SCM res = apply((SCM)long_tab,
		  makfromstr(keystr,klen),
		  cons(makfromstr(vstr,vlen), listofnull));
  if INUMP(res) return INUM(res);
  if (BOOL_F==res) return notpres;
  if (BOOL_T==res) return success;
  if (IMP(res) || !STRINGP(res)) return typerr;
  {
    int i = LENGTH(res);
    if (i > 255) return typerr;
    while (i--) vstr[i] = CHARS(res)[i];
    return LENGTH(res);
  }
}

/* lscan(bthan, op, key1, key2, scmproc, blklim)
 returns a list of the success code, record count, and updated key. */

static char s_bt_scan[]="bt:scan";
SCM lscan(bthan, op, args)
     SCM bthan, op, args;
{
  SCM key1, key2, scmproc, blklim;
  char ikey[256];
  int ipkt[pkt_size], res;
  set_skey_count(ipkt, 0);
  ASSERT(4==ilength(args),args,WNA,s_bt_scan);
  ASSERT(NIMP(bthan) && STRINGP(bthan),bthan,ARG1,s_bt_scan);
  ASSERT(INUMP(op), op, ARG2, s_bt_scan);
  key1 = CAR(args); args = CDR(args);
  ASSERT(NIMP(key1) && STRINGP(key1),key1,ARG3,s_bt_scan);
  key2 = CAR(args); args = CDR(args);
  ASSERT(NIMP(key2) && STRINGP(key2),key1,ARG4,s_bt_scan);
  scmproc = CAR(args); args = CDR(args);
  ASSERT(FALSEP(scmproc) || NIMP(scmproc) && BOOL_T==procedurep(scmproc),
	 scmproc, ARG5, s_bt_scan);
  blklim = CAR(args); args = CDR(args);
  ASSERT(INUMP(blklim), blklim, ARG5, s_bt_scan);
  set_skey_len(ipkt, LENGTH(key1));
  memcpy(ikey,CHARS(key1),LENGTH(key1));
  res = bt_scan(CHARS(bthan), INUM(op),
		ikey, skey_len(ipkt),
		CHARS(key2), LENGTH(key2),
		FALSEP(scmproc) ? 0 : wrapproc, scmproc,
		ipkt, INUM(blklim));
  return cons2(MAKINUM(res),
	       MAKINUM(skey_count(ipkt)),
	       cons(makfromstr(ikey,skey_len(ipkt)),EOL));
}

static char s_bt_get[]="bt:get";
SCM lbt_get(bthan, key)
     SCM bthan, key;
{
  ASSERT(NIMP(bthan) && STRINGP(bthan),bthan,ARG1,s_bt_get);
  ASSERT(NIMP(key) && STRINGP(key),key,ARG2,s_bt_get);
  {
    int tlen = bt_get((HAND *)CHARS(bthan),UCHARS(key),LENGTH(key),buff);
    if (tlen >= 0) return makfromstr(buff, tlen);
    return BOOL_F;
  }
}

static char s_bt_next[]="bt:next";
SCM lbt_next(bthan, key)
     SCM bthan, key;
{
  int klen = 0;
  ASSERT(NIMP(bthan) && STRINGP(bthan),bthan,ARG1,s_bt_next);
  if FALSEP(key) {key=nullstr; klen = start_of_chain;}
  ASSERT(NIMP(key) && STRINGP(key),key,ARG2,s_bt_next);
  if (!klen) klen = LENGTH(key);
  if (!klen) {key=nullstr; klen = start_of_chain;}
  {
    int tlen = bt_next((HAND *)CHARS(bthan),UCHARS(key),klen,buff);
    if (tlen >= 0) return makfromstr(buff, tlen);
    return BOOL_F;
  }
}

static char s_bt_prev[]="bt:prev";
SCM lbt_prev(bthan, key)
     SCM bthan, key;
{
  int klen = 0;
  ASSERT(NIMP(bthan) && STRINGP(bthan),bthan,ARG1,s_bt_prev);
  if FALSEP(key) {key=nullstr; klen = end_of_chain;}
  ASSERT(NIMP(key) && STRINGP(key),key,ARG2,s_bt_prev);
  if (!klen) klen = LENGTH(key);
  if (!klen) {key=nullstr; klen = start_of_chain;}
  {
    int tlen = bt_prev((HAND *)CHARS(bthan),UCHARS(key),klen,buff);
    if (tlen >= 0) return makfromstr(buff, tlen);
    return BOOL_F;
  }
}

static char s_bt_rem[]="bt:rem!";
SCM lbt_rem(bthan, key)
     SCM bthan, key;
{
  ASSERT(NIMP(bthan) && STRINGP(bthan),bthan,ARG1,s_bt_rem);
  ASSERT(NIMP(key) && STRINGP(key),key,ARG2,s_bt_rem);
  if (!bt_rem((HAND *)CHARS(bthan),UCHARS(key),LENGTH(key), 0L))
    return BOOL_T;
  else return BOOL_F;
}

static char s_bt_read[]="bt:rem";
SCM lbt_read(bthan, key)
     SCM bthan, key;
{
  int tlen;
  ASSERT(NIMP(bthan) && STRINGP(bthan),bthan,ARG1,s_bt_read);
  ASSERT(NIMP(key) && STRINGP(key),key,ARG2,s_bt_read);
  tlen = bt_rem((HAND *)CHARS(bthan),UCHARS(key),LENGTH(key), buff);
  if (tlen >= 0) return makfromstr(buff,tlen);
  return BOOL_F;
}

static char s_bt_rem_star[]="bt:rem*";
SCM lbt_rem_star(bthan, key, key2)
     SCM bthan, key, key2;
{
  char tmpstr[256];
  ASSERT(NIMP(bthan) && STRINGP(bthan),bthan,ARG1,s_bt_rem_star);
  ASSERT(NIMP(key) && STRINGP(key),key,ARG2,s_bt_rem_star);
  memcpy(tmpstr,CHARS(key),LENGTH(key));
  if (!bt_rem_range((HAND *)CHARS(bthan),UCHARS(key),LENGTH(key),
		    UCHARS(key2), LENGTH(key2)?LENGTH(key2):end_of_chain))
    return BOOL_T;
  else return BOOL_F;
}

static char s_bt_put[]="bt:put!";
SCM lbt_put(bthan, key, val)
     SCM bthan, key, val;
{
  ASSERT(NIMP(bthan) && STRINGP(bthan),bthan,ARG1,s_bt_put);
  ASSERT(NIMP(key) && STRINGP(key),key,ARG2,s_bt_put);
  ASSERT(NIMP(val) && STRINGP(val),val,ARG3,s_bt_put);
  if (!bt_put((HAND *)CHARS(bthan),
	      UCHARS(key),LENGTH(key),
	      UCHARS(val),LENGTH(val)))
    return BOOL_T;
  else return BOOL_F;
}

static char s_bt_write[]="bt:put";
SCM lbt_write(bthan, key, val)
     SCM bthan, key, val;
{
  ASSERT(NIMP(bthan) && STRINGP(bthan),bthan,ARG1,s_bt_write);
  ASSERT(NIMP(key) && STRINGP(key),key,ARG2,s_bt_write);
  ASSERT(NIMP(val) && STRINGP(val),val,ARG3,s_bt_write);
  if (!bt_write((HAND *)CHARS(bthan),
		UCHARS(key),LENGTH(key),
		UCHARS(val),LENGTH(val)))
    return BOOL_T;
  else return BOOL_F;
}

static char s_create_db[]="create-db";
SCM lcreate_db(seg, typ, name)
     SCM seg, typ, name;
{
  SCM a_han;
  SCM d_han;
  SCM tmp_str=makstr(5);
  ASSERT(INUMP(seg),seg,ARG1,s_create_db);
  ASSERT(ICHRP(typ),typ,ARG2,s_create_db);
  ASSERT(NIMP(name) && STRINGP(name),name,ARG3,s_create_db);
  a_han=lcreate_bt(seg,typ,INUM0);
  d_han=lopen_bt(seg,MAKINUM(1),INUM0);
  CHARS(tmp_str)[0]=4;
  long2str(UCHARS(tmp_str), 1, han_id(CHARS(a_han)));
  lbt_put(d_han,name,tmp_str);
  lclose_bt(d_han);
  return a_han;
}

static char s_open_db[]="open-db";
SCM lopen_db(seg, name)
     SCM seg, name;
{
  SCM d_han, nn;
  ASSERT(INUMP(seg),seg,ARG1,s_open_db);
  ASSERT(NIMP(name) && STRINGP(name),name,ARG2,s_open_db);
  d_han=lopen_bt(seg,MAKINUM(1),INUM0);
  nn = lbt_get(d_han,name);
  if (NIMP(nn) && STRINGP(nn) && (LENGTH(nn)>4) && (CHARS(nn)[0]==4))
    return lopen_bt(seg, MAKINUM(str2long(UCHARS(nn)+1,0)),INUM0);
  else return BOOL_F;
}

SCM lcheck_access()
{
  check_access();
  return UNSPECIFIED;
}

SCM lclear()
{
  clear_stats();
  return UNSPECIFIED;
}

SCM lstats()
{
  stats();
  return UNSPECIFIED;
}

SCM lcstats()
{
  cstats();
  return UNSPECIFIED;
}

SCM lsb()
{
  sb();
  return UNSPECIFIED;
}

static char s_s2l[] = "str2long";
SCM s2l(str, pos)
     SCM str, pos;
{
  ASSERT(NIMP(str) && STRINGP(str), str, ARG1, s_s2l);
  ASSERT(INUMP(pos), pos, ARG2, s_s2l);
  ASSERT(LENGTH(str) >= INUM(pos) + 4, pos, OUTOFRANGE, s_s2l);
#ifdef BIGDIG
  {
    unsigned long sl = str2long(CHARS(str), INUM(pos));
    if (!POSFIXABLE(sl)) return long2big(sl);
    return MAKINUM(sl);
  }
#else
  return MAKINUM(str2long(CHARS(str), INUM(pos)));
#endif
}

static char s_l2s[] = "long2str!";
SCM l2s(str, pos, clong)
     SCM str, pos, clong;
{
  unsigned long clng = 0;
  ASSERT(NIMP(str) && STRINGP(str), str, ARG1, s_l2s);
  ASSERT(INUMP(pos), pos, ARG2, s_l2s);
  ASSERT(NUMBERP(clong), clong, ARG3, s_l2s);
  ASSERT(LENGTH(str) >= INUM(pos) + 4, pos, OUTOFRANGE, s_l2s);
#ifdef BIGDIG
  if NINUMP(clong) {
    sizet l;
    ASSERT(NIMP(clong) && TYP16(clong)==tc16_bigpos,clong,ARG1,s_l2s);
    for(l = NUMDIGS(clong);l--;) clng = BIGUP(clng) + BDIGITS(clong)[l];
  }
  else
#else
    ASSERT(INUMP(clong),clong,ARG1,s_l2s);
#endif
  clng = INUM((unsigned long)clong);
  long2str(CHARS(str), INUM(pos), clng);
  return UNSPECIFIED;
}

static iproc subr0s[]={
	{"final-wb",fwb},
	{"check-access!",lcheck_access},
	{"clear-stats",lclear},
	{"stats",lstats},
	{"cstats",lcstats},
	{"show-buffers",lsb},
	{0,0}};

static iproc subr1s[]={
	{s_close_bt,lclose_bt},
	{0,0}};

static iproc subr2s[]={
	{s_close_seg,lclose_seg},
	{s_bt_get,lbt_get},
	{s_bt_next,lbt_next},
	{s_bt_prev,lbt_prev},
	{s_bt_rem,lbt_rem},
	{s_bt_read,lbt_read},
	{s_open_db,lopen_db},
	{s_s2l, s2l},
	{0,0}};

static iproc subr3s[]={
	{s_iwb,iwb},
	{s_open_seg,lopen_seg},
	{s_make_seg,lmake_seg},
	{s_open_bt,lopen_bt},
	{s_create_bt,lcreate_bt},
	{s_bt_put,lbt_put},
	{s_bt_write,lbt_write},
	{s_create_db,lcreate_db},
	{s_bt_rem_star,lbt_rem_star},
	{s_l2s, l2s},
	{0,0}};

void init_db()
{
  init_iprocs(subr0s, tc7_subr_0);
  init_iprocs(subr1s, tc7_subr_1);
  init_iprocs(subr2s, tc7_subr_2);
  init_iprocs(subr3s, tc7_subr_3);
  make_subr(s_bt_scan,tc7_lsubr_2,lscan);
  add_final(final_db);
}
