;;; menu-test.scm -- example of how menu might be used.
;;;
;;; Surely this is too complicated.

(require "scm_dir:smgdef.scm")
(require "scm_dir:menu.scm")

(define (menu-test)
  ;; The variables to hold SMG info.
  (define pbd (vector-ref (smg$create_pasteboard) 1))
  (define kbd (vector-ref (smg$create_virtual_keyboard) 1))
  (define dpy (vector-ref (smg$create_virtual_display 21 78 SMG$M_BORDER) 1))
  (define edpy (vector-ref (smg$create_virtual_display 1 80) 1))

  ;; Misc functions.
  (define (get-key)
    (vector-ref (smg$read_keystroke kbd) 1))

  (define (message str . options)
    (if str
	(smg$put_chars edpy str 1 1 SMG$M_ERASE_TO_EOL))
    (if (member 'bell options)
	(smg$ring_bell edpy))
    (if (member 'get-key options)
	(get-key))
    (if (not (member 'sticky options))
	(smg$erase_display edpy)))

  (define (make-choices-vector vec-len)
    (let ((vec (make-vector vec-len)))
      (do ((i 0 (+ i 1)))
	  ((>= i vec-len) vec)
	(vector-set! vec i (string-append "Line " (number->string i))))))

  (define (get-int dpy default len row col)
    (let loop ((result (read-string dpy kbd default len row col
				    (list SMG$K_TRM_CTRLM SMG$K_TRM_CTRLZ
					  SMG$K_TRM_F20))))
      (cond ((or (= (cdr result) SMG$K_TRM_CTRLZ)
		 (= (cdr result) SMG$K_TRM_F20))
	     #f)
	    ((not (string->number (car result)))
	     (message (string-append "`" (car result)
				     "' is not a number!  Press any key!")
		      'get-key 'bell)
	     (loop (read-string dpy kbd (car result) len row col
				(list SMG$K_TRM_CTRLM SMG$K_TRM_CTRLZ))))
	    (else
	     (string->number (car result))))))

  (define (every fun-list arg-list)
    (let loop ((fun-list fun-list)
	       (arg-list arg-list)
	       (acc '()))
      (if (or (null? fun-list)
	      (null? arg-list))
	  (reverse acc)
	  (let ((obj ((car fun-list) (car arg-list))))
	    (if obj
		(loop (cdr fun-list) (cdr arg-list) (cons obj acc))
		#f)))))

  (define prompt-list
    (list (lambda (num-choices)
	    (smg$put_chars dpy "Number of Choices: " 2 1 SMG$M_ERASE_TO_EOL)
	    (get-int dpy (number->string num-choices) 5 2 21))
	  (lambda (menu-height)
	    (smg$put_chars dpy "Menu Height: " 3 7 SMG$M_ERASE_TO_EOL)
	    (get-int dpy (number->string menu-height) 5 3 21))
	  (lambda (start-index)
	    (smg$put_chars dpy "Start Index: " 4 7 SMG$M_ERASE_TO_EOL)
	    (get-int dpy (number->string start-index) 5 4 21))))

  ;; Set up the screen.
  (smg$label_border dpy " Press Ctrl-Z or F20 to exit " #f #f SMG$M_REVERSE)
  (smg$paste_virtual_display dpy pbd 2 2)
  (smg$paste_virtual_display edpy pbd 24 1)

  ;; Let the user play with various sized menus.
  (let loop ((i 0)
	     (info (every prompt-list '(200 10 1))))
    (cond
     (info
      (let ((result
	     (menu (make-choices-vector (car info))
		   pbd kbd (cadr info) 70 3 3 (caddr info)
		   (string-append " Test Menu " (number->string i) " "))))
	(cond
	 (result
	  (message (string-append "You picked item " (number->string result)
				  ".  Press any key to continue.")
		   'get-key)
	  (loop (+ i 1) (every prompt-list info)))
	 (else
	  (message "Nothing chosen; press any key to exit." 'get-key)))))
     (else
      (message "Exiting..." 'sticky))))

  ;; cleanup
  (smg$set_physical_cursor pbd 24 70)
  (newline)
  (smg$delete_pasteboard pbd 0)
  (smg$delete_virtual_keyboard kbd)
  (smg$delete_virtual_display dpy)
  (smg$delete_virtual_display edpy)
  'done)

(menu-test)
