;;;
;;;              Copyright 1991 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;;
;;; widget.sc -- the base class for the STOX class hierarchy.
;;;

;;; $Id: widget.sc,v 1.1 91/09/15 00:58:33 johani Exp $

(module stoxwidget)

(include "../include/masks.sch")
(include "../include/objects.sch")
(include "../include/lw-objs.sch")
(include "../include/util.sch")

(define-external dfsm stoxdfsm)

(include "../macros/extsyntax.sc")
(include "../macros/oos.sc")

;;; widgets should at least respond to the messages 'position 'move 'deltamove
;;; 'size 'resize 'status 'free 'activate 'add-transit! 'change-transit! and
;;; 'transit. The transit-messages are less thought out than the others.

(define-class (widget . args)
  (locals
   (parent (match-arg 'parent 'no-default args))
   (scr    (match-arg 'screen (parent 'screen ) args))
   (bw     (match-arg 'border-width 1 args))
   (hstretch (match-arg 'hstretch 0 args))
   (vstretch (match-arg 'vstretch 0 args))
   (value-mask (match-arg 'value-mask (make-window-value-mask
				       `(background-pixel ,(scr 'blackpixel)))
			  args))
   ;; (state 'inactive) Obsolete.
   (cached-dfsm-alphabet #f)			     
   (natural-width (match-arg 'width 50 args))
   (move-mask (make-configure-value-mask))
   (size-mask (make-configure-value-mask)) )
  (inherit
   (window (cons* 'screen scr 'mask value-mask 'border-width bw args))
   (dfsm args) )
  (methods
   (scix-event-dispatch (lambda (ev-source obj)
			  (let ((ev-l (if (pair? ev-source)
					  ev-source
					  (ev-source 'my-events! obj))))
			    (let loop ((ev-l ev-l))
			      (if (not (null? ev-l))
				  (let* ((e (car ev-l))
					 (event-name (e 'event-name)) )
				    (cond ((memq event-name 
						 cached-dfsm-alphabet)
					   (me 'dfsm-transit event-name e)
					   (loop (cdr ev-l)))
					  ((eq? event-name 'Expose)
					   (if (zero? (e 'count))
					       (inner-me 'stox-expose e))
					   (loop (cdr ev-l)))
					  (else
					   (me '(window scix-event-dispatch)
					       (list e) me) ; KLUGE!!
					   )))))
			    (scr 'flush!) )))
   ;; Obsolete
   ;; (state (lambda () state))
   (natural-width (lambda () natural-width))
   (move (lambda (newx newy)
	   (if (or (not (eqv? (me 'x) newx)) (not (eqv? (me 'y) newy)))
	       (begin
		 (if newx (begin
			    (me 'set-x! newx)
			    (move-mask 'set! `(x ,newx)) ))
		 (if newy (begin
			    (me 'set-y! newy)
			    (move-mask 'set! `(y ,newy)) ))
		 (me 'configurewindow move-mask)
		 (scr 'flush!) ))))
   (deltamove (lambda (dx dy)
		(if (or (not (zero? dx)) (not (zero? dy)))
		    (begin
		      (me 'set-x! (+ (me 'x) dx))
		      (me 'set-y! (+ (me 'y) dy))
		      (move-mask 'set! `(x ,(me 'x)) `(y ,(me 'y)))
		      (me 'configurewindow move-mask)
		      (scr 'flush!) ))))
   (resize (lambda (newwidth newheight)
	     (if (or (not (eqv? (me 'width) newwidth))
		     (not (eqv? (me 'height) newheight)))
		 (begin
		   (if newwidth
		       (begin
			 (me 'set-width! newwidth)
			 (size-mask 'set! `(width ,newwidth)) ))
		   (if newheight
		       (begin
			 (me 'set-height! newheight)
			 (size-mask 'set! `(height ,newheight)) ))
		   (me 'configurewindow size-mask)
		   (scr 'flush!) ))))
   (hstretch (lambda () hstretch))
   (vstretch (lambda () vstretch))
   (stox-activate (lambda ()
		    (me 'mapwindow) ))
   (stox-free (lambda ()
		(me 'dfsm-halt)	; Halt the dfsm to avoid unwanted
		                ; graphics action during death scene.
		(me 'destroywindow) ))
   
   (scix-denounce-id! (lambda ()
			(me 'dfsm-halt)
			(me '(window scix-denounce-id!)) ))

   ;; stox-fake-event fakes the arrival of an event of the type name.
   ;; If the event object is queried for anything it is necessarry to
   ;; use 'dfsm-transit directly and to supply a well-behaved event object.
   (stox-fake-event (lambda (name) (me 'dfsm-transit name #f) ))
   
   (stox-expose (lambda (e)
		  (scix-msg "WIDGET: ~a fell through on 'stox-expose~%"
			    (inner-me 'object-class) )))
   )
  (init
   (set! cached-dfsm-alphabet (me 'dfsm-alphabet)) )
  )
