;;;
;;;              Copyright 1991 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;;
;;; text.sc -- a window in which a fixedfont text is shown with an associated
;;;            scrollbar.

;;; Note: The current implementation is slower than necessary, since it uses
;;;       a two-step process to show new text: First the scrollbar is moved.
;;;       This causes a 'stox-notify-move message to be sent here, whereupon
;;;       the subwindow inside the clipwindow is moved (through a Configure-
;;;       Window). This move causes Expose-events to be sent to the subwindow
;;;       and so, finally, the newly exposed parts are repainted. An immediate
;;;       optimization would be to make the calculation of exposed areas
;;;       directly from the information about how much the thumb (in the
;;;       scrollbar) moved and then ignore the Expose-events. The problem is
;;;       how to efficiently discriminate between such discardable Exposes
;;;       and other, legitimate, ones.

;;; $Id: text.sc,v 2.4 91/09/15 00:58:31 johani Exp $

(module stoxtext)

(include "../include/scix.sch")
(define-external widget stoxwidget)
(define-external scrollbar stoxscrollbar)
(define-external button stoxbutton)
(define-external container stoxcont)
(define-external hbox stoxbox)
(define-external vbox stoxbox)
(define-external hfill stoxbox)
(define-external hskip stoxbox)
(define-external vskip stoxbox)

(include "../macros/extsyntax.sc")
(include "../macros/oos.sc")

;;;
;;; Text-window 
;;;
(define-class (text-window . args)
  (locals
   (parent      (match-arg 'parent 'no-default args))
   (scr         (match-arg 'screen (parent 'screen) args))
   (gcache      (match-arg 'gcache (scr 'gcache) args))
   (the-gc      ((scr 'gcache) 'gc-draw))
   (text-vec    (match-arg 'text `#(,(imagetext8 'make 1 20 "Default text"))
			   args))
   (subw #f) (sb #f) (quit #f) (clipw #f)
   (lsize       (the-gc 'querytextextents (s8->s16 (make-string 80 #\M))))
   (blh         (+ (lsize 'font-ascent) (lsize 'font-descent)))
   (last-line   (max 1
		     (min (- (vector-length text-vec) 1)
			  (match-arg 'last-line 
				     (- (vector-length text-vec) 1)
				     args))))
   (first-line  (min last-line (max 1 (match-arg 'first-line 1 args))))
   (text-length (max 1 (+ 1 (- last-line first-line))))
   (rows        (match-arg 'rows (min 20 text-length)  args))
   (start-line  (min (- last-line rows -1)
		     (max 1 (match-arg 'start-line first-line args))))
   (subw-y 0)
   (height      (+ 32 (* rows blh)))
   (subw-height (* last-line blh))
   (pixel->row  (lambda (y-pixel)
		  (+ 1 (inexact->exact (/ y-pixel blh))))) )
  (inherit
   (container (cons* 'border-width 1
		     ;; 'width (+ (lsize 'overall-width)
		     ;;			       (if (> text-length rows) 17 2))
		     ;; 'height height
		     'value-mask (make-window-value-mask
				  `(background-pixel ,(scr 'whitepixel)) )
		     args)) )
  (methods
   (stox-activate (lambda ()
		    (subw 'mapwindow)
		    (for-each (lambda (o) (o 'stox-activate))
			      (list sb clipw quit) )
		    (me 'mapwindow) ))
;   (text-window (lambda () subw))	; Just a test and arguably wrong.
   )
   (init
    (set! sb (scrollbar 'make 'parent me 'height (* rows blh)))
    (set! clipw (widget 'make 'parent me 'height (* rows blh)
			'width (+ 2 (lsize 'overall-width) )))
    (set! quit (button 'make 'label "Quit" 'parent me 'gcache gcache
		       'on-action (lambda (e) (me 'stox-free)) ))
    (set! subw (window 'make 'parent clipw 'screen scr
		       'x 0 'y (* (- 1 start-line) blh)
		       'width (clipw 'width) 'height subw-height
		       'mask (make-window-value-mask
			      `(background-pixel ,(scr 'whitepixel))
			      `(event-mask ,(make-mask 'event 'Exposure)))))

    (me 'set-box! (vbox (hbox sb (hskip -1) clipw)
			(vskip 3)
			(hbox (hskip 3) quit (hfill))
			(vskip 3) ))
    ;; Configure the scrollbar.
    (sb 'stox-thumb-percent (/ rows text-length))
    (if (> start-line first-line)
	(sb 'stox-set-thumb (/ (- start-line first-line) text-length)) )

    ;; Define the procedure that recieves and acts on the scrollbar's moves.
    (sb 'stox-notify-move
	(let ((new-y 0) (conf-mask (make-configure-value-mask)))
	  (lambda (p)
	    (cond ((= p 1)
		   (set! new-y (- (* rows blh) subw-height)))
		  (else 
		   (set! new-y
			 (inexact->exact (- (* blh
					       (+ (- first-line 1)
						  (* p text-length))))))))
	    (if (not (= new-y subw-y))
		(begin
		  (set! subw-y new-y)
		  (conf-mask 'set! `(y ,subw-y))
		  (subw 'configurewindow conf-mask) ))
	    (scr 'flush!) )))

    (subw 'add-callback! 'Expose
	  (lambda (e w)
	    (subw 'draw (let loop ((r '())
				   (lineno (max 1 (pixel->row (e 'y))))
				   (last (min (pixel->row (+ (e 'y)
							     (e 'height) ))
					      last-line )))
			  (if (<= lineno last)
			      (loop (cons (vector-ref text-vec lineno) r)
				    (+ lineno 1)
				    last)
			      r)) the-gc)
	    (scr 'flush!) ))
    ))
