;;;
;;;              Copyright 1990 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;;
;;; menus.sc -- a first attempt. Menus have turned out to be more difficult
;;;             than the other sample widgets to hack together. Mostly because
;;;             of our confusion with grabs.

;;; $Id: menus.sc,v 1.1 91/09/15 00:58:28 johani Exp $

(module stoxmenu)

(include "../include/masks.sch")
(include "../include/objects.sch")
(include "../include/lw-objs.sch")
(include "../include/util.sch")

(define-external dfsm stoxdfsm)
(define-external widget stoxwidget)

(include "../macros/extsyntax.sc")
(include "../macros/oos.sc")

;;;
;;; Menu
;;;
(define-class (pulldown-menu . args)
  (locals
   (parent (match-arg 'parent 'no-default args))
   (scr (parent 'screen))
   (gcache (match-arg 'gcache (scr 'gcache) args))
   (gc-draw  (gcache 'gc-draw))
   (gc-clear (gcache 'gc-clear))
   (gc-invert  (gcache 'gc-invert))
   (the-popup #f)
   (c-mask (make-configure-value-mask (list 'x 0) (list 'y 0)
				      '(stack-mode Above)))
   (label (match-arg 'label "Menu" args))
   (lsize (if label (gc-draw 'querytextextents (s8->s16 label))))
   (ptr (scr 'pointer))
   (text (if label 
	     (list (imagetext8 'make 4 (+ 4 (lsize 'font-ascent))
			       label))))
   (width  (match-arg 'width (if label
				 (+ 8 (lsize 'overall-width))
				 30)
		      args))
   (height (match-arg 'height (if label
				  (+ 8 (lsize 'font-ascent)
				     (lsize 'font-descent))
				  20)
		      args))
   (high-light 
    (list (polyrectangle 'make `((1 1 ,(- width 3) ,(- height 3))))) )
   (rev-area
    (list (polyfillrectangle 'make `((1 1 ,(- width 2) ,(- height 2))))) )

   (semantics
    `(((Anywhere . ButtonRelease)
       Anywhere ,(lambda (e)
		   (me 'stox-close-menu)
		   (scr 'flush!) ))
      ((Anywhere . ButtonPress)
       Anywhere ,(lambda (e)
		   (ptr 'changeactivepointergrab 'None 'CurrentTime
			(make-mask 'event 'ButtonRelease))
		   (c-mask 'set!
			   `(x ,(- (e 'root-x) (e 'event-x)
				   (me 'border-width) ))
			   `(y ,(+ 1 (- (e 'root-y) (e 'event-y))
				   (me 'height) (me 'border-width) )))
		   (the-popup 'configurewindow c-mask)
		   (me 'stox-open-menu)
		   (scr 'flush!) ))
      ((Anywhere . Expose) Anywhere
			   ,(lambda (e)
			      (me 'draw text gc-draw) ))))
   )
  (inherit
   (widget (cons* 'width width 'height height
		  'dfsm-data (list 'Anywhere #f semantics)
		  'value-mask
		  (make-window-value-mask 
		   `(background-pixel ,(gcache 'background))
		   `(event-mask ,(make-bitmask 'event 'ButtonPress 'Exposure)))
		  args)) )
  (methods
   (label (lambda ()
	    (if label label #f) ))
   (stox-free (lambda ()
		(the-popup 'stox-free)
		(me '(widget stox-free)) ))
   (stox-open-menu (lambda ()
		     (the-popup 'mapwindow) ))
   (stox-close-menu (lambda ()
		      (the-popup 'unmapwindow) ))
   (scix-announce-destroy (lambda ()
			    (the-popup 'destroywindow) ))
   )
  (init
   (me 'grabbutton #t (make-mask 'PointerEvent 'ButtonPress)
       'Asynchronous 'Asynchronous 'None 'None 'AnyButton 'AnyModifier)
   (set! the-popup
	 (apply popup-menu
		(cons* 'make 'parent (scr 'root) 'gcache gcache args)))
   ))

;;;
;;; Popup-menu
;;;
(define-class (popup-menu . args)
  (locals
   (parent    (match-arg 'parent 'no-default args))
   (scr       (match-arg 'screen (parent 'screen) args))
   (gcache    (match-arg 'gcache (scr 'gcache) args))
   (gc-draw   (gcache 'gc-draw))
   (gc-invert (gcache 'gc-invert))
   (old-index 0)
   (entries   (match-arg 'entries
			 `(("Foo" . ,(lambda () (display (format "Foo~%"))))
			   ("Bar" . ,(lambda () (display (format "Bar~%")))) )
			 args))
   (strs      (map car entries))
   (lsize     (gc-draw 'querytextextents (s8->s16 "Mi")))
   (width     (inexact->exact (+ 5 (/ (* (lsize 'overall-width)
					 (apply max (map string-length strs)))
				      2))))
   (font-h    (+ (lsize 'font-ascent) (lsize 'font-descent)))
   (labels    (make-imagetexts strs (lsize 'font-ascent) font-h))
   (rects     (make-filledrectangles (vector-length labels) font-h width))
   (actions   (list->vector (cons #f (map cdr entries))))
   (semantics
    `(((Anywhere . MotionNotify)
       Anywhere
       ,(let ((new-index #f))
	  (lambda (e)
	    (set! new-index (inexact->exact (+ 1 (/ (e 'event-y) font-h))))
	    (if (not (= new-index old-index))
		(begin
		  (if (positive? old-index)
		      (me 'draw (vector-ref rects old-index) gc-invert) )
		  (if (positive? new-index)
		      (me 'draw (vector-ref rects new-index) gc-invert) )
		  (set! old-index new-index)
		  (scr 'flush!) )))))
      ((Anywhere . ButtonRelease) Anywhere
				  ,(let ((launch-index 0))
				     (lambda (e)
				       (me '(widget unmapwindow))
				       (set! launch-index old-index)
				       (set! old-index 0)
				       (if (vector-ref actions launch-index)
					   ((vector-ref actions launch-index))
					   ))))
      ((Anywhere . LeaveNotify) Anywhere
				,(lambda (e)
				   (if (positive? old-index)
				       (begin
					 (me 'draw (vector-ref rects old-index)
					     gc-invert)
					 (scr 'flush!)
					 (set! old-index 0) )))) ))
				   
   )
  (inherit
   (widget (cons* 'height (* (- (vector-length labels) 1) font-h)
		  'width width
		  'value-mask
		  (make-window-value-mask
		   `(background-pixel ,(scr 'whitepixel))
		   `(save-under        #t)
		   `(override-redirect #t)
		   ;; No need to worry about Expose here, but in a future
		   ;; tear-off menu it might happen...
		   `(event-mask ,(make-mask 'event 'Exposure 'ButtonMotion
					    'ButtonRelease 'LeaveWindow)))
		  'dfsm-data (list 'Anywhere #f semantics)
		  args)))
  (methods
   (unmapwindow (lambda ()
		  (set! old-index 0)
		  (me '(widget unmapwindow)) ))
   (stox-expose (lambda (e)
		  (me 'draw (apply append (cdr (vector->list labels))) gc-draw)
		  (scr 'flush!) ))
   ))

(define (make-imagetexts strs first-y delta-y)
  (let loop ((r '()) (strs strs) (y first-y))
    (if (null? strs)
	(list->vector (cons #f (reverse r)))
	(loop (cons (list (imagetext8 'make 1 y (car strs))) r)
	      (cdr strs)
	      (+ y delta-y)))))

(define (make-filledrectangles nr delta-y width)
  (let loop ((r '()) (count 0))
    (if (= count nr)
	(list->vector (cons #f (reverse r)))
	(loop (cons (list (polyfillrectangle 
			   'make `((0 ,(* count delta-y) ,width ,delta-y))))
		    r)
	      (+ count 1)))))
