;;;
;;;              Copyright 1991 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;;
;;; label.sc -- a simple self-supporting text in an arbitrary typeface in
;;;             a separate window.
;;;
;;;          Note: The method 'set-label! is intended to increase efficiency
;;;                by allowing mutation of an exisiting label (read window).
;;;                Otherwise it would be necessary to first destroy the label
;;;                and then create a new one to change a text. The problem is
;;;                that when the text now can change the window size is still
;;;                static. Maybe we ought to spend some of the efficiency gain
;;;                on a ConfigureWindow to resize the window also? Probably...
;;;               
;;;          Problems:
;;;           0) Not yet decided on how to specify insertion point.
;;;           1) Not very efficient: uses its own window and does lots of
;;;              stuff when the label text is changed. It inherits a dfsm
;;;              that is hardly used. It should be possible to have a window-
;;;              less label if we had a mechanism a la 'add-callback! specifi-
;;;              cally for Expose in widget.
;;;           2) The text is possibly misplaced by a pixel downwards.
;;;           3) Probably not general enough to handle all combinations
;;;              of colours etc.

;;; $Id: label.sc,v 2.2 91/09/15 00:58:27 johani Exp $

(module stoxlabel)

(include "../include/masks.sch")
(include "../include/objects.sch")
(include "../include/lw-objs.sch")
(include "../include/util.sch")

(define-external dfsm stoxdfsm)
(define-external widget stoxwidget)
(define-external add-new-args stoxutil)

(include "../macros/extsyntax.sc")
(include "../macros/oos.sc")

(define-class (label . args)
  (locals
   (scr    ((match-arg 'parent 'no-default args) 'screen))
   (gcache (match-arg 'gcache (scr 'gcache) args))
   (mygc   (gcache 'gc-draw))
   (label  (match-arg 'label "" args))
   (lsize  (mygc 'querytextextents (s8->s16 label)))
   (width (max 1 (match-arg 'width (lsize 'overall-width) args)))
   (the-mask (make-configure-value-mask))
   (blanks (list (imagetext8 'make
			     1 (+ (lsize 'font-ascent) (lsize 'font-descent))
			     (make-string 100 #\space) )))
   (text   (imagetext8 'make 1 (+ (lsize 'font-ascent) (lsize 'font-descent))
		       label))
   (semantics `(((Anytime . Expose) Anytime
				    ,(lambda (e)
				       (me 'draw (list text) mygc)
				       (scr 'flush!) ))))
   )
  (inherit
   (widget (cons* 'width width 'height (+ (* 2 (lsize 'font-descent))
					  (lsize 'font-ascent))
		  'border-width 0
		  'value-mask (make-window-value-mask 
			       `(background-pixel ,(gcache 'background))
			       `(event-mask ,(make-bitmask 'event 'Exposure)))
		  'dfsm-data (list 'Anytime #f semantics)
		  args)) )
  (methods
   (set-label! (lambda (new-label)
		 (set! label new-label)
		 (text 'set-text! label)
		 (set! width (max 1 ((mygc 'querytextextents (s8->s16 label))
				     'overall-width) ))
		 (the-mask 'set! `(width ,width))
		 (me 'configurewindow the-mask)
		 (me 'stox-fake-event 'Expose) ))
   (width (lambda () width) )		; A local width selector as width
					; may change. Kludge? Yes.
   ))

  


