;;;
;;;              Copyright 1990 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;

;;; shapetest.sc -- a short experiment with the shape extension found in
;;;                 the MIT R4 server. 18/6 1990 Johan Ihren.
;;;                 Only the new requests ShapeRectangles and ShapeMask are
;;;                 tested yet.

;;; $Id$

;;; shape-test -- creates two windows using the shape extension. Returns a
;;;               list of these two windows.
(module shapetest)

(define (shape-test scr)
  (activate-shape-extension scr)
  (let ((pmap (pixmap 'make 'width 300 'height 300 'depth 1 'screen scr))
	(win1 (shape-window 'make 'width 300
			    'height 300 'border-width 6 'screen scr))
	(win2 (shape-window 'make 'width 300 'height 300 'border-width 6 
			    'screen scr 'value-mask
			    (make-window-value-mask
			     `(background-pixel ,(scr 'blackpixel)) )))
	(gc-clear ((scr 'gcache) 'gc-clear))
	(gc-set   ((scr 'gcache) 'gc-draw))
	(size 300) )
    (scix-msg "Windows created.~%")
    (pmap 'draw
	  (list (polyfillrectangle 'make `((0 0 ,size ,size)))) gc-clear)
    (pmap 'draw (list (polyfillarc 'make `((0 0 ,size ,size 0 ,(* 64 360)))))
	  gc-set)
    (scix-msg "Pixmap drawn.~%")
    (win1 'shapemask 'Set 'Bounding 0 0 pmap)
    (scix-msg "win1 'shapemask done.~%")
    (win1 'changeproperty 'replace 'wm_name 'string 8 "SCIX: ShapeMask Test")
    (win1 'mapwindow)
    (win2 'shaperectangles 'Set 'Bounding 'UnSorted 0 0
	  '((0 0 50 50) (40 40 100 150) (200 10 60 60) (50 200 200 10)))
    (scix-msg "win2 'shaperectangles done.~%")
    (win2 'changeproperty
	  'replace 'wm_name 'string 8 "SCIX: ShapeRectangles Test")
    (win2 'mapwindow)
;    (win2 'add-callback! 'ShapeNotify (lambda (event window)
;					(display "ShapeNotify event arrived")))
;    (win2 'ShapeSelectInput #t)
;    (win2 'shapemask 'Set 'Bounding 0 0 'None)
    (scr 'flush!)
    (scr 'sync! #f)
    (list win1 win2) ))
