;;;
;;;              Copyright 1991 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;; A pointer-tracker with a quit-button. Hakan Huss, KTH and Johan Ihren, KTH

;;; $Id: tracker.sc,v 2.2 91/09/15 01:02:12 johani Exp $

;;; Note that the only use for the "main program" is to be able to report how
;;; many lines has been drawn.

(module demotracker (top-level demo-tracker))

(include "../include/stox.sch")
(include "../include/scix.sch")

(include "../macros/extsyntax.sc")
(include "../macros/oos.sc")

(define (demo-tracker scr)
  (let* ((w (window 'make 'width 300 'height 300 'screen scr
		    'mask (make-window-value-mask
			   `(background-pixel ,(scr 'whitepixel))
			   `(event-mask ,(make-mask 'event
						    'PointerMotion
						    'ButtonPress)))))
	 (paint-gc (gc 'make (make-gc-value-mask
			      '(function Copy)
			      `(foreground ,(scr 'blackpixel)))
		       'screen scr))
	 (origin '(150 150))
	 (nr-of-lines 0)
	 (terminate #f)
	 (quit-button (button 'make 'x 20 'y 20 'screen scr 'parent w
			      'label "Quit"
			      'on-action (lambda (e)
					   (w 'destroywindow)
					   (paint-gc 'freegc)
					   (display
					    (format "~a lines drawn.~%"
						    nr-of-lines))
					   (scr 'flush!)
					   (set! terminate #t)
					   'done))) )
    (w 'add-callback! 'ButtonPress
       (lambda (event window)
	 (set! origin (list (event 'event-x) (event 'event-y))) ))
    (w 'add-callback! 'MotionNotify
       (lambda (event window)
	 (let ((new-line (polyline 'make 'origin
				   (list origin (list (event 'event-x)
						      (event 'event-y))))))
	   (set! nr-of-lines (+ 1 nr-of-lines))
	   (w 'draw (list new-line) paint-gc)
	   (scr 'flush!) )))

    (w 'changeproperty 'replace 'wm_name 'string 8 "SCIX Tracker")
    (quit-button 'stox-activate)
    (w 'mapwindow)
    (scr 'flush!)
    (scix-process-events scr) ))
    ;;(msg-handler 'mainloop (lambda () terminate) (list scr)) ))
